/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.extcommon.digitalstyle;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.extcommon.digitalstyle.ColorCondition;
import com.kingdee.bos.ctrl.extcommon.digitalstyle.CompositeFormat;
import com.kingdee.bos.ctrl.extcommon.digitalstyle.ConstantFormat;
import com.kingdee.bos.ctrl.extcommon.digitalstyle.DateTimeFormat;
import com.kingdee.bos.ctrl.extcommon.digitalstyle.DigitDecorateCondition;
import com.kingdee.bos.ctrl.extcommon.digitalstyle.DigitDecorateFormat;
import com.kingdee.bos.ctrl.extcommon.digitalstyle.Format;
import com.kingdee.bos.ctrl.extcommon.digitalstyle.Formats;
import com.kingdee.bos.ctrl.extcommon.digitalstyle.FractionFormat;
import com.kingdee.bos.ctrl.extcommon.digitalstyle.GeneralFormat;
import com.kingdee.bos.ctrl.extcommon.digitalstyle.LanguageCondition;
import com.kingdee.bos.ctrl.extcommon.digitalstyle.Node;
import com.kingdee.bos.ctrl.extcommon.digitalstyle.NumberFormat;
import com.kingdee.bos.ctrl.extcommon.digitalstyle.RegionCondition;
import com.kingdee.bos.ctrl.extcommon.digitalstyle.ScienceFormat;
import com.kingdee.bos.ctrl.extcommon.digitalstyle.SimpleFormat;
import com.kingdee.bos.ctrl.extcommon.digitalstyle.Symbols;
import com.kingdee.bos.ctrl.extcommon.digitalstyle.TextFormat;
import java.util.ArrayList;
import java.util.BitSet;

public class FormatParser {
    private static final int FORMAT_LIMIT = 3;
    private GlobalCache globalCache;
    private PartialCache partialCache;
    private CompositeFormat compositeFormat;
    boolean isParsingDate = false;

    public static void main(String[] args) {
        FormatParser fp = new FormatParser();
        fp.parse("0!.00,\"\u4e07\"", false);
    }

    private void reset() {
        this.globalCache = new GlobalCache();
        this.partialCache = null;
        this.compositeFormat = null;
    }

    public Format parse(String format, boolean ignoreError) {
        this.reset();
        if (StringUtil.isEmptyString((String)format)) {
            return ignoreError ? Formats.DEFAULT_FORMAT : Formats.ERROR_FORMAT;
        }
        if (!this.parseGlobal(format)) {
            return ignoreError ? Formats.DEFAULT_FORMAT : Formats.ERROR_FORMAT;
        }
        int formatInx = 0;
        int startInx = 0;
        while (true) {
            int endInx;
            if (!this.parseFormat(format, formatInx, startInx, (endInx = this.globalCache.separatorBits.nextSetBit(startInx)) < 0 ? format.length() - 1 : endInx - 1)) {
                return ignoreError ? Formats.DEFAULT_FORMAT : Formats.ERROR_FORMAT;
            }
            if (this.compositeFormat == null) {
                this.compositeFormat = new CompositeFormat();
            }
            this.compositeFormat.addFormat(this.partialCache.simpleFormat);
            if (endInx < 0) break;
            ++formatInx;
            startInx = endInx + 1;
        }
        return this.compositeFormat;
    }

    private boolean parseGlobal(String format) {
        return this.parseGlobalSimpleChar(format) && this.parseGlobalCompositeChars(format) && this.parseGlobalCount();
    }

    private boolean parseGlobalCount() {
        int i = 0;
        this.globalCache.formatCount = 0;
        while (i >= 0) {
            ++this.globalCache.formatCount;
            if (this.globalCache.formatCount > 4) {
                return false;
            }
            i = this.globalCache.separatorBits.nextSetBit(i + 1);
        }
        return true;
    }

    private boolean parseGlobalSimpleChar(String format) {
        int length = format.length();
        this.globalCache.transBits = new BitSet(length);
        this.globalCache.repeatBits = new BitSet(length);
        this.globalCache.blankBits = new BitSet(length);
        this.globalCache.separatorBits = new BitSet(length);
        block6: for (int i = 0; i < length; ++i) {
            char c = format.charAt(i);
            switch (c) {
                case '_': {
                    if (this.globalCache.repeatBits.get(i) || this.globalCache.transBits.get(i) || this.globalCache.separatorBits.get(i)) continue block6;
                    if (i + 1 > length - 1) {
                        return false;
                    }
                    this.globalCache.blankBits.set(i);
                    this.globalCache.blankBits.set(i + 1);
                    ++i;
                    continue block6;
                }
                case '*': {
                    if (this.globalCache.blankBits.get(i) || this.globalCache.transBits.get(i) || this.globalCache.separatorBits.get(i)) continue block6;
                    if (i + 1 > length - 1) {
                        return false;
                    }
                    this.globalCache.repeatBits.set(i);
                    this.globalCache.repeatBits.set(i + 1);
                    ++i;
                    continue block6;
                }
                case ';': {
                    if (this.globalCache.blankBits.get(i) || this.globalCache.transBits.get(i) || this.globalCache.repeatBits.get(i)) continue block6;
                    this.globalCache.separatorBits.set(i);
                    continue block6;
                }
                case '!': 
                case '\\': {
                    if (this.globalCache.blankBits.get(i) || this.globalCache.repeatBits.get(i) || this.globalCache.separatorBits.get(i)) continue block6;
                    if (i + 1 > length - 1) {
                        return false;
                    }
                    this.globalCache.transBits.set(i);
                    this.globalCache.transBits.set(i + 1);
                    ++i;
                    continue block6;
                }
            }
        }
        return true;
    }

    private boolean parseGlobalCompositeChars(String format) {
        int length = format.length();
        this.globalCache.constantBits = new BitSet(length);
        int index1 = -1;
        for (int i = 0; i < length; ++i) {
            char c = format.charAt(i);
            if (c != '\"') continue;
            if (index1 != -1) {
                this.globalCache.constantBits.set(index1, i + 1);
                this.globalCache.blankBits.clear(index1, i + 1);
                this.globalCache.repeatBits.clear(index1, i + 1);
                this.globalCache.transBits.clear(index1, i + 1);
                this.globalCache.separatorBits.clear(index1, i + 1);
                index1 = -1;
                continue;
            }
            if (this.globalCache.blankBits.get(i) || this.globalCache.repeatBits.get(i) || this.globalCache.transBits.get(i) || this.globalCache.separatorBits.get(i)) continue;
            index1 = i;
        }
        return index1 == -1;
    }

    private boolean parseFormat(String format, int formatIndex, int startIndex, int endIndex) {
        this.partialCache = new PartialCache();
        if (startIndex > endIndex) {
            this.partialCache.simpleFormat = new ConstantFormat();
            return true;
        }
        return this.parseFormatConditions(format, formatIndex, startIndex, endIndex) && this.parseGeneralFormat(format, startIndex, endIndex) && this.parseAmpmFormat(format, startIndex, endIndex) && this.parseFormatNodes(format, startIndex, endIndex) && this.createFormat(formatIndex);
    }

    private boolean createFormat(int formatIndex) {
        int type = this.partialCache.formatType;
        if (formatIndex == 3) {
            if (type == 3) {
                this.partialCache.simpleFormat = new TextFormat();
            } else if (type == 4) {
                this.partialCache.simpleFormat = new GeneralFormat();
            } else if (type == -1) {
                this.partialCache.simpleFormat = new ConstantFormat();
            } else {
                return false;
            }
            this.partialCache.simpleFormat.setColorCondition(this.partialCache.cc);
            this.partialCache.simpleFormat.setNodes(this.partialCache.nodes);
            return true;
        }
        SimpleFormat actualFormat = null;
        if (type == 2) {
            DateTimeFormat dtf = new DateTimeFormat();
            if (this.partialCache.ampmBits != null && !this.partialCache.ampmBits.isEmpty()) {
                dtf.setAM_PM(true);
            }
            actualFormat = dtf;
        } else if (type == 5) {
            String pattern = this.partialCache.pattern.toString();
            int fIndex = pattern.indexOf(47);
            if (fIndex >= pattern.length()) {
                return false;
            }
            boolean sureDenom = false;
            boolean unsureDenom = false;
            for (int i = fIndex + 1; i < pattern.length(); ++i) {
                char c = pattern.charAt(i);
                if (c == '?' || c == '#') {
                    if (sureDenom) {
                        return false;
                    }
                    unsureDenom = true;
                    continue;
                }
                if (c == '0') continue;
                if (unsureDenom) {
                    return false;
                }
                sureDenom = true;
            }
            FractionFormat ff = new FractionFormat();
            ff.setHasSign(formatIndex == 0);
            ff.setSureDenom(sureDenom);
            ff.setNumerPattern(pattern.substring(0, fIndex));
            ff.setDenomPattern(pattern.substring(fIndex + 1));
            ff.setFractionIndex(this.partialCache.fractionIndex);
            actualFormat = ff;
        } else if (type == 4) {
            actualFormat = new GeneralFormat();
        } else if (type == 1) {
            NumberFormat nf = new NumberFormat();
            nf.setHasSign(formatIndex == 0);
            nf.setDecimalSepIndex(this.partialCache.decSepIndex);
            nf.setHasGroupSep(this.partialCache.hasGroupSep);
            nf.setPercent(this.partialCache.isPercent);
            nf.setPattern(this.partialCache.pattern.toString());
            actualFormat = nf;
        } else if (type == 6) {
            String pattern = this.partialCache.pattern.toString();
            int eIndex = pattern.indexOf(101);
            if (eIndex >= pattern.length() - 1) {
                return false;
            }
            ScienceFormat sf = new ScienceFormat();
            sf.setPattern(pattern);
            sf.setHasSign(formatIndex == 0);
            sf.setDecIndex(this.partialCache.decSepIndex);
            sf.setDecIndex2(this.partialCache.decSepIndex2);
            sf.setHasGroupSep(this.partialCache.hasGroupSep);
            sf.setHasGroupSep2(this.partialCache.hasGroupSep2);
            sf.setScienceIndex(this.partialCache.scienceIndex);
            actualFormat = sf;
        } else {
            actualFormat = type == 3 ? new TextFormat() : new ConstantFormat();
        }
        actualFormat.setColorCondition(this.partialCache.cc);
        actualFormat.setNodes(this.partialCache.nodes);
        DigitDecorateFormat digitFormat = new DigitDecorateFormat(actualFormat);
        if (actualFormat instanceof DateTimeFormat) {
            ((DateTimeFormat)actualFormat).setLanguageCondition(this.partialCache.lc);
        } else {
            digitFormat.setLanguageCondition(this.partialCache.lc);
        }
        digitFormat.setNumberCondition(this.partialCache.nc);
        this.partialCache.simpleFormat = digitFormat;
        return true;
    }

    private boolean parseAmpmFormat(String format, int startIndex, int endIndex) {
        int index;
        int end = endIndex - Symbols.getAmpm().length() + 1;
        String ampm = Symbols.getAmpm().toLowerCase();
        for (int i = startIndex; i <= end && (index = format.toLowerCase().indexOf(ampm, i)) >= 0 && index <= end && !this.globalCache.isUsed(index); ++i) {
            if (this.partialCache.ampmBits == null) {
                this.partialCache.ampmBits = new BitSet();
            }
            this.partialCache.ampmBits.set(index, index + ampm.length());
            i = index + ampm.length();
        }
        return true;
    }

    private boolean parseGeneralFormat(String format, int startIndex, int endIndex) {
        int index1 = format.toLowerCase().indexOf(Symbols.getGeneral().toLowerCase(), startIndex);
        if (index1 >= 0 && index1 < endIndex && !this.globalCache.isUsed(index1)) {
            int index2 = format.toLowerCase().indexOf(Symbols.getGeneral(), index1 + 1);
            if (index2 < endIndex && index2 > 0) {
                return false;
            }
            this.partialCache.generalBits = new BitSet();
            this.partialCache.generalBits.set(index1, index1 + Symbols.getGeneral().length());
            this.partialCache.formatType = 4;
        }
        return true;
    }

    private boolean parseFormatNodes(String format, int startIndex, int endIndex) {
        this.partialCache.nodes = new ArrayList();
        this.partialCache.pattern = new StringBuffer();
        StringBuffer typeBuffer = null;
        for (int i = startIndex; i <= endIndex; ++i) {
            boolean patternCharOk;
            char c = format.toLowerCase().charAt(i);
            if (this.globalCache.isUsed(i)) {
                if (typeBuffer != null) {
                    patternCharOk = this.appendPatternChars(typeBuffer);
                    if (!patternCharOk) {
                        return false;
                    }
                    typeBuffer = null;
                }
                i = this.appendSepicalChar(format, i);
                continue;
            }
            if (this.partialCache.isGeneralUsed(i)) {
                if (typeBuffer != null) {
                    patternCharOk = this.appendPatternChars(typeBuffer);
                    if (!patternCharOk) {
                        return false;
                    }
                    typeBuffer = null;
                }
                i = this.appendGeneral(i);
                continue;
            }
            if (this.partialCache.isAmpmUsed(i)) {
                if (typeBuffer != null) {
                    patternCharOk = this.appendPatternChars(typeBuffer);
                    if (!patternCharOk) {
                        return false;
                    }
                    typeBuffer = null;
                }
                this.partialCache.nodes.add(Node.AMPM);
                i += Symbols.getAmpm().length() - 1;
                continue;
            }
            if (typeBuffer == null) {
                typeBuffer = new StringBuffer();
                typeBuffer.append(c);
            } else if (typeBuffer.charAt(0) == c) {
                typeBuffer.append(c);
            } else {
                patternCharOk = this.appendPatternChars(typeBuffer);
                if (!patternCharOk) {
                    return false;
                }
                typeBuffer = new StringBuffer();
                typeBuffer.append(c);
            }
            if (i != endIndex || (patternCharOk = this.appendPatternChars(typeBuffer))) continue;
            return false;
        }
        return true;
    }

    private int appendGeneral(int i) {
        this.partialCache.nodes.add(Node.General);
        return i + Symbols.getGeneral().length() - 1;
    }

    private boolean appendNumberChar(StringBuffer source) {
        char c = source.charAt(0);
        if (this.partialCache.formatType == 2 || this.partialCache.formatType == 4 || this.partialCache.formatType == 3) {
            return false;
        }
        if (this.partialCache.formatType == -1) {
            this.partialCache.formatType = 1;
        }
        Node node = c == '#' ? Node.Digit : (c == '0' ? Node.Digit_zero : Node.Digit_question);
        for (int i = source.length() - 1; i >= 0; --i) {
            this.partialCache.nodes.add(node);
            this.partialCache.pattern.append(c);
        }
        return true;
    }

    private boolean appendDateTimeChar(StringBuffer source) {
        char c = source.charAt(0);
        if (this.partialCache.formatType != -1 && this.partialCache.formatType != 2) {
            return false;
        }
        this.partialCache.formatType = 2;
        if (c == 'y') {
            if (source.length() < 4) {
                this.partialCache.nodes.add(Node.Year_two);
            } else {
                this.partialCache.nodes.add(Node.Year_four);
            }
        } else if (c == 'm') {
            Node tempNode;
            int i;
            for (i = this.partialCache.nodes.size() - 1; i >= 0 && (!(tempNode = (Node)this.partialCache.nodes.get(i)).isDateTime() || tempNode != Node.Hour_one && tempNode != Node.Hour_two); --i) {
            }
            if (i >= 0) {
                if (source.length() < 2) {
                    this.partialCache.nodes.add(Node.Mintue_one);
                } else {
                    this.partialCache.nodes.add(Node.Mintue_two);
                }
            } else {
                int len = source.length();
                switch (len) {
                    case 1: {
                        this.partialCache.nodes.add(Node.Month_one);
                        break;
                    }
                    case 2: {
                        this.partialCache.nodes.add(Node.Month_two);
                        break;
                    }
                    case 3: {
                        this.partialCache.nodes.add(Node.Month_three);
                        break;
                    }
                    case 4: {
                        this.partialCache.nodes.add(Node.Month_four);
                        break;
                    }
                    default: {
                        this.partialCache.nodes.add(Node.Month_five);
                    }
                }
            }
        } else if (c == 'd') {
            if (source.length() < 2) {
                this.partialCache.nodes.add(Node.Date_one);
            } else {
                this.partialCache.nodes.add(Node.Date_two);
            }
        } else if (c == 'h') {
            if (source.length() < 2) {
                this.partialCache.nodes.add(Node.Hour_one);
            } else {
                this.partialCache.nodes.add(Node.Hour_two);
            }
        } else if (source.length() < 2) {
            this.partialCache.nodes.add(Node.Second_one);
        } else {
            this.partialCache.nodes.add(Node.Second_two);
        }
        return true;
    }

    private boolean appendTextChar(StringBuffer source) {
        if (this.partialCache.formatType != -1 && this.partialCache.formatType != 3) {
            return false;
        }
        this.partialCache.formatType = 3;
        this.partialCache.nodes.add(Node.Text);
        return true;
    }

    private boolean appendGroupSep(StringBuffer source) {
        if (this.partialCache.formatType == 1) {
            for (int i = 0; i < source.length(); ++i) {
                this.partialCache.nodes.add(Node.KillSp);
            }
        } else if (this.partialCache.formatType == 6) {
            this.partialCache.nodes.add(Node.KillSp);
            this.partialCache.hasGroupSep2 = true;
        } else {
            this.partialCache.nodes.add(Node.KillSp);
        }
        return true;
    }

    private boolean appendDecimalSep(StringBuffer source) {
        if (this.partialCache.formatType == 1) {
            this.partialCache.nodes.add(Node.Decimal_sep);
            this.partialCache.pattern.append('.');
            this.partialCache.decSepIndex = this.partialCache.nodes.size() - 1;
        } else if (this.partialCache.formatType == 6) {
            this.partialCache.nodes.add(Node.Decimal_sep);
            this.partialCache.pattern.append('.');
            this.partialCache.decSepIndex2 = this.partialCache.nodes.size() - 1;
        } else {
            if (this.partialCache.formatType == 5) {
                return false;
            }
            this.partialCache.nodes.add(new Node(25, '.'));
        }
        return true;
    }

    private boolean appendFraction(StringBuffer source) {
        if (source.length() > 1) {
            return false;
        }
        if (this.partialCache.formatType == 1 && this.partialCache.decSepIndex == -1) {
            this.partialCache.nodes.add(Node.Fraction);
            this.partialCache.pattern.append('/');
            this.partialCache.fractionIndex = this.partialCache.nodes.size() - 1;
            this.partialCache.formatType = 5;
            return true;
        }
        return false;
    }

    private boolean appendPercent(StringBuffer source) {
        if (source.length() > 1) {
            return false;
        }
        this.partialCache.nodes.add(Node.Precent);
        if (this.partialCache.isPercent) {
            return false;
        }
        this.partialCache.isPercent = true;
        return true;
    }

    private boolean appendScience(StringBuffer source) {
        if (source.length() > 1) {
            return false;
        }
        if (this.partialCache.formatType == 1) {
            this.partialCache.nodes.add(Node.Science);
            this.partialCache.pattern.append('e');
            this.partialCache.scienceIndex = this.partialCache.nodes.size() - 1;
            this.partialCache.formatType = 6;
            return true;
        }
        return false;
    }

    private boolean appendNormal(StringBuffer source) {
        char c = source.charAt(0);
        if (Symbols.isA(c)) {
            if (source.length() == 3) {
                if (this.partialCache.formatType != -1 && this.partialCache.formatType != 2) {
                    return false;
                }
                this.partialCache.formatType = 2;
                this.partialCache.nodes.add(Node.Day_three);
            } else if (source.length() >= 4) {
                if (this.partialCache.formatType != -1 && this.partialCache.formatType != 2) {
                    return false;
                }
                this.partialCache.formatType = 2;
                this.partialCache.nodes.add(Node.Day_four);
            } else if (source.length() == 1) {
                this.partialCache.nodes.add(new Node(27, source.toString()));
            } else {
                this.partialCache.nodes.add(new Node(25, source.toString()));
            }
        } else if (this.partialCache.formatType == 5) {
            if (c >= '1' && c <= '9') {
                this.partialCache.pattern.append(c);
                this.partialCache.nodes.add(new Node(25, new StringBuffer().append(c).toString()));
            }
        } else {
            this.partialCache.nodes.add(new Node(25, source.toString()));
        }
        return true;
    }

    private boolean appendPatternChars(StringBuffer source) {
        char c = source.charAt(0);
        if (Symbols.isNumberChar(c)) {
            if (!this.partialCache.nodes.isEmpty() && (Node)this.partialCache.nodes.get(this.partialCache.nodes.size() - 1) == Node.KillSp) {
                this.partialCache.hasGroupSep = true;
            }
            return this.appendNumberChar(source);
        }
        if (Symbols.isDateTime(c)) {
            this.isParsingDate = true;
            return this.appendDateTimeChar(source);
        }
        if (Symbols.isText(c)) {
            return this.appendTextChar(source);
        }
        if (Symbols.isGroupSeparator(c)) {
            return this.appendGroupSep(source);
        }
        if (Symbols.isDecimalSeparator(c)) {
            return this.appendDecimalSep(source);
        }
        if (Symbols.isFraction(c) && !this.isParsingDate) {
            return this.appendFraction(source);
        }
        if (Symbols.isScience(c)) {
            return this.appendScience(source);
        }
        if (Symbols.isPercent(c)) {
            return this.appendPercent(source);
        }
        return this.appendNormal(source);
    }

    private int appendSepicalChar(String format, int index) {
        if (this.globalCache.blankBits.get(index)) {
            this.partialCache.nodes.add(new Node(25, " "));
            return index + 1;
        }
        if (this.globalCache.transBits.get(index)) {
            this.partialCache.nodes.add(new Node(25, format.substring(index + 1, index + 2)));
            return index + 1;
        }
        if (this.globalCache.repeatBits.get(index)) {
            if (index == this.globalCache.repeatBits.length() - 2) {
                this.partialCache.nodes.add(new Node(24, format.substring(index + 1, index + 2)));
            }
            return index + 1;
        }
        if (this.globalCache.constantBits.get(index)) {
            char c = format.charAt(index);
            if (c != '\"') {
                this.partialCache.nodes.add(new Node(25, format.substring(index, index + 1)));
            }
            return index;
        }
        return index;
    }

    private boolean parseFormatConditions(String format, int formatIndex, int startIndex, int endIndex) {
        this.partialCache.nc = null;
        this.partialCache.cc = null;
        this.partialCache.lc = null;
        if (this.globalCache.conditionBits == null) {
            this.globalCache.conditionBits = new BitSet(format.length());
        }
        int index1 = -1;
        for (int i = startIndex; i <= endIndex; ++i) {
            if (this.globalCache.blankBits.get(i) || this.globalCache.repeatBits.get(i) || this.globalCache.separatorBits.get(i) || this.globalCache.transBits.get(i) || this.globalCache.constantBits.get(i)) continue;
            char c = format.charAt(i);
            if (c == '[') {
                index1 = i;
                continue;
            }
            if (c != ']') continue;
            if (index1 == -1) {
                return false;
            }
            String condition = format.toLowerCase().substring(index1 + 1, i);
            if (DigitDecorateCondition.isCondition(condition)) {
                if (this.partialCache.nc == null) {
                    this.partialCache.nc = new DigitDecorateCondition(condition);
                    this.globalCache.conditionBits.set(index1, i + 1);
                    index1 = -1;
                    continue;
                }
                return false;
            }
            if (ColorCondition.isColorCondition(condition)) {
                if (this.partialCache.cc == null) {
                    this.partialCache.cc = new ColorCondition(condition);
                    this.globalCache.conditionBits.set(index1, i + 1);
                    index1 = -1;
                    continue;
                }
                return false;
            }
            if (LanguageCondition.isLanguageCondition(condition)) {
                if (this.partialCache.lc == null) {
                    this.partialCache.lc = new LanguageCondition(condition);
                    this.globalCache.conditionBits.set(index1, i + 1);
                    index1 = -1;
                    continue;
                }
                return false;
            }
            if (!RegionCondition.isRegionCondition(condition)) continue;
            this.globalCache.conditionBits.set(index1, i + 1);
        }
        return this.ensureNumberCondition(formatIndex);
    }

    private boolean ensureNumberCondition(int formatIndex) {
        if (formatIndex >= 2 && this.partialCache.nc != null) {
            return false;
        }
        if (this.partialCache.nc == null) {
            if (formatIndex == 0 && this.globalCache.formatCount >= 3) {
                this.partialCache.nc = DigitDecorateCondition.MORE_THAN_ZERO;
            } else if (formatIndex == 0 && this.globalCache.formatCount == 2) {
                this.partialCache.nc = DigitDecorateCondition.NO_FEWER_THAN_ZERO;
            } else if (formatIndex == 1 && this.globalCache.formatCount >= 3) {
                this.partialCache.nc = DigitDecorateCondition.FEWER_THAN_ZERO;
            }
        }
        return true;
    }

    private class PartialCache {
        SimpleFormat simpleFormat;
        int formatType = -1;
        DigitDecorateCondition nc = null;
        ColorCondition cc = null;
        LanguageCondition lc = null;
        ArrayList nodes;
        StringBuffer pattern;
        boolean hasGroupSep = false;
        boolean hasGroupSep2 = false;
        boolean isPercent = false;
        int decSepIndex = -1;
        int decSepIndex2 = -1;
        int fractionIndex = -1;
        int scienceIndex = -1;
        BitSet generalBits;
        BitSet ampmBits;

        private PartialCache() {
        }

        boolean isGeneralUsed(int i) {
            return this.generalBits != null && this.generalBits.get(i);
        }

        boolean isAmpmUsed(int i) {
            return this.ampmBits != null && this.ampmBits.get(i);
        }
    }

    private class GlobalCache {
        BitSet blankBits;
        BitSet repeatBits;
        BitSet separatorBits;
        BitSet transBits;
        BitSet conditionBits;
        BitSet constantBits;
        int formatCount;

        private GlobalCache() {
        }

        boolean isUsed(int index) {
            return this.blankBits.get(index) || this.repeatBits.get(index) || this.separatorBits.get(index) || this.transBits.get(index) || this.constantBits.get(index) || this.conditionBits.get(index);
        }
    }
}

