/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.expans.model;

import com.kingdee.bos.ctrl.common.hyperlink.HyperLink;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.extcommon.variant.Variant;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.kds.expans.model.ExtConst;
import com.kingdee.bos.ctrl.kds.expans.model.ExtProps;
import com.kingdee.bos.ctrl.kds.expans.model.IPreCondition;
import com.kingdee.bos.ctrl.kds.expans.model.collection.SortedExtPropFormulasArray;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExternalTargets;
import com.kingdee.bos.ctrl.kds.expans.model.data.HyperlinkCalculableProps;
import com.kingdee.bos.ctrl.kds.model.expr.Expr;
import com.kingdee.bos.ctrl.kds.model.expr.ExprContext;
import com.kingdee.bos.ctrl.kds.model.struct.Cell;
import com.kingdee.bos.ctrl.kds.model.struct.CellPropAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.WeakHashMap;

class CellPropAction_HyperLink
extends CellPropAction {
    private static final WeakHashMap _hyperLinks = new WeakHashMap();

    private static synchronized HyperLink getHyperLink(String linkString) {
        Object obj = _hyperLinks.get(linkString);
        if (obj == null) {
            obj = new HyperLink(null, linkString);
            _hyperLinks.put(linkString, obj);
        }
        return (HyperLink)obj;
    }

    CellPropAction_HyperLink(int intKey, String strKey) {
        super(intKey, strKey);
    }

    @Override
    public void action(Cell cll, Variant value) {
        HyperlinkCalculableProps prop = (HyperlinkCalculableProps)value.getValue();
        String linkString = prop.getLinkString();
        boolean hyper = true;
        boolean isExecute = false;
        ExprContext ctx = cll.getSheet().getDeps().getExprContext();
        ExtProps props = cll.getExtProps(false);
        SortedExtPropFormulasArray formulas = props.getFormulas(false);
        HashMap hypers = ((HyperlinkCalculableProps)formulas.get(ExtConst.FORMULA_HYPERLINK)).getTargets();
        if (hypers != null) {
            Iterator iter = hypers.keySet().iterator();
            while (iter.hasNext()) {
                Object obj = hypers.get(iter.next());
                if (!isExecute && obj instanceof IPreCondition) {
                    IPreCondition condition = (IPreCondition)obj;
                    Expr expr = condition == null ? null : condition.getBehaviorAction();
                    Variant v = CellPropAction_HyperLink.executeBehavior(ctx, expr, cll);
                    try {
                        if (v != null) {
                            hyper = v.booleanValue();
                        }
                        if (!hyper) {
                            StyleAttributes sa = Styles.getSA((ShareStyleAttributes)cll.getSSA());
                            sa.setFontColor(condition.getBehaviorFontColor());
                            cll.setSSA((ShareStyleAttributes)sa);
                        }
                    }
                    catch (SyntaxErrorException ex) {
                        hyper = true;
                    }
                    isExecute = true;
                }
                if (!(obj instanceof ExternalTargets)) continue;
                ((ExternalTargets)obj).calc(ctx, cll);
            }
        }
        if (!StringUtil.isEmptyString((String)linkString) && hyper) {
            this.hyperLink(cll, CellPropAction_HyperLink.getHyperLink(linkString));
        }
    }

    static Variant executeBehavior(ExprContext ctx, Expr expr, Cell cll) {
        Variant v = null;
        if (expr == null) {
            return v;
        }
        boolean traceMode = ctx.isTraceMode();
        ctx.setTraceMode(false);
        if (ctx.isCalcLastMode()) {
            ctx.setCalcLastMode(false);
            v = expr.execute(ctx, null).getVariant();
            ctx.setCalcLastMode(true);
        } else {
            v = expr.execute(ctx, cll).getVariant();
        }
        ctx.setTraceMode(traceMode);
        return v;
    }
}

