/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.expans.model.data;

import com.kingdee.bos.ctrl.common.KDToolkit;
import com.kingdee.bos.ctrl.extcommon.util.ObjectArray;
import com.kingdee.bos.ctrl.extcommon.variant.ExprErr;
import com.kingdee.bos.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.extcommon.variant.Variant;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtDataSet;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtRow;
import com.kingdee.bos.ctrl.kds.model.expr.Expr;
import com.kingdee.bos.ctrl.kds.model.expr.ExprContext;
import com.kingdee.bos.ctrl.kds.model.expr.IExprBuffer;
import com.kingdee.bos.ctrl.kds.model.expr.IExprNode;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.bos.ctrl.kds.model.struct.Dependents;
import com.kingdee.bos.ctrl.kds.model.struct.ICalculable;
import com.kingdee.bos.ctrl.kds.model.struct.Span;
import com.kingdee.bos.ctrl.kds.model.struct.node.NamedObjectNode;
import com.kingdee.bos.ctrl.kds.model.util.ObjectStack;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;

public class ExtGroup
implements Cloneable {
    private ExtDataSet _ds;
    private ExtRow[] _rows;
    private int _from;
    private int _to;
    private Variant[] _values;
    private int _vFrom;
    private int _vTo;
    private Variant _varThis;
    private ExtRow _markRow;

    public ExtGroup(ExtDataSet ds, ExtRow[] rows) {
        this._ds = ds;
        this.setRows(rows);
    }

    public ExtGroup(ExtDataSet ds, ExtRow[] rows, int from, int to) {
        this._ds = ds;
        this.setRows(rows, from, to);
    }

    public int size() {
        return this._to - this._from;
    }

    public boolean isNullGroup() {
        return this._to <= this._from;
    }

    public Object clone() {
        Object[] rows = new ExtRow[this.size()];
        KDToolkit.arraycopy((Object[])this._rows, (int)this._from, (Object[])rows, (int)0, (int)(this._to - this._from));
        return new ExtGroup(this._ds, (ExtRow[])rows);
    }

    public String toString() {
        if (this.size() == 0) {
            return "G[]";
        }
        StringBuffer sb = new StringBuffer("G[");
        sb.append(this._rows[this._from]);
        for (int i = this._from + 1; i < this._to; ++i) {
            sb.append(',').append(this._rows[i]);
        }
        sb.append(']');
        return sb.toString();
    }

    public static boolean isGroup(Variant var) {
        return var != null && var.isObject() && var.getValue() instanceof ExtGroup;
    }

    public static boolean isDataset(Variant var) {
        return var != null && var.isObject() && var.getValue() instanceof ExtDataSet;
    }

    public Variant getVar() {
        if (this._varThis == null) {
            this._varThis = new Variant(this, 17);
        }
        return this._varThis;
    }

    public ExtDataSet getDataSet() {
        return this._ds;
    }

    public int getFrom() {
        return this._from;
    }

    public int getTo() {
        return this._to;
    }

    public int getValueFrom() {
        return this._vFrom;
    }

    public int getValueTo() {
        return this._vTo;
    }

    public ExtRow getRow(int index) {
        return this._rows[this._from + index];
    }

    public ExtRow getFirstRow() {
        return this.isNullGroup() ? this._ds.getNullRow() : this._rows[this._from];
    }

    public ExtRow getLastRow() {
        return this.isNullGroup() ? this._ds.getNullRow() : this._rows[this._to - 1];
    }

    public ExtRow getMarkRow() {
        return this._markRow;
    }

    public void setMarkRow(ExtRow row) {
        this._markRow = row;
    }

    public ExtRow[] getRows() {
        return this._rows;
    }

    public void setRows(ExtRow[] rows) {
        this._rows = rows;
        this._from = 0;
        this._to = rows.length;
    }

    public void setRows(ExtRow[] rows, int from, int to) {
        this._rows = rows;
        this._from = from;
        this._to = to;
    }

    public Variant getFirstValue() {
        return this._values[this._vFrom];
    }

    public void setFirstValue(Variant var) {
        this._values[this._vFrom] = var;
    }

    public Variant[] getValues() {
        return this._values;
    }

    void setValues(Variant[] values) {
        this._values = values;
        this._vFrom = 0;
        this._vTo = values.length;
    }

    void setValues(Variant[] values, int from, int to) {
        this._values = values;
        this._vFrom = from;
        this._vTo = to;
    }

    public ExtGroup filterRow(ExprContext ctx, Variant filterExp, ExtGroup out) throws SyntaxErrorException {
        int size = this.size();
        ObjectArray al = ctx.getBuffer().getObjectArray(Math.max(10, size >> 3));
        for (int i = this._from; i < this._to; ++i) {
            ExtRow row = this._rows[i];
            this._ds.setCurrentRow(row);
            Variant var = this._ds.calc(ctx, filterExp);
            if (!var.booleanValue()) continue;
            al.append(row);
        }
        if (al.size() < size) {
            Object[] rows = new ExtRow[al.size()];
            al.toArray(rows, 0);
            if (out == null) {
                out = new ExtGroup(this._ds, (ExtRow[])rows);
            } else {
                out.setRows((ExtRow[])rows);
            }
            out._values = null;
            out._vTo = 0;
            out._vFrom = 0;
        } else {
            out = (ExtGroup)this.clone();
        }
        ctx.getBuffer().recycleArray(al);
        return out;
    }

    public ExtRow filterFirstRow(ExprContext ctx, Variant filterExp) throws SyntaxErrorException {
        for (int i = this._from; i < this._to; ++i) {
            ExtRow row = this._rows[i];
            this._ds.setCurrentRow(row);
            Variant var = this._ds.calc(ctx, filterExp);
            if (!var.booleanValue()) continue;
            return row;
        }
        return null;
    }

    public static Variant getDynamicFieldExpr(ExprContext ctx, ExtDataSet ds, Variant varExpr) {
        ICalculable owner;
        Expr expr;
        Expr newExpr = null;
        if (varExpr.isObject() && (expr = (Expr)varExpr.getValue()).hasNamedObject() && ((owner = ctx.getExprOwner()).getExpr() != null || owner.getExpr().isDynamicDataset() || expr.hasUndefinedNamedObject())) {
            Book book = owner.getSheet().getBook();
            Dependents buffer = book.getDeps();
            ObjectStack stack = buffer.getStack();
            stack.push(ds);
            newExpr = book.getDataSetManager().replaceField(buffer, stack, owner, expr, ds);
            buffer.recycleStack(stack);
        }
        return newExpr == null ? varExpr : newExpr.getVarThis();
    }

    public void separate(ExprContext ctx, boolean isSeparate, Variant[] exprs, ObjectArray[] rowsArray, Variant[] groupValues, boolean keepDefaultGroup) throws SyntaxErrorException {
        ICalculable owner = ctx.getExprOwner();
        if (owner.getExpr().isDynamicDataset()) {
            for (int i = 0; i < exprs.length; ++i) {
                exprs[i] = ExtGroup.getDynamicFieldExpr(ctx, this._ds, exprs[i]);
            }
        }
        int defaultIndex = rowsArray.length - 1;
        for (int i = this._from; i < this._to; ++i) {
            Variant valueExp;
            ExtRow row = this._rows[i];
            this._ds.setCurrentRow(row);
            boolean match = false;
            for (int e = 0; e < exprs.length; ++e) {
                Variant valueExp2;
                Variant var = this._ds.calc(ctx, exprs[e]);
                if (!var.booleanValue()) continue;
                ObjectArray oa = rowsArray[e];
                if (oa.isEmpty() && ((valueExp2 = groupValues[e]).getVt() == 3 || valueExp2.getValue() instanceof Expr)) {
                    groupValues[e] = this._ds.calc(ctx, valueExp2);
                }
                oa.append(row);
                match = true;
                if (isSeparate) break;
            }
            if (!keepDefaultGroup || match) continue;
            ObjectArray oa = rowsArray[defaultIndex];
            if (oa.isEmpty() && ((valueExp = groupValues[defaultIndex]).getVt() == 3 || valueExp.getValue() instanceof Expr)) {
                groupValues[defaultIndex] = this._ds.calc(ctx, valueExp);
            }
            oa.append(row);
        }
    }

    public final void sort(ExprContext ctx, Variant sortExp, boolean desc) throws SyntaxErrorException {
        RowComparator cmp = new RowComparator(ctx, sortExp, desc);
        Arrays.sort(this._rows, this._from, this._to, cmp);
    }

    public final void sort(ExprContext ctx, Variant[] aSort, boolean[] aDesc) throws SyntaxErrorException {
        RowComparator cmp = new RowComparator(ctx, aSort, aDesc);
        Arrays.sort(this._rows, this._from, this._to, cmp);
    }

    public final void sortGroup(ExprContext ctx, Variant[] groups, Variant sortExp, Variant varDesc) throws SyntaxErrorException {
        GroupComparator cmp;
        boolean desc = true;
        if (!varDesc.isNull()) {
            desc = varDesc.getValue() instanceof Expr ? ((Expr)varDesc.getValue()).execute(ctx, ctx.getExprOwner()).booleanValue() : varDesc.booleanValue();
        }
        if (!(cmp = new GroupComparator(ctx, sortExp, desc)).isValidExpr()) {
            ExprErr.goError(16L, "\u7ec4\u6392\u5e8f\u8868\u8fbe\u5f0f");
        }
        Arrays.sort(groups, cmp);
    }

    public final Variant[] filterGroup(ExprContext ctx, Variant[] groups, Variant filterExp) throws SyntaxErrorException {
        if (groups.length == 0) {
            return groups;
        }
        ExtDataSet ds = ((ExtGroup)groups[0].getValue()).getDataSet();
        ObjectArray aKeeps = ctx.getBuffer().getObjectArray(groups.length);
        for (int i = 0; i < groups.length; ++i) {
            ExtGroup grp = (ExtGroup)groups[i].getValue();
            Variant grpValue = grp.getFirstValue();
            ds.setCurrentGroup(grp);
            ds.setCurrentRow(grp.getFirstRow());
            if (ds.calc(ctx, filterExp).booleanValue()) {
                aKeeps.append(grp.getVar());
            }
            grp.setFirstValue(grpValue);
        }
        if (aKeeps.size() < groups.length) {
            groups = new Variant[aKeeps.size()];
            aKeeps.toArray(groups, 0);
        }
        ctx.getBuffer().recycleArray(aKeeps);
        return groups;
    }

    public Variant group(ExprContext ctx, Variant selExp) {
        this.setValues(this._ds.select(this, ctx, selExp));
        IExprBuffer buffer = ctx.getBuffer();
        ObjectArray aGroups = buffer.getObjectArray(0);
        Span sp = null;
        Span spValue = null;
        Variant var = null;
        int i = this._from;
        int v = this._vFrom;
        while (i < this._to) {
            Variant var2 = this._values[v];
            if (var != var2) {
                sp = new Span(i, i);
                spValue = new Span(v, v);
                aGroups.append(sp);
                aGroups.append(spValue);
            }
            if (null != sp) {
                sp.setEnd(i);
            }
            if (null != spValue) {
                spValue.setEnd(v);
            }
            var = var2;
            ++i;
            ++v;
        }
        Variant[] groups = new Variant[aGroups.size() >> 1];
        int i2 = 0;
        int size = aGroups.size();
        int g = 0;
        while (i2 < size) {
            Span sp2 = (Span)aGroups.get(i2);
            Span spValue2 = (Span)aGroups.get(i2 + 1);
            ExtGroup group = new ExtGroup(this._ds, this._rows, sp2.getStart(), sp2.getEnd() + 1);
            group.setValues(this._values, spValue2.getStart(), spValue2.getEnd() + 1);
            groups[g] = group.getVar();
            i2 += 2;
            ++g;
        }
        buffer.recycleArray(aGroups);
        Variant varRet = groups.length == 0 ? this._ds.getNullGroup().getVar() : new Variant(groups, 527);
        return varRet;
    }

    private class GroupComparator
    implements Comparator {
        private HashMap _valueBuffer;
        private ExprContext _ctx;
        private Variant _expr;
        private boolean _desc;
        private int _colIndex;

        GroupComparator(ExprContext ctx, Variant sortExp, boolean desc) {
            this._ctx = ctx;
            this._desc = desc;
            this._valueBuffer = new HashMap();
            if (sortExp.getVt() == 3) {
                this._colIndex = (Integer)sortExp.getValue();
            } else {
                this._colIndex = -1;
                this._expr = sortExp;
            }
        }

        boolean isValidExpr() {
            boolean bValid = true;
            if (this._expr != null) {
                Expr expr = (Expr)this._expr.getValue();
                if (expr.isSyntaxError()) {
                    bValid = false;
                } else if (expr.hasNamedObject()) {
                    IExprNode[] nodes = expr.getExprParams().getNodes();
                    for (int i = 0; i < nodes.length; ++i) {
                        IExprNode node = nodes[i];
                        if (node.getExprType() != 8 || !((NamedObjectNode)node).isUndefined()) continue;
                        bValid = false;
                        break;
                    }
                }
            }
            return bValid;
        }

        public int compare(Object o1, Object o2) {
            int cmp;
            ExtGroup g1 = (ExtGroup)((Variant)o1).getValue();
            ExtGroup g2 = (ExtGroup)((Variant)o2).getValue();
            Variant var = (Variant)this._valueBuffer.get(g1);
            Variant var2 = (Variant)this._valueBuffer.get(g2);
            if (var == null || var2 == null) {
                ExtDataSet ds = g1.getDataSet();
                if (this._colIndex >= 0) {
                    if (var == null) {
                        ds.setCurrentRow(g1.getFirstRow());
                        var = ds.field(this._colIndex);
                        this._valueBuffer.put(g1, var);
                    }
                    if (var2 == null) {
                        ds.setCurrentRow(g2.getFirstRow());
                        var2 = ds.field(this._colIndex);
                        this._valueBuffer.put(g2, var2);
                    }
                } else {
                    if (var == null) {
                        ds.setCurrentGroup(g1);
                        ds.setCurrentRow(g1.getFirstRow());
                        try {
                            var = ds.calc(this._ctx, this._expr);
                        }
                        catch (SyntaxErrorException syntaxErrorException) {
                            // empty catch block
                        }
                        this._valueBuffer.put(g1, var);
                    }
                    if (var2 == null) {
                        ds.setCurrentGroup(g2);
                        ds.setCurrentRow(g2.getFirstRow());
                        try {
                            var2 = ds.calc(this._ctx, this._expr);
                        }
                        catch (SyntaxErrorException syntaxErrorException) {
                            // empty catch block
                        }
                        this._valueBuffer.put(g2, var2);
                    }
                }
            }
            try {
                cmp = var.compareTo(var2);
            }
            catch (SyntaxErrorException e) {
                cmp = -1;
            }
            return this._desc ? -cmp : cmp;
        }
    }

    private class RowComparator
    implements Comparator {
        private ExprContext _ctx;
        private ICalculable _exprOwner;
        private Expr[] _aExpr;
        private boolean[] _aDesc;
        private int[] _aColIndex;
        private HashMap _valueBuffer;

        RowComparator(ExprContext ctx, Variant sortExp, boolean desc) {
            this._ctx = ctx;
            this._exprOwner = ctx.getExprOwner();
            this._valueBuffer = new HashMap(ExtGroup.this.size());
            this._aExpr = new Expr[1];
            this._aDesc = new boolean[1];
            this._aColIndex = new int[1];
            Object obj = sortExp.getValue();
            int vt = sortExp.getVt();
            if (vt == 3) {
                this._aColIndex[0] = (Integer)obj;
            } else if (vt == 11) {
                Variant varCol = ExtGroup.this._ds.getColumnIndex(((String)obj).toUpperCase());
                this._aColIndex[0] = varCol == Variant.intMinValue ? 0 : (Integer)varCol.getValue();
            } else {
                this._aExpr[0] = (Expr)obj;
                this._aColIndex[0] = -1;
            }
            this._aDesc[0] = desc;
        }

        RowComparator(ExprContext ctx, Variant[] aSort, boolean[] aDesc) {
            this._ctx = ctx;
            this._exprOwner = ctx.getExprOwner();
            this._valueBuffer = new HashMap(ExtGroup.this.size());
            this._aDesc = aDesc;
            this._aExpr = new Expr[aSort.length];
            this._aColIndex = new int[this._aExpr.length];
            for (int i = 0; i < aSort.length; ++i) {
                Variant sortExp = aSort[i];
                Object obj = sortExp.getValue();
                int vt = sortExp.getVt();
                if (vt == 3) {
                    this._aColIndex[i] = (Integer)obj;
                    continue;
                }
                if (vt == 11) {
                    Variant varCol = ExtGroup.this._ds.getColumnIndex(((String)obj).toUpperCase());
                    if (varCol == Variant.intMinValue) {
                        this._aColIndex[i] = 0;
                        continue;
                    }
                    this._aColIndex[i] = (Integer)varCol.getValue();
                    continue;
                }
                this._aExpr[i] = (Expr)obj;
                this._aColIndex[i] = -1;
            }
        }

        public int compare(Object o1, Object o2) {
            ExtRow r1 = (ExtRow)o1;
            ExtRow r2 = (ExtRow)o2;
            int cmp = 0;
            try {
                for (int i = 0; i < this._aExpr.length; ++i) {
                    Variant var = this.getValue(r1, i);
                    Variant var2 = this.getValue(r2, i);
                    if (var == null || var2 == null) {
                        int colIndex = this._aColIndex[i];
                        if (colIndex >= 0) {
                            if (var == null) {
                                ExtGroup.this._ds.setCurrentRow(r1);
                                var = ExtGroup.this._ds.field(colIndex);
                                this.putValue(r1, i, var);
                            }
                            if (var2 == null) {
                                ExtGroup.this._ds.setCurrentRow(r2);
                                var2 = ExtGroup.this._ds.field(colIndex);
                                this.putValue(r2, i, var2);
                            }
                        } else {
                            Expr expr = this._aExpr[i];
                            if (var == null) {
                                ExtGroup.this._ds.setCurrentRow(r1);
                                var = expr.execute(this._ctx, this._exprOwner).getVariant();
                                this.putValue(r1, i, var);
                            }
                            if (var2 == null) {
                                ExtGroup.this._ds.setCurrentRow(r2);
                                var2 = expr.execute(this._ctx, this._exprOwner).getVariant();
                                this.putValue(r2, i, var2);
                            }
                        }
                    }
                    if ((cmp = var.compareTo(var2)) == 0) continue;
                    if (this._aDesc[i]) {
                        cmp = -cmp;
                    }
                    break;
                }
            }
            catch (SyntaxErrorException e) {
                cmp = -1;
            }
            return cmp;
        }

        private Variant getValue(ExtRow row, int index) {
            Variant[] array = (Variant[])this._valueBuffer.get(row);
            return array == null ? null : array[index];
        }

        private void putValue(ExtRow row, int index, Variant value) {
            Variant[] array = (Variant[])this._valueBuffer.get(row);
            if (array == null) {
                array = new Variant[this._aExpr.length];
                this._valueBuffer.put(row, array);
            }
            array[index] = value;
        }
    }
}

