/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.expans.model.innerlink.exec;

import com.kingdee.bos.ctrl.common.hyperlink.IHyperLinkExec;
import com.kingdee.bos.ctrl.ext.fulfil.ExtGuiExecutor;
import com.kingdee.bos.ctrl.ext.immit.ExtHyperLinkAssembler;
import com.kingdee.bos.ctrl.ext.immit.IExtRuntimeDataProvider;
import com.kingdee.bos.ctrl.kds.exec.ExecutionContext;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtDataSet;
import com.kingdee.bos.ctrl.kds.expans.model.data.IParameter;
import com.kingdee.bos.ctrl.kds.expans.model.innerlink.exec.AbstractHyperLinkExec;
import com.kingdee.bos.ctrl.kds.impl.SpreadContext;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.bos.ctrl.kds.model.struct.Cell;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.embed.ChartRectEmbedment;
import com.kingdee.bos.ctrl.kds.model.struct.embed.EmbedObject;
import com.kingdee.bos.ctrl.kds.model.struct.embed.EmbedhLayer;
import com.kingdee.bos.ctrl.kds.model.struct.embed.subrpt.SubReportEmbed;
import java.util.Map;
import javax.swing.SwingUtilities;

public abstract class AbstractInnerLinkExec
implements IHyperLinkExec {
    protected ExtGuiExecutor _guiExecutor;
    protected Book _book;
    private SpreadContext _context;
    private IExtRuntimeDataProvider _dataProvider;

    public AbstractInnerLinkExec(ExtGuiExecutor guiExecutor, SpreadContext context, IExtRuntimeDataProvider dataProvider) {
        this._guiExecutor = guiExecutor;
        this._context = context;
        this._dataProvider = dataProvider;
        this.init();
    }

    public void execute(String linkTo) {
        this.init();
    }

    private void init() {
        if (this._guiExecutor != null) {
            this._book = this._guiExecutor.getBook();
        } else if (this._context != null) {
            this._book = this._context.getBook();
        }
    }

    protected void execute(String targetType, final String linkName, final Map<String, IParameter> params) {
        final Book book = this._book;
        if ("fusionChart".equals(targetType)) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ExecutionContext ctx = book.getDataSetManager().getExecutionContext();
                    Map oldParams = ctx.getDataSetParameters();
                    ctx.setDataSetParameters(params);
                    ChartRectEmbedment chart = ExtHyperLinkAssembler.getChartEmbedmentByName(book, linkName);
                    if (chart != null) {
                        ExecutionContext eCtx = new ExecutionContext(null);
                        eCtx.setDataSetParameters(params);
                        String datasetName = chart.getModel().getDataNode().getFromDataset().getDatasetName();
                        ExtDataSet dataset = book.getDataSetManager().getDataSetByName(datasetName);
                        AbstractInnerLinkExec.this._dataProvider.linkParamsDefaultValue(new ExtDataSet[]{dataset}, eCtx);
                        chart.executeRefresh();
                    }
                    ctx.setDataSetParameters(oldParams);
                }
            });
        } else if (this._guiExecutor != null) {
            String[] arrName = linkName.split("!");
            if (arrName == null || arrName.length != 2) {
                return;
            }
            String sheetName = arrName[0];
            Sheet sheet = book.getSheet(sheetName);
            EmbedhLayer layer = sheet.getEmbedments(false);
            if (layer == null || layer.size() == 0) {
                return;
            }
            EmbedhLayer.EmbedIterator iter = layer.getIterator(true);
            while (iter.hasNext()) {
                SubReportEmbed rptEmbed;
                Cell cell;
                EmbedObject eObject = iter.next();
                if (!(eObject instanceof SubReportEmbed) || !(cell = (rptEmbed = (SubReportEmbed)eObject).getCell()).getName(false, true).equals(linkName)) continue;
                AbstractHyperLinkExec.executeParamsDefaultValue(this._guiExecutor.getDataProvider(), params, rptEmbed.getSubReportInfo().getReportProps());
                byte[] bookData = rptEmbed.getSubReportInfo().getBookData();
                Book subBook = this._guiExecutor.getSubReportGuiExecutor().exec(cell, bookData, params);
                SpreadContext subContext = (SpreadContext)((Object)rptEmbed.getPhysicalUI());
                if (subContext == null) break;
                subContext.setBook(subBook);
                break;
            }
        }
    }
}

