/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.impl.facade.fairy;

import com.kingdee.bos.ctrl.common.CtrlUIEnv;
import com.kingdee.bos.ctrl.kds.impl.icons.ResourceManager;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDFrame;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.ctrl.swing.KDRadioButtonMenuItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class FairyButton
extends KDButton {
    static final Color back = Color.white;
    static final Color move_color = new Color(128, 128, 192, 128);
    static final byte NORMAL = 1;
    static final byte PRE_POP = 2;
    static final byte POP = 3;
    private boolean _isMouseOn;
    private Dimension _prefSize;
    private MyButtonGroup _btnGroup;
    private KDPopupMenu _popupMenu;

    public static void main(String[] args) {
        CtrlUIEnv.setKingdeeLAF();
        KDFrame frame = new KDFrame();
        frame.setDefaultCloseOperation(3);
        frame.setSize(400, 300);
        frame.getContentPane().setLayout(null);
        frame.getContentPane().setBackground(Color.red);
        FairyButton o = new FairyButton(ResourceManager.getImageIcon("fill_option.gif"));
        o.setSize(22, 22);
        o.addAssistMenuItem((JMenuItem)new KDRadioButtonMenuItem("Save"));
        o.addAssistMenuItem((JMenuItem)new KDRadioButtonMenuItem("Open"));
        o.addAssistMenuItem((JMenuItem)new KDRadioButtonMenuItem("Save"));
        o.addAssistMenuItem((JMenuItem)new KDRadioButtonMenuItem("Save As"));
        frame.getContentPane().add((Component)((Object)o));
        o.setBounds(0, 0, 22, 22);
        frame.setVisible(true);
    }

    public FairyButton() {
        this.init();
    }

    public FairyButton(Icon icon) {
        super(icon);
        this.init();
    }

    private void init() {
        this._btnGroup = new MyButtonGroup();
        this.setLimitedSize(false);
        this.setBackground(back);
        this.setMargin(new Insets(1, 1, 1, 1));
        this.addMouseListener(new MouseHandler());
        this.getAssistPopup().addPopupMenuListener((PopupMenuListener)new PopupHandler());
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this._isMouseOn && !this.getAssistPopup().isVisible()) {
            g.setColor(move_color);
            ((Graphics2D)g).fill(this.getVisibleRect());
        }
        if (this._isMouseOn) {
            this.paintWorkArrowButton(g);
        }
    }

    public Dimension getPreferredSize() {
        if (this._prefSize == null) {
            this._prefSize = new Dimension();
        }
        if (this._isMouseOn) {
            this._prefSize.setSize(42, 24);
        } else {
            this._prefSize.setSize(24, 24);
        }
        return this._prefSize;
    }

    public JMenuItem addAssistMenuItem(Action action) {
        JMenuItem tempMI = this.getAssistPopup().add(action);
        this._btnGroup.add(tempMI);
        return tempMI;
    }

    public JMenuItem addAssistMenuItem(JMenuItem menuItem) {
        if (menuItem != null) {
            this.getAssistPopup().add(menuItem);
            this._btnGroup.add(menuItem);
        }
        return menuItem;
    }

    public void addSeparator() {
        this.getAssistPopup().addSeparator();
    }

    public void removeAllItems() {
        if (this._popupMenu != null) {
            this._popupMenu.removeAll();
            this._btnGroup.removeAll();
            this._btnGroup.clearSelection();
        }
    }

    private KDPopupMenu getAssistPopup() {
        if (this._popupMenu == null) {
            this._popupMenu = new KDPopupMenu();
        }
        return this._popupMenu;
    }

    private void changeState(byte srcState, byte desState) {
        if (srcState == 1 && desState == 2) {
            this.setMargin(new Insets(1, 1, 1, 14));
            this.setSize(this.getPreferredSize());
        } else if (srcState == 2 && desState == 1) {
            this.setMargin(new Insets(1, 1, 1, 1));
            this.setSize(this.getPreferredSize());
        } else if (desState == 1) {
            Insets insets = this.getInsets();
            insets.top = 1;
            insets.bottom = 1;
            insets.left = 1;
            insets.right = 1;
            this.setMargin(insets);
            this.setSize(this.getPreferredSize());
        }
        this.repaint();
    }

    private void paintWorkArrowButton(Graphics g) {
        Insets cIn = this.getInsets();
        cIn = cIn != null ? cIn : new Insets(0, 0, 0, 0);
        int startX = this.getWidth() - cIn.right + 1;
        int startY = this.getHeight() / 2 - 2;
        int centerX = startX + 6;
        Polygon triangle = new Polygon();
        triangle.addPoint(centerX - 3, startY);
        triangle.addPoint(centerX + 3, startY);
        triangle.addPoint(centerX, startY + 3);
        g.setColor(Color.black);
        ((Graphics2D)g).fill(triangle);
    }

    private class PopupHandler
    implements PopupMenuListener {
        private PopupHandler() {
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            if (FairyButton.this._isMouseOn) {
                FairyButton.this.changeState((byte)3, (byte)2);
            } else {
                FairyButton.this.changeState((byte)3, (byte)1);
            }
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            FairyButton.this._isMouseOn = true;
            if (!FairyButton.this.getAssistPopup().isVisible()) {
                FairyButton.this.changeState((byte)1, (byte)2);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            FairyButton.this._isMouseOn = false;
            if (!FairyButton.this.getAssistPopup().isVisible()) {
                FairyButton.this.changeState((byte)2, (byte)1);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            KDPopupMenu pop = FairyButton.this.getAssistPopup();
            if (pop.isVisible()) {
                pop.setVisible(false);
                FairyButton.this.changeState((byte)3, (byte)2);
            } else {
                int showx = 0;
                int showy = FairyButton.this.getHeight();
                pop.show((Component)((Object)FairyButton.this), showx, showy);
                FairyButton.this.changeState((byte)2, (byte)3);
            }
        }
    }

    private class MyButtonGroup
    extends ButtonGroup {
        private MyButtonGroup() {
        }

        void removeAll() {
            if (this.buttons != null) {
                this.buttons.removeAllElements();
            }
        }
    }
}

