/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.impl.facade.wizzard;

import com.kingdee.bos.ctrl.ext.reporting.ReportingFactory;
import com.kingdee.bos.ctrl.ext.reporting.model.ValueEditorType;
import com.kingdee.bos.ctrl.ext.reporting.model.design.ICellConstraint;
import com.kingdee.bos.ctrl.ext.reporting.model.design.IEditorDefine;
import com.kingdee.bos.ctrl.ext.reporting.model.design.NullEditorDefine;
import com.kingdee.bos.ctrl.ext.reporting.model.design.validation.CellEditorSettingPanel;
import com.kingdee.bos.ctrl.ext.ui.icons.ResourceManager;
import com.kingdee.bos.ctrl.ext.util.MessageUtil;
import com.kingdee.bos.ctrl.ext.util.MiscUtil;
import com.kingdee.bos.ctrl.kds.impl.SpreadContext;
import com.kingdee.bos.ctrl.kds.impl.facade.MultiLanguageKeys;
import com.kingdee.bos.ctrl.kds.impl.facade.rangesel.RangeSelector;
import com.kingdee.bos.ctrl.kds.impl.facade.wizzard.ISpreadWizzard;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.bos.ctrl.kds.model.struct.CellBlock;
import com.kingdee.bos.ctrl.kds.model.struct.Selection;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.kds.model.struct.validate.Validation;
import com.kingdee.bos.ctrl.kds.model.struct.validate.ValidationList;
import com.kingdee.bos.ctrl.kds.model.struct.validate.util.MessagedValidate;
import com.kingdee.bos.ctrl.kds.model.struct.validate.util.Validate;
import com.kingdee.bos.ctrl.kds.model.util.IntArray;
import com.kingdee.bos.ctrl.kds.model.util.SortedCellBlockArray;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDList;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public final class WizzardValidation
extends KDDialog
implements ISpreadWizzard {
    private static final long serialVersionUID = 1L;
    private KDButton _btnOk;
    private KDButton _btnCancel;
    private SpreadContext _context;
    private CellEditorSettingPanel _contentPanel;
    private ListSelectionListener _allValidationsLisener;
    private KDList _allValidations;
    private RangeSelector selector;
    private DelegateCellConstraint _constraint = new DelegateCellConstraint();
    private Verify _currentVerify;
    private ValidationList _currentValidationList;

    public WizzardValidation(Frame parent, SpreadContext context) {
        super(parent, true);
        this._context = context;
        this.initComps();
        this.layoutComps();
        this.initListeners();
    }

    public WizzardValidation(Dialog parent, SpreadContext context) {
        super(parent, true);
        this._context = context;
        this.initComps();
        this.layoutComps();
        this.initListeners();
    }

    @Override
    public void commit() {
    }

    @Override
    public boolean prepare() {
        this._contentPanel.disablePKValueProvider();
        Book book = this._context.getBook();
        Sheet activeSheet = book.getActiveSheet();
        this._currentValidationList = MiscUtil.cloneValidations(activeSheet);
        this.prepareValidation();
        this.initListData();
        if (this._allValidations.getElementCount() > 0) {
            this._allValidations.setSelectedIndex(0);
            this._currentVerify = (Verify)this._allValidations.getElement(0);
        }
        return true;
    }

    private void prepareValidation() {
        if (this._currentVerify != null) {
            this._constraint._editorDefine = this._currentVerify._v.getEditorDefine();
            this._constraint._mv = this._currentVerify._v.getMessagedValidate();
        } else {
            this._constraint._editorDefine = new NullEditorDefine();
            this._constraint._mv = new MessagedValidate();
        }
        this._contentPanel.selectionChange(null, this._constraint);
    }

    private void initListData() {
        this._allValidations.removeListSelectionListener(this._allValidationsLisener);
        this._allValidations.removeAllElements();
        int size = this._currentValidationList.size();
        for (int i = 0; i < size; ++i) {
            Validation v = this._currentValidationList.getValidation(i);
            this._allValidations.addElement((Object)new Verify(v));
        }
        this._allValidations.addListSelectionListener(this._allValidationsLisener);
        if (size > 0) {
            this._allValidations.setSelectedIndex(0);
        }
    }

    private void initComps() {
        this.selector = new RangeSelector(this._context, "\u9009\u62e9\u5355\u5143\u683c\u533a\u57df");
        this._btnOk = new KDButton(MultiLanguageKeys.getLocalText("KEY_OK", ""));
        this._btnCancel = new KDButton(MultiLanguageKeys.getLocalText("KEY_CANCEL", ""));
        this._allValidations = new KDList();
        this._allValidations.setCellRenderer((ListCellRenderer)new DefaultListCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component ret = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                Verify v = (Verify)value;
                if (v._v != null && v._v.isReportingValidation()) {
                    this.setIcon(ResourceManager.getImageIcon("ctrl_textfield.gif"));
                } else {
                    this.setIcon(null);
                }
                return ret;
            }
        });
        this._allValidations.setPreferredSize(new Dimension(200, 0));
        this._contentPanel = new CellEditorSettingPanel(this._context, this._constraint);
        KDToolBar bar = new KDToolBar();
        AbstractAction insertValidationAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (WizzardValidation.this.commitLast()) {
                    WizzardValidation.this.selector.showOpposite();
                }
            }
        };
        insertValidationAction.putValue("Name", "\u65b0\u589e");
        insertValidationAction.putValue("SmallIcon", ResourceManager.getImageIcon("tbtn_New.gif"));
        bar.add((Action)insertValidationAction);
        AbstractAction removeValidationAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Verify v = (Verify)WizzardValidation.this._allValidations.getSelectedValue();
                int index = WizzardValidation.this._allValidations.getElementCount() - 2;
                if (index >= 0) {
                    WizzardValidation.this._allValidations.setSelectedIndex(index);
                    WizzardValidation.this._currentVerify = (Verify)WizzardValidation.this._allValidations.getElement(index);
                } else {
                    WizzardValidation.this._currentVerify = null;
                }
                Validation src = WizzardValidation.this._currentValidationList.getValidationContainer(v._v.getBlocks());
                if (src != null) {
                    src.getBlocks().clear();
                }
                WizzardValidation.this._currentValidationList.reduce();
                WizzardValidation.this.initListData();
            }
        };
        removeValidationAction.putValue("Name", "\u5220\u9664");
        removeValidationAction.putValue("SmallIcon", ResourceManager.getImageIcon("tbtn_Delete.gif"));
        bar.add((Action)removeValidationAction);
        this.addToolBar((JToolBar)bar);
    }

    private void layoutComps() {
        this.setSize(670, 485);
        this.setResizable(false);
        KDPanel ctrlPanel = new KDPanel();
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this._allValidations, "West");
        container.add((Component)this._contentPanel.getMainTab());
        container.add((Component)ctrlPanel, "South");
        this._contentPanel.getMainTab().setOpaque(false);
        ctrlPanel.setLayout((LayoutManager)new FlowLayout(2));
        ctrlPanel.setOpaque(false);
        this.selector.setSize(100, 20);
        this.selector.setVisible(false);
        ctrlPanel.add((Component)this.selector);
        ctrlPanel.add((Component)this._btnOk);
        ctrlPanel.add((Component)this._btnCancel);
    }

    private void initListeners() {
        ButtonActionHandler buttonActionHandler = new ButtonActionHandler();
        this._btnOk.addActionListener((ActionListener)buttonActionHandler);
        this._btnCancel.addActionListener((ActionListener)buttonActionHandler);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                WizzardValidation.this.closeDialog();
            }
        });
        this._allValidationsLisener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                WizzardValidation.this.switchCurrentVerify();
            }
        };
        this._allValidations.addListSelectionListener(this._allValidationsLisener);
    }

    private void switchCurrentVerify() {
        Verify v = (Verify)this._allValidations.getSelectedValue();
        if (v != null) {
            this._constraint._editorDefine = v._v.getEditorDefine();
            this._constraint._mv = v._v.getMessagedValidate();
        }
        DelegateCellConstraint stub = new DelegateCellConstraint();
        stub._mv = new MessagedValidate();
        this._contentPanel.selectionChange(stub, this._constraint);
        if (v != null && !v._v.isReportingValidation()) {
            this._contentPanel.disablePKValueProvider();
        }
        if (this.commitLast()) {
            if (this._currentVerify != null) {
                this._currentVerify._v.setEditorDefine(stub._editorDefine);
                this._currentVerify._v.setMessagedValidate(stub._mv);
            }
            this._currentVerify = v;
        } else if (this._currentVerify == null) {
            this._currentVerify = v;
        }
    }

    private void closeDialog() {
        this._currentVerify = null;
        this.setVisible(false);
        this.dispose();
    }

    private boolean verifyConfliction(Sheet activeSheet, SortedCellBlockArray arr) {
        boolean ret = true;
        IntArray intersects = new IntArray();
        boolean allSeted = this._currentValidationList.calcIntersects(arr, intersects);
        int count = intersects.size();
        if (count > 1) {
            boolean b = MessageUtil.msgboxOkCancel((Component)((Object)this._context), MultiLanguageKeys.getLocalText("KEY_VALIDATION_Message_MultiValidations", "\u9009\u5b9a\u533a\u57df\u5305\u542b\u591a\u79cd\u6570\u636e\u6709\u6548\u6027\u3002\u662f\u5426\u6e05\u9664\u5f53\u524d\u8bbe\u7f6e\u5e76\u7ee7\u7eed!"));
            if (b) {
                for (int i = 0; i < intersects.size(); ++i) {
                    Validation v = this._currentValidationList.getValidation(intersects.get(i));
                    if (v == null) continue;
                    v.getBlocks().clear();
                }
                this._currentValidationList.reduce();
                this.initListData();
            }
            ret = b;
        } else if (count == 1) {
            if (!allSeted) {
                boolean b = MessageUtil.msgboxOkCancel((Component)((Object)this._context), MultiLanguageKeys.getLocalText("KEY_VALIDATION_Message_SomeNoValidation", "\u9009\u5b9a\u533a\u57df\u67d0\u4e9b\u5355\u5143\u683c\u672a\u8bbe\u7f6e\u6570\u636e\u6709\u6548\u6027\u3002\u662f\u5426\u5bf9\u5176\u5b9e\u65bd\u5f53\u524d\u7684\u6570\u636e\u6709\u6548\u6027\u8bbe\u7f6e"));
                if (b) {
                    this._currentValidationList.getValidation(intersects.get(0)).setBlocks(arr);
                    this.initListData();
                }
                ret = false;
            } else {
                boolean b = MessageUtil.msgboxOkCancel((Component)((Object)this._context), "\u9009\u5b9a\u533a\u57df\u5355\u5143\u683c\u6570\u636e\u6709\u6548\u6027\u5df2\u7ecf\u8bbe\u7f6e\u8bbe\u7f6e\u3002\u662f\u5426\u62c6\u5206\u5f53\u524d\u7684\u6570\u636e\u6709\u6548\u6027\u8bbe\u7f6e");
                if (b) {
                    Validation v = this._currentValidationList.getValidation(intersects.get(0));
                    SortedCellBlockArray src = v.getBlocks();
                    src.insertAll(arr);
                    src.mergeSelf();
                    boolean splited = false;
                    for (int i = 0; i < arr.size(); ++i) {
                        splited = splited ? true : src.remove(arr.getBlock(i)) != null;
                    }
                    this.initListData();
                    b = splited;
                }
                ret = b;
            }
        }
        return ret;
    }

    private boolean commitLast() {
        if (this._allValidations.getElementCount() == 0) {
            return true;
        }
        MessagedValidate mv = this.buildNewValidate();
        if (mv == null) {
            return false;
        }
        Sheet sheet = this._context.getBook().getActiveSheet();
        if (this._currentVerify != null) {
            Validation vali = this._currentValidationList.getValidationContainer(this._currentVerify._v.getBlocks());
            if (vali == null) {
                this.insertNewValidation(this._currentVerify._v.getMessagedValidate(), sheet, this._currentVerify._v.getBlocks());
            } else {
                vali.setEditorDefine(this._currentVerify._v.getEditorDefine());
                vali.setMessagedValidate(mv);
            }
        }
        return true;
    }

    private MessagedValidate buildNewValidate() {
        int check;
        MessagedValidate retMV = new MessagedValidate();
        boolean isEmpty = this._contentPanel.getVerifyIntegratePanel().isEmptyValidate();
        if (!isEmpty && !Validate.isOk(check = this._contentPanel.getVerifyIntegratePanel().updateValidate(retMV))) {
            String msg = null;
            msg = Validate.isSyntaxError(check) ? MultiLanguageKeys.getLocalText("KEY_VALIDATION_Error_syntax", "\u5b57\u6bb5\u7684\u8f93\u5165\u516c\u5f0f\u5b58\u5728\u8bed\u6cd5\u9519\u8bef!") : (Validate.isValueError(check) ? MultiLanguageKeys.getLocalText("KEY_VALIDATION_Error_value", "\u5b57\u6bb5\u7684\u6570\u503c\u65e0\u6cd5\u6b63\u5e38\u89e3\u6790!") : MultiLanguageKeys.getLocalText("KEY_VALIDATION_Error_minmax", "\u63d0\u4ea4\u9519\u8bef:\u6700\u5927\u503c\u5fc5\u987b\u5927\u4e8e\u6216\u7b49\u4e8e\u6700\u5c0f\u503c!"));
            this._context.getFacadeManager().showErrorMessageBox(msg, 64);
            return null;
        }
        return retMV;
    }

    private void insertNewValidation(MessagedValidate retMV, Sheet sheet, SortedCellBlockArray sa) {
        if (sa.isEmpty()) {
            return;
        }
        sa.mergeSelf();
        this._currentValidationList.insertValidation(sheet, retMV, sa);
        Validation v = this._currentValidationList.getValidationContainer(sa);
        v.setReportingValidation(false);
        v.setEditorDefine(this._currentVerify._v.getEditorDefine());
        v.setMessagedValidate(retMV);
    }

    public void setVisible(boolean b) {
        if (b) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Selection selection = WizzardValidation.this.selector.getSelection();
                    if (selection.size() != 0) {
                        Sheet sheet = WizzardValidation.this._context.getBook().getActiveSheet();
                        SortedCellBlockArray source = new SortedCellBlockArray();
                        for (int i = 0; i < selection.size(); ++i) {
                            source.insert(selection.getBlock(i));
                        }
                        if (WizzardValidation.this.verifyConfliction(sheet, source)) {
                            Validation nv = new Validation(sheet, new MessagedValidate(), source);
                            nv.setReportingValidation(false);
                            WizzardValidation.this._currentValidationList.addValidationAt(nv, 0);
                            WizzardValidation.this.initListData();
                        }
                    }
                }
            });
        } else {
            this.selector.setText(null);
            this.selector.getSelection().clear();
        }
        super.setVisible(b);
    }

    private class Verify {
        Validation _v;

        public Verify(Validation v) {
            this._v = v;
        }

        public String toString() {
            return this._v.getSheet().getSheetName() + "!" + SheetBaseMath.getBlocksA1Name(this._v.getBlocks(), false);
        }

        public boolean equals(Object another) {
            if (another instanceof Verify) {
                if (this._v == null) {
                    return ((Verify)another)._v == null;
                }
                return this._v.equals(((Verify)another)._v);
            }
            return false;
        }
    }

    private class DelegateCellConstraint
    implements ICellConstraint {
        private IEditorDefine _editorDefine = ReportingFactory.fetchRuntimeProvider().generateDesignEditorDefine(ValueEditorType.TEXTFIELD);
        private MessagedValidate _mv;

        private DelegateCellConstraint() {
        }

        @Override
        public CellBlock getCellBlock() {
            return null;
        }

        @Override
        public Sheet getSheet() {
            return null;
        }

        @Override
        public IEditorDefine getEditorDefine() {
            return this._editorDefine == null ? new NullEditorDefine() : this._editorDefine;
        }

        @Override
        public void setEditorDefine(IEditorDefine ed) {
            this._editorDefine = ed;
        }

        @Override
        public MessagedValidate getVerifyDefine() {
            return this._mv;
        }
    }

    private class ButtonActionHandler
    implements ActionListener {
        private ButtonActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object o = e.getSource();
            if (o == WizzardValidation.this._btnOk) {
                DelegateCellConstraint stub = new DelegateCellConstraint();
                stub._mv = new MessagedValidate();
                WizzardValidation.this._contentPanel.selectionChange(stub, WizzardValidation.this._constraint);
                if (WizzardValidation.this._currentVerify != null) {
                    ((WizzardValidation)WizzardValidation.this)._currentVerify._v.setEditorDefine(stub._editorDefine);
                    ((WizzardValidation)WizzardValidation.this)._currentVerify._v.setMessagedValidate(stub._mv);
                }
                if (WizzardValidation.this.commitLast()) {
                    Book book = WizzardValidation.this._context.getBook();
                    Sheet activeSheet = book.getActiveSheet();
                    ValidationList vl = activeSheet.getValidations();
                    for (int i = 0; i < vl.size(); ++i) {
                        Validation v = vl.getValidation(i);
                        v.getBlocks().clear();
                    }
                    vl.reduce();
                    int size = WizzardValidation.this._allValidations.getElementCount();
                    for (int i = 0; i < size; ++i) {
                        Verify v = (Verify)WizzardValidation.this._allValidations.getElement(i);
                        vl.addValidation(v._v);
                    }
                    WizzardValidation.this.closeDialog();
                }
            } else {
                WizzardValidation.this.closeDialog();
            }
        }
    }
}

