/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.impl.state.mouse;

import com.kingdee.bos.ctrl.ext.util.MiscUtil;
import com.kingdee.bos.ctrl.kds.core.ICellDisplayProvider;
import com.kingdee.bos.ctrl.kds.core.KDSpread;
import com.kingdee.bos.ctrl.kds.core.SpreadView;
import com.kingdee.bos.ctrl.kds.impl.SelectionAdapter;
import com.kingdee.bos.ctrl.kds.impl.SpreadContext;
import com.kingdee.bos.ctrl.kds.impl.icons.ResourceManager;
import com.kingdee.bos.ctrl.kds.impl.state.SpreadStateManager;
import com.kingdee.bos.ctrl.kds.impl.state.mouse.DefaultMouseController;
import com.kingdee.bos.ctrl.kds.impl.state.mouse.DefaultMouseState;
import com.kingdee.bos.ctrl.kds.impl.state.mouse.IMouseState;
import com.kingdee.bos.ctrl.kds.impl.state.util.KDSpreadHelper;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.bos.ctrl.kds.model.struct.Cell;
import com.kingdee.bos.ctrl.kds.model.struct.CellBlock;
import com.kingdee.bos.ctrl.kds.model.struct.PasteMode;
import com.kingdee.bos.ctrl.kds.model.struct.Protection;
import com.kingdee.bos.ctrl.kds.model.struct.Range;
import com.kingdee.bos.ctrl.kds.model.struct.Selection;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.kds.model.struct.SortedAttributeSpanArray;
import com.kingdee.bos.ctrl.kds.model.struct.SortedColumnArray;
import com.kingdee.bos.ctrl.kds.model.struct.Span;
import com.kingdee.bos.ctrl.kds.model.struct.embed.EmbedhLayer;
import com.kingdee.bos.ctrl.kds.model.util.IntMarkEntry;
import com.kingdee.bos.ctrl.kds.model.util.SortedSpanArray;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;
import javax.swing.JPopupMenu;

public class ColMouseController
extends DefaultMouseController {
    private static final float RESIZE_BUFFER_LENGTH = 2.0f;
    private static final int SELECT_COLUMN = 1;
    private static final int RESIZE_COLUMN = 2;
    private static final int RESIZE_HIDE_COLUMN = 3;
    private static final int STYLE_BRUSH = 4;
    private static final int STYLE_FETCH = 5;
    private int _stateFlag;
    private IMouseState _ss;
    private IMouseState _rs;
    private SpreadContext _context;
    private int _lastCol;
    private int _lastPX;
    private int _lastColX;
    private int _pressCol;
    private int _pressColX;
    private int _pressPX;
    private boolean _isResizing = false;
    private boolean resizable = true;
    private int[] hideColsIndex;

    public boolean isResizing() {
        return this._isResizing;
    }

    public int getOffset() {
        return this._lastPX - this._pressPX;
    }

    public int getCurCol() {
        return this._lastCol;
    }

    public int getPressCol() {
        return this._pressCol;
    }

    public int getCurColVirtualW() {
        return this._lastPX - this._lastColX;
    }

    public ColMouseController(SpreadContext context) {
        this._context = context;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this._stateFlag = 1;
        Point p = e.getPoint();
        int px = p.x;
        SpreadView view = (SpreadView)e.getSource();
        Sheet sheet = view.getSpread().getBook().getActiveSheet();
        SortedAttributeSpanArray colSpans = sheet.getColSpans();
        int col = SheetBaseMath.colAtPoint(sheet, p);
        Protection pro = sheet.getSheetOption().getProtection(false);
        if (pro != null && !pro.allowFormattingColumns()) {
            this._pressCol = SheetBaseMath.dealInvalidCol(col);
            this._stateFlag = 1;
            return;
        }
        if (col == -1) {
            if ((float)SheetBaseMath.getSheetWidth(sheet) + 2.0f >= (float)px && px > 0) {
                this._pressCol = 65535;
                int index = colSpans.searchSpan(this._pressCol);
                this._stateFlag = index < 0 || colSpans.getAttributeSpan(index).isVisible() ? 2 : 3;
            }
            return;
        }
        int colX = SheetBaseMath.getColX(sheet, col);
        if ((float)px <= (float)colX + 2.0f && col > 0) {
            this._pressCol = col - 1;
            int index = colSpans.searchSpan(this._pressCol);
            if (index < 0 || colSpans.getAttributeSpan(index).isVisible()) {
                this._stateFlag = this._pressCol < view.getFirstCol() ? 1 : 2;
            } else if (this.resizable) {
                this._stateFlag = 3;
            } else {
                p.setLocation(p.x - 5, p.y);
                this._pressCol = col = SheetBaseMath.colAtPoint(sheet, p);
                this._stateFlag = 2;
            }
        } else if ((float)px >= (float)(colX + SheetBaseMath.getColWidth(sheet, col) + 1) - 2.0f) {
            this._pressCol = col;
            this._stateFlag = 2;
        } else {
            this._pressCol = col;
            this._stateFlag = 1;
        }
        if (this._context.getStateManager().isState(SpreadStateManager.Key_Style_Brush)) {
            this._stateFlag = 4;
        } else if (this._context.getStateManager().isState(SpreadStateManager.Key_Style_Fetch)) {
            this._stateFlag = 5;
        }
        switch (this._stateFlag) {
            case 4: {
                view.setCursor(Cursor.getPredefinedCursor(3));
                break;
            }
            case 5: {
                view.setCursor(Cursor.getPredefinedCursor(3));
                break;
            }
            case 3: {
                view.setCursor(ResourceManager.getCustomCursor(view, "column_split.gif"));
                break;
            }
            case 2: {
                view.setCursor(ResourceManager.getCustomCursor(view, "column_move.gif"));
                break;
            }
            default: {
                view.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    @Override
    public IMouseState prePressing(MouseEvent e) {
        SpreadStateManager sMgr = this._context.getStateManager();
        if (!sMgr.isState2(SpreadStateManager.Key_Range_Select) && !sMgr.stopEditing()) {
            return null;
        }
        this._context.getSpread().setActiveView((SpreadView)e.getSource());
        switch (this._stateFlag) {
            case 2: 
            case 3: {
                if (this._rs == null) {
                    this._rs = new ResizeColumnsState();
                }
                return this._rs;
            }
        }
        if (this._ss == null) {
            this._ss = new SelectColumnsState();
        }
        return this._ss;
    }

    private void showPopupMenu(MouseEvent e) {
        SpreadView view = (SpreadView)e.getSource();
        this._context.getPopMenuManager().setRowBarOrColBar(true);
        JPopupMenu menu = this._context.getPopMenuManager().getPopMenu();
        menu.show(view, e.getX(), e.getY());
        menu.requestFocusInWindow();
    }

    private boolean needShowPopup(MouseEvent e) {
        return e.getButton() == 3 && e.getClickCount() == 1;
    }

    private boolean needReSelect(MouseEvent e) {
        SpreadView view = (SpreadView)e.getSource();
        Sheet sheet = view.getSpread().getBook().getActiveSheet();
        int col = SheetBaseMath.colAtPoint(sheet, e.getPoint());
        return !sheet.getSheetOption().getSelection().isColumnSelect(col);
    }

    public boolean isResizable() {
        return this.resizable;
    }

    public void setResizable(boolean resizable) {
        this.resizable = resizable;
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    private void registerHideCol(Sheet sheet, Range r) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = r.size() - 1; i >= 0; --i) {
            CellBlock b = r.getBlock(i);
            if (b == null) continue;
            int k = Math.min(b.getCol(), b.getCol2());
            for (int j = Math.abs(b.getCol2() - b.getCol()) + 1; j >= 0; --j) {
                if (SheetBaseMath.getColWidth(sheet, k + j) != 0) continue;
                list.add(new Integer(k + j));
            }
        }
        int size = list.size();
        this.hideColsIndex = new int[size];
        for (int i = 0; i < size; ++i) {
            this.hideColsIndex[i] = (Integer)list.get(i);
        }
    }

    private void reWidthHideCol() {
        if (this.hideColsIndex == null || this.hideColsIndex.length == 0) {
            return;
        }
        for (int i = this.hideColsIndex.length - 1; i >= 0; --i) {
            this._context.getRangeManager().getColRangeInBook(this.hideColsIndex[i], this.hideColsIndex[i]).setColumnHidden(true);
        }
        this.hideColsIndex = null;
    }

    class ResizeColumnsState
    extends DefaultMouseState {
        ResizeColumnsState() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                this.reFeatWidth(e);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            SpreadView view = (SpreadView)e.getSource();
            Sheet sheet = view.getSpread().getBook().getActiveSheet();
            ColMouseController.this._pressPX = e.getX();
            ColMouseController.this._pressColX = SheetBaseMath.getColX(sheet, ColMouseController.this._pressCol);
            ColMouseController.this._lastCol = ColMouseController.this._pressCol;
            ColMouseController.this._lastPX = ColMouseController.this._pressPX;
            ColMouseController.this._lastColX = ColMouseController.this._pressColX;
            ColMouseController.this._isResizing = true;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            SpreadView view = (SpreadView)e.getSource();
            Sheet sheet = view.getSpread().getBook().getActiveSheet();
            int curpx = e.getPoint().x;
            Rectangle r = view.getVisibleRect();
            if ((double)curpx < r.getX()) {
                curpx = r.x;
            }
            if (curpx != ColMouseController.this._lastPX) {
                if (curpx > ColMouseController.this._pressPX) {
                    ColMouseController.this._lastCol = ColMouseController.this._pressCol;
                    ColMouseController.this._lastColX = ColMouseController.this._pressColX;
                } else {
                    int curCol = SheetBaseMath.colAtPoint(sheet, e.getPoint());
                    if (curCol != ColMouseController.this._lastCol) {
                        ColMouseController.this._lastCol = curCol;
                        ColMouseController.this._lastColX = SheetBaseMath.getColX(sheet, ColMouseController.this._lastCol);
                    }
                }
                ColMouseController.this._lastPX = curpx;
                view.repaint();
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.rewidth(e);
            ColMouseController.this._isResizing = false;
        }

        private void rewidth(MouseEvent e) {
            ColMouseController.this._context.getStateManager().stop();
            if (ColMouseController.this._lastPX == ColMouseController.this._pressPX) {
                return;
            }
            SpreadView view = (SpreadView)e.getSource();
            KDSpread spread = view.getSpread();
            Book book = spread.getBook();
            Sheet sheet = book.getActiveSheet();
            book.getUndoManager().startGroup();
            Selection sel = sheet.getSheetOption().getSelection();
            float scale = sheet.getSheetOption().getScaleNoPercent();
            if (!ColMouseController.this.resizable) {
                ColMouseController.this.registerHideCol(sheet, ColMouseController.this._context.getRangeManager().getSelectionRangeInBook());
            }
            if (ColMouseController.this._lastCol == ColMouseController.this._pressCol) {
                int newWidth = ColMouseController.this._lastPX - ColMouseController.this._lastColX;
                newWidth = (int)((float)newWidth / scale);
                boolean isAutoCalculate = book.isAutoCalculate();
                boolean isExecuted = MiscUtil.isExecutedBook(book);
                if (sel.isColumnSelect(ColMouseController.this._pressCol) && sel.isColBlocks()) {
                    Integer oldWithd = ColMouseController.this._context.getRangeManager().getSelectionRangeInBook().getColumnWidth();
                    if (oldWithd != null && isExecuted) {
                        if (oldWithd == 0 && newWidth != 0 || oldWithd != 0 && newWidth == 0) {
                            book.setAutoCalculate(true);
                        } else {
                            book.setAutoCalculate(false);
                        }
                    }
                    ColMouseController.this._context.getRangeManager().getSelectionRangeInBook().setColumnWidth(newWidth);
                } else {
                    Integer oldWithd = ColMouseController.this._context.getRangeManager().getColRangeInBook(ColMouseController.this._pressCol, ColMouseController.this._pressCol).getColumnWidth();
                    if (oldWithd != null && isExecuted) {
                        if (oldWithd == 0 && newWidth != 0 || oldWithd != 0 && newWidth == 0) {
                            book.setAutoCalculate(true);
                        } else {
                            book.setAutoCalculate(false);
                        }
                    }
                    ColMouseController.this._context.getRangeManager().getColRangeInBook(ColMouseController.this._pressCol, ColMouseController.this._pressCol).setColumnWidth(newWidth);
                }
                book.setAutoCalculate(isAutoCalculate);
            } else {
                if (sel.isColumnSelect(ColMouseController.this._pressCol) && sel.isColBlocks()) {
                    Range rg = ColMouseController.this._context.getRangeManager().getSelectionRangeInBook();
                    if (ColMouseController.this._lastCol < ColMouseController.this._pressCol - 1) {
                        rg.addAll(ColMouseController.this._context.getRangeManager().getColRangeInBook(ColMouseController.this._lastCol + 1, ColMouseController.this._pressCol - 1));
                    }
                    rg.setColumnHidden(true);
                } else {
                    ColMouseController.this._context.getRangeManager().getColRangeInBook(ColMouseController.this._lastCol + 1, ColMouseController.this._pressCol).setColumnHidden(true);
                }
                int newWidth = ColMouseController.this._lastPX - ColMouseController.this._lastColX;
                newWidth = (int)((float)newWidth / scale);
                ColMouseController.this._context.getRangeManager().getColRangeInBook(ColMouseController.this._lastCol, ColMouseController.this._lastCol).setColumnWidth(newWidth);
            }
            if (!ColMouseController.this.resizable) {
                ColMouseController.this.reWidthHideCol();
            }
            spread.getBook().getUndoManager().endGroup();
        }

        private void reFeatWidth(MouseEvent e) {
            SortedSpanArray spans;
            ColMouseController.this._context.getStateManager().stop();
            SpreadView view = (SpreadView)e.getSource();
            KDSpread spread = view.getSpread();
            Sheet sheet = spread.getBook().getActiveSheet();
            Selection selection = sheet.getSheetOption().getSelection();
            if (!ColMouseController.this.resizable) {
                ColMouseController.this.registerHideCol(sheet, ColMouseController.this._context.getRangeManager().getSelectionRangeInBook());
            }
            if (selection.isColumnSelect(ColMouseController.this._pressCol) && selection.isColBlocks()) {
                spans = selection.toColumnSpans();
            } else {
                spans = new SortedSpanArray();
                spans.insert(new Span(ColMouseController.this._pressCol, ColMouseController.this._pressCol));
            }
            sheet.getBook().getUndoManager().startGroup();
            Graphics2D g2d = (Graphics2D)view.getGraphics();
            for (int spanIndex = 0; spanIndex < spans.size(); ++spanIndex) {
                Span span = (Span)spans.get(spanIndex);
                SortedColumnArray sca = sheet.getCols();
                IntMarkEntry[] cols = sca.subset(span.getStart(), span.getEnd());
                if (cols == null) {
                    return;
                }
                for (int i = 0; i < cols.length; ++i) {
                    int colIndex = cols[i].getIntMark();
                    Sheet.ICellsIterator iter = sheet.getCellsIterator(0, colIndex, 1048575, colIndex, false, true);
                    int width = 0;
                    while (iter.hasNext()) {
                        int w = 0;
                        Cell cell = iter.next();
                        FontMetrics fm = g2d.getFontMetrics((Font)cell.getStyle().getKDFont());
                        ICellDisplayProvider cvp = spread.getCellDisplayProvider();
                        Object value = cvp.getBaseValue(cell, spread.getBook().getActiveSheet().getSheetOption().getCellDisplayMode());
                        if (value instanceof String) {
                            w = fm.stringWidth((String)value);
                            int rotate = cell.getStyle().getRotation();
                            if (rotate != 0) {
                                double angel = Math.PI * (double)rotate / 180.0;
                                w = Math.abs(rotate) == 90 ? fm.getHeight() : (int)((double)w * Math.cos(angel));
                            }
                        }
                        if (w <= width) continue;
                        width = w;
                    }
                    if (width <= 0) continue;
                    ColMouseController.this._context.getRangeManager().getColRangeInBook(colIndex, colIndex).setColumnWidth(width + 8);
                }
            }
            if (!ColMouseController.this.resizable) {
                ColMouseController.this.reWidthHideCol();
            }
            sheet.getBook().getUndoManager().endGroup();
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            SpreadView view = ColMouseController.this._context.getSpread().getActiveView();
            int firstRow = view.calcFirstRowByEndRow(view.getEndRow());
            ColMouseController.this._context.getSpread().setViewRow(view, firstRow - 1);
            super.mouseWheelMoved(e);
        }
    }

    class SelectColumnsState
    extends DefaultMouseState {
        SelectColumnsState() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            Sheet sheet = ColMouseController.this._context.getBook().getActiveSheet();
            EmbedhLayer gl = sheet.getEmbedments(false);
            if (gl != null) {
                gl.cancelSelectedEmbeds();
            }
            boolean needShowPopup = ColMouseController.this.needShowPopup(e);
            boolean needReSelect = true;
            if (needShowPopup) {
                needReSelect = ColMouseController.this.needReSelect(e);
            }
            if (needReSelect) {
                SelectionAdapter sel = ColMouseController.this._context.getSelection();
                if (e.isShiftDown()) {
                    if (sel.changeSelection(CellBlock.getCellBlock(0, sheet.getActiveCol(), 1048575, ColMouseController.this._pressCol), 3)) {
                        SpreadView view = (SpreadView)e.getSource();
                        view.getSpread().setActiveView(view);
                        ColMouseController.this._lastCol = ColMouseController.this._pressCol;
                    }
                } else {
                    boolean selected = sel.changeSelection(CellBlock.getCellBlock(0, ColMouseController.this._pressCol, 1048575, ColMouseController.this._pressCol), e.isControlDown() ? 1 : 2, false);
                    if (selected) {
                        SpreadView view = (SpreadView)e.getSource();
                        view.getSpread().setActiveView(view);
                        ColMouseController.this._lastCol = ColMouseController.this._pressCol;
                    }
                }
            }
            if (needShowPopup) {
                ColMouseController.this.showPopupMenu(e);
            }
            SpreadView view = (SpreadView)e.getSource();
            String result = KDSpreadHelper.calSumAndAvg(view);
            ColMouseController.this._context.updateMesage(result);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            CellBlock updateB;
            SpreadView view = (SpreadView)e.getSource();
            Sheet sheet = view.getSpread().getBook().getActiveSheet();
            SelectionAdapter selection = ColMouseController.this._context.getSelection();
            int curCol = SheetBaseMath.colAtPoint(sheet, e.getPoint());
            if ((curCol = SheetBaseMath.dealInvalidCol(curCol)) != ColMouseController.this._lastCol && selection.changeSelection(updateB = CellBlock.getCellBlock(0, e.isShiftDown() ? sheet.getActiveCol() : ColMouseController.this._pressCol, 1048575, curCol), 3, false)) {
                ColMouseController.this._lastCol = curCol;
                view.scrollCellVisible(0, curCol);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            SpreadStateManager sm = ColMouseController.this._context.getStateManager();
            if (ColMouseController.this._stateFlag == 5) {
                sm.stop();
                ((SpreadView)e.getSource()).setCursor(Cursor.getDefaultCursor());
            } else if (ColMouseController.this._stateFlag == 4) {
                Range r = ColMouseController.this._context.getRangeManager().getSelectionRangeInBook();
                if (r.paste(PasteMode.FORMATS, null)) {
                    ColMouseController.this._context.getStateManager().stop();
                    ((SpreadView)e.getSource()).setCursor(Cursor.getDefaultCursor());
                }
            } else if (sm.isState(SpreadStateManager.Key_Range_Select)) {
                // empty if block
            }
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            SpreadView view = ColMouseController.this._context.getSpread().getActiveView();
            int firstRow = view.calcFirstRowByEndRow(view.getEndRow());
            ColMouseController.this._context.getSpread().setViewRow(view, firstRow - 1);
            super.mouseWheelMoved(e);
        }
    }
}

