/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.io.kds;

import com.kingdee.bos.ctrl.common.CtrlUtil;
import com.kingdee.bos.ctrl.common.util.StreamUtil;
import com.kingdee.bos.ctrl.kdf.util.CloseUtil;
import com.kingdee.bos.ctrl.kds.io.BookIOController;
import com.kingdee.bos.ctrl.kds.io.kds.AuthorizationFailedException;
import com.kingdee.bos.ctrl.kds.io.kds.HighVersionException;
import com.kingdee.bos.ctrl.kds.io.kds.KDSBinaryBook;
import com.kingdee.bos.ctrl.kds.io.kds.KDSConstants;
import com.kingdee.bos.ctrl.kds.io.kds.SectionJarInputStream;
import com.kingdee.bos.ctrl.kds.io.kds.archives.kds10.KDSBinaryBook10;
import com.kingdee.bos.ctrl.kds.io.kds.archives.kds540.KDSBinaryBook540;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.bos.ctrl.kds.model.struct.IBookProvider;
import com.kingdee.bos.ctrl.kds.util.KDSDataInputStream;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public final class KdsToBook
extends KDSConstants {
    private BookIOController _ctrl;

    public void setBookIOController(BookIOController ctrl) {
        this._ctrl = ctrl;
    }

    /*
     * Loose catch block
     * WARNING - bad return control flow
     */
    public Book load(String file) throws HighVersionException, AuthorizationFailedException, IOException {
        Book book;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            book = this.load(fis);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            CloseUtil.close((Closeable[])new Closeable[]{fis});
        }
        catch (IOException ioe) {
            throw ioe;
            {
                catch (Throwable throwable) {
                    CloseUtil.close((Closeable[])new Closeable[]{fis});
                    throw throwable;
                }
            }
        }
        CloseUtil.close((Closeable[])new Closeable[]{fis});
        return book;
        return null;
    }

    public Book load(InputStream is) throws HighVersionException, AuthorizationFailedException, IOException {
        KDSDataInputStream dis = new KDSDataInputStream(is);
        try {
            Book book = this.readBook(dis);
            return book;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            StreamUtil.closeStream((InputStream)dis);
        }
    }

    public Book load(byte[] source) throws IOException, AuthorizationFailedException, HighVersionException {
        Book book = Book.Manager.getNewBookWithProvider(this.getBookProvider(source));
        return book;
    }

    private Book readBook(KDSDataInputStream is) throws IOException, HighVersionException, AuthorizationFailedException {
        byte[] sections = CtrlUtil.Stream.readInputStream((InputStream)is);
        Book book = Book.Manager.getNewBookWithProvider(this.getBookProvider(sections));
        return book;
    }

    private IBookProvider getBookProvider(byte[] sections) throws IOException, HighVersionException {
        SectionJarInputStream sis = new SectionJarInputStream(sections);
        int version = sis.getFileVersion();
        if (version >= 20000) {
            return new KDSBinaryBook(sis, this._ctrl);
        }
        if (version < 10000) {
            return new KDSBinaryBook540(sis, this._ctrl);
        }
        return new KDSBinaryBook10(sis, this._ctrl);
    }
}

