/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.io.table;

import com.kingdee.bos.ctrl.extcommon.variant.Util;
import com.kingdee.bos.ctrl.extcommon.variant.Variant;
import com.kingdee.bos.ctrl.kdf.table.KDTBody;
import com.kingdee.bos.ctrl.kdf.table.KDTCell;
import com.kingdee.bos.ctrl.kdf.table.KDTColumn;
import com.kingdee.bos.ctrl.kdf.table.KDTColumns;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.file.IDObject;
import com.kingdee.bos.ctrl.kdf.util.file.KDF;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.kds.io.table.BookKdfIOController;
import com.kingdee.bos.ctrl.kds.io.table.IBookKdfUOTrans;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.bos.ctrl.kds.model.struct.Cell;
import com.kingdee.bos.ctrl.kds.model.struct.CellBlock;
import com.kingdee.bos.ctrl.kds.model.struct.Column;
import com.kingdee.bos.ctrl.kds.model.struct.MergeBlocks;
import com.kingdee.bos.ctrl.kds.model.struct.Row;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.SortedAttributeSpanArray;
import java.util.Set;

public final class BookToKdf {
    private BookKdfIOController _ctrl;

    public void setIOController(BookKdfIOController ctrl) {
        this._ctrl = ctrl;
    }

    private IBookKdfUOTrans getTableUOTrans() {
        if (this._ctrl == null) {
            return null;
        }
        return this._ctrl.getTableUOTrans();
    }

    public KDF getKDF(Book book) {
        KDF kdf = new KDF();
        if (this.getTableUOTrans() != null) {
            this.getTableUOTrans().bookTransTo(book, kdf);
        }
        int count = book.getSheetCount();
        for (int i = 0; i < count; ++i) {
            Sheet sheet = book.getSheet(i);
            KDTable table = this.getTable(sheet);
            kdf.addTable((IDObject)table);
        }
        return kdf;
    }

    public KDTable getTable(Sheet sheet) {
        KDTable table = new KDTable();
        table.setName(sheet.getSheetName());
        table.setID(sheet.getID());
        table.setSSA((ShareStyleAttributes)Styles.getSA((ShareStyleAttributes)sheet.getSSA()));
        if (this.getTableUOTrans() != null) {
            this.getTableUOTrans().sheetTransTo(sheet, table);
        }
        table.setGridLineColor(sheet.getSheetOption().getGridLineColor());
        table.setHorizonGridLineVisible(sheet.getSheetOption().isShowHoriLines());
        table.setVerticalGridLineVisible(sheet.getSheetOption().isShowVertLines());
        this.translateColumns(table, sheet);
        this.translateRows(table, sheet);
        this.translateMerger(table, sheet);
        this.translateCells(table, sheet);
        return table;
    }

    private void translateCells(KDTable table, Sheet sheet) {
        Sheet.ICellsIterator iter = sheet.getCellsIterator(0, 0, sheet.getMaxRowIndex(), sheet.getMaxColIndex(), false, false);
        KDTBody body = table.getBody();
        while (iter.hasNext()) {
            CellBlock merge;
            Cell sCell = iter.next();
            KDTCell tCell = new KDTCell();
            tCell.setSSA(sCell.getSSA());
            tCell.setStyle(sCell.getStyle());
            if (this.getTableUOTrans() != null) {
                this.getTableUOTrans().cellTransTo(sCell, tCell);
            }
            Variant variant = sCell.getValue();
            Util.reduceScale(variant);
            tCell.setValue(variant.getValue());
            if (sCell.hasFormula()) {
                tCell.setExpressions(sCell.getFormula());
            }
            if ((merge = sCell.getMerge(false)) != null) {
                tCell.setMergeBlock(table.getMergeManager().getMergeBlockOfCell(sCell.getRow(), sCell.getCol()));
            }
            body.getRow(sCell.getRow()).addCell(sCell.getCol(), tCell);
        }
    }

    private void translateColumns(KDTable table, Sheet sheet) {
        SortedAttributeSpanArray colSpans = sheet.getColSpans();
        KDTColumns columns = table.getColumns();
        int maxColIndex = sheet.getMaxColIndex();
        for (int i = 0; i <= maxColIndex; ++i) {
            int w;
            Style style;
            ShareStyleAttributes ssa;
            int index;
            Column sCol;
            KDTColumn tCol = new KDTColumn();
            if (this.getTableUOTrans() != null && (sCol = sheet.getColumn(i, false)) != null) {
                this.getTableUOTrans().colTransTo(sCol, tCol);
            }
            if ((index = colSpans.searchSpan(i)) < 0) {
                ssa = Styles.getEmptySSA();
                ShareStyleAttributes tableSSA = table.getSSA();
                if (tableSSA == null) {
                    tableSSA = Styles.getEmptySSA();
                }
                style = Styles.getStyle((ShareStyleAttributes[])new ShareStyleAttributes[]{ssa, tableSSA});
                w = sheet.getOriginalDefColWidth();
            } else {
                SortedAttributeSpanArray.AttributeSpan span = colSpans.getAttributeSpan(index);
                ssa = span.getSSA();
                style = span.getStyle();
                w = span.isVisible() ? span.getOriginalLength() : 0;
            }
            tCol.setSSA(ssa);
            tCol.setStyle(style);
            tCol.setWidth(w);
            columns.addColumn(tCol);
        }
    }

    private void translateRows(KDTable table, Sheet sheet) {
        SortedAttributeSpanArray rowSpans = sheet.getRowSpans();
        int maxRowIndex = sheet.getMaxRowIndex();
        KDTBody body = table.getBody();
        for (int i = 0; i <= maxRowIndex; ++i) {
            int h;
            Style style;
            ShareStyleAttributes ssa;
            int index;
            Row sRow;
            KDTRow tRow = new KDTRow();
            if (this.getTableUOTrans() != null && (sRow = sheet.getRow(i, false)) != null) {
                this.getTableUOTrans().rowTransTo(sRow, tRow);
            }
            if ((index = rowSpans.searchSpan(i)) < 0) {
                ssa = Styles.getEmptySSA();
                ShareStyleAttributes tableSSA = table.getSSA();
                if (tableSSA == null) {
                    tableSSA = Styles.getEmptySSA();
                }
                style = Styles.getStyle((ShareStyleAttributes[])new ShareStyleAttributes[]{ssa, tableSSA});
                h = sheet.getOriginalDefRowHeight();
            } else {
                SortedAttributeSpanArray.AttributeSpan span = rowSpans.getAttributeSpan(index);
                ssa = span.getSSA();
                style = span.getStyle();
                h = span.isVisible() ? span.getOriginalLength() : 0;
            }
            tRow.setSSA(ssa);
            tRow.setStyle(style);
            tRow.setHeight(h);
            body.addRow(i, tRow);
        }
    }

    private void translateMerger(KDTable table, Sheet sheet) {
        MergeBlocks mb = sheet.getSheetOption().getMerger(false);
        if (mb == null) {
            return;
        }
        Set list = table.getMergeManager().getMergeBlockSet();
        for (int i = mb.size() - 1; i >= 0; --i) {
            CellBlock merge = mb.getBlock(i);
            KDTMergeBlock kdtMerge = new KDTMergeBlock();
            kdtMerge.setTop(merge.getRow());
            kdtMerge.setBottom(merge.getRow2());
            kdtMerge.setLeft(merge.getCol());
            kdtMerge.setRight(merge.getCol2());
            list.add(kdtMerge);
        }
    }
}

