/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.model.struct;

import com.kingdee.bos.ctrl.common.KDToolkit;
import com.kingdee.bos.ctrl.extcommon.util.ObjectArray;
import com.kingdee.bos.ctrl.extcommon.variant.Variant;
import com.kingdee.bos.ctrl.extcommon.variant.WeakHashSet;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.kds.model.expr.Expr;
import com.kingdee.bos.ctrl.kds.model.expr.ExprConst;
import com.kingdee.bos.ctrl.kds.model.expr.ExprContext;
import com.kingdee.bos.ctrl.kds.model.expr.ExprMethod;
import com.kingdee.bos.ctrl.kds.model.struct.Cell;
import com.kingdee.bos.ctrl.kds.model.struct.CellBlock;
import com.kingdee.bos.ctrl.kds.model.struct.FillType;
import com.kingdee.bos.ctrl.kds.model.struct.IMethodFillParameter;
import com.kingdee.bos.ctrl.kds.model.struct.Parameter;
import com.kingdee.bos.ctrl.kds.model.struct.PasteMode;
import com.kingdee.bos.ctrl.kds.model.struct.Protection;
import com.kingdee.bos.ctrl.kds.model.struct.Range;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.SheetAction;
import com.kingdee.bos.ctrl.kds.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.kds.model.struct.SortedAttributeSpanArray;
import com.kingdee.bos.ctrl.kds.model.struct.SortedSpanArray;
import com.kingdee.bos.ctrl.kds.model.struct.Span;
import com.kingdee.bos.ctrl.kds.model.struct.TrendFactor;
import com.kingdee.bos.ctrl.kds.model.struct.URState;
import com.kingdee.bos.ctrl.kds.model.struct.borders.Borders;
import com.kingdee.bos.ctrl.kds.model.struct.event.SheetChangeEvent;
import com.kingdee.bos.ctrl.kds.model.util.SortedParameterArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class SheetAction_Fill
extends SheetAction {
    private CellBlock _src;
    private CellBlock _dst;
    private FillType _type;
    private FillType _result;
    private String[] _userKeys;

    public SheetAction_Fill(Range rg, CellBlock dst, FillType type, FillType resultType, String[] userKeys) {
        super(rg, SheetChangeEvent.Changed_Content | SheetChangeEvent.Changed_Style);
        this._src = rg.getBlock(0);
        this._dst = dst;
        this._type = type;
        this._result = resultType;
        this._userKeys = userKeys;
    }

    @Override
    protected void actionBlock(URState state, Sheet sheet, CellBlock cb) {
        cb = this._dst;
        PasteMode modeAll = PasteMode.ALL;
        boolean justFormat = this._type == FillType.FORMAT;
        boolean fillFormat = this._type.touchFlag(512);
        if (!fillFormat) {
            modeAll = modeAll.noFormats();
        }
        int srcRow = this._src.getRow();
        int srcCol = this._src.getCol();
        boolean yDir = cb.getWidth() == this._src.getWidth();
        int srcHeight = Math.max(1, Math.min(sheet.getMaxRowIndex() + 1, this._src.getHeight()));
        int srcWidth = Math.max(1, Math.min(sheet.getMaxColIndex() + 1, this._src.getWidth()));
        HashMap<String, Object> queryInfo = new HashMap<String, Object>();
        queryInfo.put("Sheet_Name", sheet.getSheetName());
        queryInfo.put("Block_From", this._src);
        queryInfo.put("Block_To", this._dst);
        Object[] aFactor = null;
        if (this._result != null) {
            this._result.setFlags(1792);
        }
        int row = cb.getRow();
        int row2 = cb.getRow2();
        int col = cb.getCol();
        int col2 = cb.getCol2();
        if (yDir) {
            int base;
            int to;
            int from;
            if (row < srcRow) {
                from = row;
                to = srcRow - 1;
                base = this._src.getRow2();
            } else {
                from = this._src.getRow2() + 1;
                to = row2;
                base = srcRow;
            }
            if (fillFormat && cb.isRow()) {
                this.fillAttributeSpans(state, sheet, this._src, from, to, base, true);
            }
            int queryCount = Math.max(1, (int)Math.ceil(((double)(to - from) + 1.0) / (double)srcHeight));
            for (int i = 0; i < srcWidth; ++i) {
                int c = srcCol + i;
                if (!justFormat) {
                    aFactor = sheet.getTrendFactor(srcRow, c, srcHeight, true, this._type, this._result);
                    int[] cols = new int[queryCount];
                    Arrays.fill(cols, c);
                    queryInfo.put("Dst_Column", cols);
                }
                for (int r = from; r <= to; ++r) {
                    Object factor;
                    int offset = r - base;
                    int srcIndex = offset % srcHeight;
                    int sr = base + srcIndex;
                    Cell srcCell = sheet.getCell(sr, c, false);
                    if (justFormat || srcCell == null) {
                        if (!fillFormat) continue;
                        this.fillCellStyle(state, sheet, sr, c, r, c, srcCell, PasteMode.FORMATS);
                        continue;
                    }
                    TrendFactor tf = null;
                    int step = 0;
                    Object object = aFactor != null ? aFactor[offset > 0 ? srcIndex : srcHeight - 1 + srcIndex] : (factor = null);
                    if (factor instanceof TrendFactor) {
                        HashMap pos;
                        tf = (TrendFactor)factor;
                        step = offset / srcHeight * tf.getCount() + tf.getIndex();
                        if (tf.getType() == 514 && !(pos = (HashMap)tf.getB().getValue()).containsKey("_query_")) {
                            int rr;
                            int[] rows = new int[queryCount];
                            if (offset > 0) {
                                for (rr = 0; rr < queryCount; ++rr) {
                                    rows[rr] = from + srcHeight * rr + srcIndex;
                                }
                            } else {
                                for (rr = queryCount - 1; rr >= 0; --rr) {
                                    rows[queryCount - 1 - rr] = to - srcHeight * rr + srcIndex;
                                }
                            }
                            queryInfo.put("Dst_Row", rows);
                            this.queryFillParameters(pos, tf, queryCount, queryInfo);
                        }
                    }
                    this.fillCell(state, sheet, srcCell, r, c, modeAll, tf, step, this._userKeys);
                }
            }
        } else {
            int base;
            int to;
            int from;
            if (col < srcCol) {
                from = col;
                to = srcCol - 1;
                base = this._src.getCol2();
            } else {
                from = this._src.getCol2() + 1;
                to = col2;
                base = srcCol;
            }
            if (fillFormat && cb.isCol()) {
                this.fillAttributeSpans(state, sheet, this._src, from, to, base, false);
            }
            int queryCount = Math.max(1, (int)Math.ceil(((double)(to - from) + 1.0) / (double)srcWidth));
            for (int i = 0; i < srcHeight; ++i) {
                int r = srcRow + i;
                if (!justFormat) {
                    aFactor = sheet.getTrendFactor(r, srcCol, srcWidth, false, this._type, this._result);
                    int[] rows = new int[queryCount];
                    Arrays.fill(rows, r);
                    queryInfo.put("Dst_Row", rows);
                }
                for (int c = from; c <= to; ++c) {
                    int offset = c - base;
                    int srcIndex = offset % srcWidth;
                    int sc = base + srcIndex;
                    Cell srcCell = sheet.getCell(r, sc, false);
                    if (justFormat || srcCell == null) {
                        if (!fillFormat) continue;
                        this.fillCellStyle(state, sheet, r, sc, r, c, srcCell, PasteMode.FORMATS);
                        continue;
                    }
                    TrendFactor tf = null;
                    int step = 0;
                    Object factor = aFactor[offset > 0 ? srcIndex : srcWidth - 1 + srcIndex];
                    if (factor instanceof TrendFactor) {
                        HashMap pos;
                        tf = (TrendFactor)factor;
                        step = offset / srcWidth * tf.getCount() + tf.getIndex();
                        if (tf.getType() == 514 && !(pos = (HashMap)tf.getB().getValue()).containsKey("_query_")) {
                            int cc;
                            int[] cols = new int[queryCount];
                            if (offset > 0) {
                                for (cc = 0; cc < queryCount; ++cc) {
                                    cols[cc] = from + srcWidth * cc + srcIndex;
                                }
                            } else {
                                for (cc = queryCount - 1; cc >= 0; --cc) {
                                    cols[cc] = to + 1 - srcWidth * cc + srcIndex;
                                }
                            }
                            queryInfo.put("Dst_Column", cols);
                            this.queryFillParameters(pos, tf, queryCount, queryInfo);
                        }
                    }
                    this.fillCell(state, sheet, srcCell, r, c, modeAll, tf, step, this._userKeys);
                }
            }
        }
        this.checkedAutoFilter(sheet, state);
    }

    private void checkedAutoFilter(Sheet sheet, URState state) {
        CellBlock autoFilterArea = sheet.getAutoFilterArea();
        if (autoFilterArea == null) {
            return;
        }
        CellBlock newArea = new CellBlock(autoFilterArea);
        SheetBaseMath.unCancerizeCellBlock(sheet, newArea);
        if (newArea.getCol() == -1 || newArea.getCol2() == -1 || newArea.getRow() == -1 || newArea.getRow2() == -1) {
            this.colseAutoFilter(sheet, state, autoFilterArea);
            return;
        }
        SheetBaseMath.cancerizeCellBlock(sheet, newArea, false, true, false);
        state.setData("AutoFilterArea", sheet.getAutoFilterArea());
        sheet.setAutoFilterArea(newArea);
        sheet.getBook().fireSheetChange(sheet, null, SheetChangeEvent.Changed_AutoFilter);
    }

    @Override
    protected void resumeBlock(URState state, Sheet sheet, CellBlock cb) {
        ObjectArray clls;
        SortedSpanArray bakSpans = (SortedSpanArray)state.get("ROW_SSA");
        if (bakSpans != null) {
            SortedAttributeSpanArray spans = cb.getWidth() == 65536 ? sheet.getRowSpans() : sheet.getColSpans();
            spans.setSpans(bakSpans);
        }
        if ((clls = (ObjectArray)state.get("CELL_OBJ")) != null) {
            ObjectArray values = (ObjectArray)state.get("CELL_VALUE");
            int size = clls.size();
            for (int i = 0; i < size; ++i) {
                Cell cll = (Cell)clls.get(i);
                Cell dstCell = sheet.getCell(cll.getRow(), cll.getCol(), true);
                Object obj = values.get(i);
                if (obj instanceof String) {
                    dstCell.resumeCopyFrom(cll, PasteMode.ALL, this._userKeys);
                    continue;
                }
                dstCell.setSSA((ShareStyleAttributes)obj);
            }
        }
        this.resumeAutoFilter(sheet, state);
    }

    private void fillAttributeSpans(URState state, Sheet sheet, CellBlock src, int from, int to, int base, boolean yDir) {
        SortedSpanArray bakSpans = state != null ? new SortedSpanArray(yDir ? 1048575 : 65535) : null;
        SortedAttributeSpanArray spans = yDir ? sheet.getRowSpans() : sheet.getColSpans();
        long allBits = ShareStyleAttributes.getAllBits();
        int extent = yDir ? src.getHeight() : src.getWidth();
        int srcBase = yDir ? src.getRow() : src.getCol();
        StyleAttributes[] aSA = new StyleAttributes[extent];
        int defaultLength = yDir ? sheet.getDefRowHeight() : sheet.getDefColWidth();
        int defaultGroupLevel = 0;
        boolean defaultCollapse = false;
        for (int i = from; i <= to; ++i) {
            StyleAttributes sa;
            boolean dstCollapse;
            int dstGroupLevel;
            boolean dstVisible;
            int dstLen;
            ShareStyleAttributes dstSSA;
            SortedAttributeSpanArray.AttributeSpan span;
            boolean srcCollapse;
            int srcGroupLevel;
            boolean srcVisible;
            int srcLen;
            ShareStyleAttributes srcSSA;
            int si = base + (i - base) % extent;
            int pos = spans.searchSpan(si);
            if (pos < 0) {
                srcSSA = Styles.getEmptySSA();
                srcLen = defaultLength;
                srcVisible = true;
                srcGroupLevel = defaultGroupLevel;
                srcCollapse = defaultCollapse;
            } else {
                span = spans.getAttributeSpan(pos);
                srcSSA = span.getSSA();
                srcLen = span.getLength();
                srcVisible = span.isVisible();
                srcGroupLevel = span.getOutlineGroupLevel();
                srcCollapse = span.isCollapse();
            }
            pos = spans.searchSpan(i);
            if (pos < 0) {
                dstSSA = Styles.getEmptySSA();
                dstLen = defaultLength;
                dstVisible = true;
                dstGroupLevel = defaultGroupLevel;
                dstCollapse = defaultCollapse;
            } else {
                span = spans.getAttributeSpan(pos);
                dstSSA = span.getSSA();
                dstLen = span.getLength();
                dstVisible = span.isVisible();
                dstGroupLevel = span.getOutlineGroupLevel();
                dstCollapse = span.isCollapse();
            }
            if (dstSSA == srcSSA && dstLen == srcLen && dstVisible == srcVisible && dstGroupLevel == srcGroupLevel) continue;
            if (state != null) {
                SortedAttributeSpanArray sortedAttributeSpanArray = spans;
                sortedAttributeSpanArray.getClass();
                bakSpans.append(new SortedAttributeSpanArray.AttributeSpan(sortedAttributeSpanArray, i, i, dstSSA, dstLen, dstVisible));
            }
            if ((sa = aSA[si - srcBase]) == null) {
                sa = Styles.getSA((ShareStyleAttributes)srcSSA);
                sa.setDirty(allBits);
                aSA[si - srcBase] = sa;
            }
            spans.setSpanAttribute(new Span(i, i), (ShareStyleAttributes)sa, dstLen != srcLen ? new Integer(srcLen) : null, dstVisible != srcVisible ? Boolean.valueOf(srcVisible) : null, dstGroupLevel != srcGroupLevel ? new Integer(srcGroupLevel) : null, dstCollapse != srcCollapse ? new Boolean(srcCollapse) : null, false);
        }
        if (state != null && bakSpans.size() > 0) {
            state.setData("ROW_SSA", bakSpans);
        }
    }

    private void fillCellStyle(URState state, Sheet sheet, int srcRow, int srcCol, int dstRow, int dstCol, Cell srcCell, PasteMode pasteMode) {
        sheet.getBorders().buildFromSSA();
        Style srcStyle = sheet.getCellStyle(srcRow, srcCol);
        if (sheet.getCellStyle(dstRow, dstCol) != srcStyle) {
            ShareStyleAttributes oldSSA;
            Cell dstCell = sheet.getCell(dstRow, dstCol, false);
            Cell changedProps = Cell.getNewCell(sheet.getRow(dstRow, true), sheet.getColumn(dstCol, true));
            if (dstCell == null) {
                dstCell = this.getStateCell(state, sheet, dstRow, dstCol);
                Protection pro = sheet.getSheetOption().getProtection(false);
                boolean bProtected = pro != null && pro.isProtected();
                oldSSA = dstCell.copyStyle(srcStyle, null, pasteMode, changedProps, bProtected);
            } else {
                Protection pro = sheet.getSheetOption().getProtection(false);
                boolean bProtected = pro != null && pro.isProtected();
                oldSSA = dstCell.copyStyle(srcStyle, null, pasteMode, changedProps, bProtected);
            }
            if (state != null && oldSSA != null) {
                dstCell.setUserObject("BDR", dstCell.getUserObjectValue("BDR"));
                this.setCellState(state, dstCell, oldSSA, null);
            }
        }
    }

    private void queryFillParameters(HashMap pos, TrendFactor tf, int count, HashMap queryInfo) {
        pos.put("_query_", null);
        for (Map.Entry e : ((HashMap)tf.getA().getValue()).entrySet()) {
            SortedParameterArray sa = (SortedParameterArray)e.getValue();
            String methodName = (String)e.getKey();
            queryInfo.put("Method_Name", methodName);
            int size = sa.size();
            for (int i = 0; i < size; ++i) {
                Parameter param = sa.getParameter(i);
                Object[] args = param.getArgs();
                Integer uid = param.getUID();
                ArrayList al = (ArrayList)pos.get(uid);
                ExprMethod method = (ExprMethod)al.get(al.size() - 2);
                IMethodFillParameter provider = (IMethodFillParameter)method.getProviderInstance();
                Object[] params = new Object[count];
                for (int j = 0; j < count; ++j) {
                    Object[] dupArgs = new Object[args.length];
                    KDToolkit.arraycopy((Object[])args, (int)0, (Object[])dupArgs, (int)0, (int)args.length);
                    params[j] = dupArgs;
                }
                queryInfo.put("Parameters", params);
                if (provider.getTrendParameters(queryInfo)) {
                    pos.put("_query_" + uid, params);
                    continue;
                }
                tf.setType(256);
            }
        }
    }

    private void fillCell(URState state, Sheet sheet, Cell srcCell, int dstRow, int dstCol, PasteMode pasteMode, TrendFactor tf, int step, String[] userKeys) {
        Cell props;
        Protection pro = sheet.getSheetOption().getProtection(false);
        boolean bProtected = pro != null && pro.isProtected();
        Cell dstCell = sheet.getCell(dstRow, dstCol, false);
        if (dstCell == null) {
            dstCell = this.getStateCell(state, sheet, dstRow, dstCol);
            props = dstCell.copyFrom(srcCell, pasteMode, true, userKeys, bProtected);
        } else {
            props = dstCell.copyFrom(srcCell, pasteMode, true, userKeys, bProtected);
        }
        if (state != null && props != null) {
            Borders bdr = (Borders)props.getUserObjectValue("BDR");
            if (bdr == null) {
                sheet.getBorders().clearOuter(CellBlock.getCellBlock(dstCell.getRow(), dstCell.getCol()), null);
                sheet.getBorders().buildFromSSA();
            }
            this.setCellState(state, props, "", null);
        }
        if (tf != null) {
            if (tf.getType() == 514) {
                WeakHashSet set = sheet.getDeps().getConstBuffer();
                ExprContext ctx = sheet.getDeps().getExprContext();
                HashMap pos = (HashMap)tf.getB().getValue();
                HashMap bag = (HashMap)tf.getA().getValue();
                for (Map.Entry e : bag.entrySet()) {
                    SortedParameterArray sa = (SortedParameterArray)e.getValue();
                    int size = sa.size();
                    for (int p = 0; p < size; ++p) {
                        Object[] oldArg;
                        Object[] newArg;
                        Parameter param = sa.getParameter(p);
                        Integer uid = param.getUID();
                        Object[] newArgs = (Object[])pos.get("_query_" + uid);
                        if (newArgs == null || (newArg = (Object[])newArgs[step > 0 ? step - 1 : newArgs.length + step]).length != (oldArg = param.getArgs()).length) continue;
                        dstCell.getFormula();
                        Expr expr = dstCell.getExpr();
                        ArrayList aPos = (ArrayList)pos.get(uid);
                        boolean changed = false;
                        ObjectArray nodes = expr.getDecodeList(ctx);
                        for (int i = 0; i < oldArg.length; ++i) {
                            Variant old = (Variant)oldArg[i];
                            if (old.isEmpty() || old.equals(newArg[i])) continue;
                            ExprConst node = ExprConst.getExprConst(set, (Variant)newArg[i]);
                            int nodePos = (Integer)aPos.get(i);
                            nodes.set(nodePos, node);
                            changed = true;
                        }
                        if (!changed) continue;
                        String newFormula = expr.decode(nodes, ctx, dstCell, true);
                        dstCell.setFormula(newFormula);
                    }
                }
            } else {
                Variant value = tf.getNext(step);
                if (value != null) {
                    dstCell.setValue(value);
                }
            }
        }
    }

    @Override
    public void preAction(boolean obverse) {
        if (obverse) {
            this._rg._sheets.getSheet(0).getBook().resumeUnknownMethod();
        }
    }

    @Override
    public String getPresentationName() {
        return "\u586b\u5145" + super.getPresentationName();
    }

    @Override
    protected CellBlock getInvalidateBlock(int index) {
        return this._dst;
    }
}

