/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.model.struct.embed.chart;

import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.chartpanelImpl.datachooser.DataLabelUtil;
import com.kingdee.bos.ctrl.ext.util.MiscUtil;
import com.kingdee.bos.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtDataSet;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtDataSetManager;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.embed.chart.ChartResultData;
import com.kingdee.bos.ctrl.kds.model.struct.embed.chart.IChartCalculator;
import com.kingdee.bos.ctrl.kds.model.struct.embed.dataset.DataFromDataset;
import com.kingdee.bos.ctrl.kds.model.struct.embed.dataset.calc.AbstractChartKindOfCalc;
import com.kingdee.bos.ctrl.kds.model.struct.embed.flashchart.FlashChartType;
import com.kingdee.bos.ctrl.swing.chart.AbstractType;
import org.apache.log4j.Logger;

public class ChartDatasetCalculator
implements IChartCalculator {
    private static Logger logger = CommonLogger.getLogger(ChartDatasetCalculator.class);
    private AbstractType chartType;
    private DataFromDataset fromDataset;
    private Book book;

    public ChartDatasetCalculator(Sheet sheet, AbstractType chartType, DataFromDataset fromDataset) {
        this.book = sheet.getBook();
        this.chartType = chartType;
        this.fromDataset = fromDataset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChartResultData calc() {
        AbstractChartKindOfCalc chartKindOfCalc;
        boolean isFindById = false;
        ExtDataSet extDS = null;
        ExtDataSet tempExtDS = null;
        String datasetId = this.fromDataset.getDatasetId();
        String datasetName = this.fromDataset.getDatasetName();
        ExtDataSet[] extDatasets = MiscUtil.collectExtDataSets(this.book);
        for (int i = 0; i < extDatasets.length; ++i) {
            extDS = extDatasets[i];
            String setId = ExtDataSetManager.getDataSetIdByDefine(extDS.getDefine());
            if (setId.equals(datasetId)) {
                isFindById = true;
                this.book.getDataSetManager().updateDataSet(extDS);
                break;
            }
            if (tempExtDS != null || !extDS.getName().equals(datasetName)) continue;
            tempExtDS = extDS;
        }
        if (!isFindById && tempExtDS == null) {
            return null;
        }
        if (!isFindById && tempExtDS != null) {
            extDS = tempExtDS;
            this.book.getDataSetManager().updateDataSet(extDS);
        }
        if ((chartKindOfCalc = DataLabelUtil.getChartKindOfCalc((FlashChartType)this.chartType)) == null) {
            return null;
        }
        long startTime = System.currentTimeMillis();
        try {
            ChartResultData chartResultData = chartKindOfCalc.calc(extDS, this.fromDataset);
            return chartResultData;
        }
        catch (SyntaxErrorException e) {
            logger.error((Object)"\u56fe\u8868\u8ba1\u7b97\u9519\u8bef\uff01", (Throwable)e);
        }
        finally {
            long endTime = System.currentTimeMillis();
            if (MiscUtil.shouldLog()) {
                MiscUtil.info("data from dataset flashchart calc cost time: " + (endTime - startTime));
            }
        }
        return null;
    }

    public void setChartType(FlashChartType chartType) {
        this.chartType = chartType;
    }
}

