/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.transfer.impls;

import com.github.abel533.echarts.AbstractData;
import com.github.abel533.echarts.Option;
import com.github.abel533.echarts.axis.Axis;
import com.github.abel533.echarts.code.LineType;
import com.github.abel533.echarts.code.Position;
import com.github.abel533.echarts.code.SeriesType;
import com.github.abel533.echarts.data.Data;
import com.github.abel533.echarts.json.Var;
import com.github.abel533.echarts.series.Line;
import com.github.abel533.echarts.series.MarkArea;
import com.github.abel533.echarts.series.MarkLine;
import com.github.abel533.echarts.series.Series;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.model.beans.AbstractFusionBean;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.model.beans.column.StackedMSColumn2DBean;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.model.beans.defaultImpl.DefaultCombinationSeriesBean;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.model.struct.Chart;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.util.FusionChartXmlBuilder;
import com.kingdee.bos.ctrl.extcommon.variant.Variant;
import com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.constants.EChartsType;
import com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.transfer.ChartDataTransferUtil;
import com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.transfer.TransferUtils;
import com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.transfer.impls.ConfigurableAbstractTransferImpl;
import com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.transfer.script.JSUtils;
import com.kingdee.bos.ctrl.kds.model.struct.embed.flashchart.FusionChartDataNode;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractAxisTransfer<B extends AbstractFusionBean>
extends ConfigurableAbstractTransferImpl<B> {
    private boolean yValueAxis = false;
    private boolean xValueAxis = false;
    protected String[] groups = null;
    protected Object[] dataValues = null;
    protected Object[] seriesNames = null;
    protected String[] types = null;
    protected String[] yAxis = null;
    protected String[] series = null;
    protected boolean isSeriesByCol;

    public AbstractAxisTransfer(EChartsType type, String desc) {
        super(type, desc);
    }

    public void setyValueAxis(boolean y) {
        this.yValueAxis = y;
    }

    public boolean isyValueAxis() {
        return this.yValueAxis;
    }

    public boolean isxValueAxis() {
        return this.xValueAxis;
    }

    public void setxValueAxis(boolean x) {
        this.xValueAxis = x;
    }

    @Override
    public String initScript(B bean, FusionChartDataNode data) {
        String s = super.initScript(bean, data);
        StringBuilder sb = new StringBuilder();
        sb.append(JSUtils.XAXIS_AXISLABEL_FORMATTER_FUNCTION).append(JSUtils.YAXIS_AXISLABEL_FORMATTER_FUNCTION);
        s = s + sb.toString();
        if ("1".equals(((AbstractFusionBean)bean).getChart().plotGradientColor)) {
            String colorStopStr = "";
            String colorStopStrBlowZero = "";
            if (this.isyValueAxis()) {
                colorStopStr = TransferUtils.buildGradualChangeColorStops("G", this.getColorList().size(), 0, 1, 0, 0);
                colorStopStrBlowZero = TransferUtils.buildGradualChangeColorStops("B", this.getColorList().size(), 0, 0, 0, 1);
            } else if (this.isxValueAxis()) {
                colorStopStr = TransferUtils.buildGradualChangeColorStops("G", this.getColorList().size(), 0, 0, 1, 0);
                colorStopStrBlowZero = TransferUtils.buildGradualChangeColorStops("B", this.getColorList().size(), 1, 0, 0, 0);
            }
            s = s + colorStopStr + colorStopStrBlowZero + TransferUtils.buildColorStopNames("plotGradientColorsB", "B", this.getColorList().size()) + TransferUtils.buildColorStopNames("plotGradientColors", "G", this.getColorList().size());
        }
        if ((bean instanceof DefaultCombinationSeriesBean || bean instanceof StackedMSColumn2DBean) && "cell".equals(data.getDataFrom())) {
            this.groups = ChartDataTransferUtil.parseStrings(data, data.getGroupFormula());
            this.dataValues = (Object[])data.getData(FusionChartDataNode.COMBINATION_CHART_DATA_FORMULA);
            Object[] seriesNamesObject = (Object[])data.getData(FusionChartDataNode.COMBINATION_CHART_SERIES_NAMES);
            this.types = ChartDataTransferUtil.parseValue2StringArray(data.getData(FusionChartDataNode.COMBINATION_CHART_SERIES_TYPE));
            this.seriesNames = ChartDataTransferUtil.parseValue2StringArray(seriesNamesObject);
            String[] seriesFormulas = (String[])data.getFormula(FusionChartDataNode.COMBINATION_CHART_SERIES_FORMULA);
            if (null != seriesFormulas && !TransferUtils.isEmptyStringArray(seriesFormulas)) {
                this.series = (String[])this.seriesNames;
                this.seriesNames = ChartDataTransferUtil.parseStrings(data, seriesFormulas);
            }
            this.yAxis = ChartDataTransferUtil.parseValue2StringArray(data.getData(FusionChartDataNode.COMBINATION_CHART_PARENTYAXIS));
            this.isSeriesByCol = data.isSerialByCol();
        } else {
            this.groups = data.getGroupKeys();
            this.dataValues = (Object[])data.getData();
            this.seriesNames = (Object[])data.getSeriesKeys();
            this.types = data.getChartShowTypes();
            this.yAxis = data.getYAxisPostion();
            if (null != this.seriesNames) {
                this.series = new String[this.seriesNames.length];
                for (int i = 0; i < this.series.length; ++i) {
                    this.series[i] = "";
                }
            }
        }
        return s;
    }

    protected void configureSeriesFillet(Option p, Chart chart) {
        boolean is3DChart = TransferUtils.is3DChart(p);
        for (int i = 0; i < p.getSeries().size(); ++i) {
            Series s = (Series)p.getSeries().get(i);
            if (s.getType() != SeriesType.bar || !"1".equals(chart.useRoundEdges)) continue;
            if (this.isxValueAxis() && !is3DChart) {
                s.itemStyle().normal().barBorderRadius((Object)new Integer[]{0, 10, 10, 0});
                continue;
            }
            if (!this.isyValueAxis() || is3DChart) continue;
            s.itemStyle().normal().barBorderRadius((Object)new Integer[]{10, 10, 0, 0});
        }
    }

    @Override
    protected void configureNumberFormat(Option p, String[] chartCaptions, FusionChartDataNode data) {
        super.configureNumberFormat(p, chartCaptions, data);
        String t = FusionChartXmlBuilder.getChartXTitleScale(chartCaptions[9]);
        this.setAxisLabelDisplayMode(p, t);
    }

    protected void configureSeries(Option p, Chart chart, String[] chartCaptions) {
        String zeroPointMode = TransferUtils.getZeroPointMode(chartCaptions);
        for (int i = 0; i < p.getSeries().size(); ++i) {
            Series s = (Series)p.getSeries().get(i);
            if (s.getType() != SeriesType.line) continue;
            Line line = (Line)s;
            if ("0".equals(chart.drawAnchors) && null == line.getAreaStyle()) {
                line.showSymbol(Boolean.valueOf(false));
            }
            ArrayList<Object> filterList = new ArrayList<Object>();
            for (int j = 0; j < line.getData().size(); ++j) {
                Object d = line.getData().get(j);
                if (null == d || d.equals(Double.NaN)) {
                    if ("\u96f6\u503c".equals(zeroPointMode)) {
                        filterList.add(0);
                        continue;
                    }
                    if ("\u7a7a\u8ddd".equals(zeroPointMode)) {
                        filterList.add("-");
                        continue;
                    }
                    filterList.add(null);
                    line.connectNulls(Boolean.valueOf(true));
                    continue;
                }
                filterList.add(d);
            }
            line.setData(filterList);
        }
    }

    @Override
    public String afterScript(B b, FusionChartDataNode data, Option p) {
        Chart chart = ((AbstractFusionBean)b).getChart();
        String[] chartCaptions = ((AbstractFusionBean)b).buildChartCaptions1(data);
        this.configureScaleMark(p, chartCaptions);
        this.configureSeries(p, chart, chartCaptions);
        this.configureSeriesFillet(p, chart);
        this.configureDataNode(p, chart, chartCaptions);
        this.configureValueAxis(p, chart, data);
        this.configureTrendLine(data, p);
        return super.afterScript(b, data, p);
    }

    protected void configureTrendLineValue(Option p, String colorStr, String trendLineMin, String trendLineMax, String showMarkLineValue) {
        List series = p.getSeries();
        if ("1".equals(showMarkLineValue)) {
            ((Series)series.get(0)).markPoint().symbol((Object)"pin");
            ((Series)series.get(0)).markPoint().symbolSize((Object)1);
            ((Series)series.get(0)).markPoint().tooltip().formatter((Object)"{c}");
            ((Series)series.get(0)).markPoint().label().color(colorStr);
            ((Series)series.get(0)).markPoint().label().position((Object)"top");
            if (this.isyValueAxis()) {
                TransferUtils.setTrendLineValue((AbstractData)((Series)series.get(0)).markPoint(), "{value:'%s', coord:[%s,%s]},{value:'%s', coord:[%s,%s]}", trendLineMin, "0", trendLineMin, trendLineMax, TransferUtils.getSeriesMaxDataLength(series) - 1 + "", trendLineMax);
            } else {
                TransferUtils.setTrendLineValue((AbstractData)((Series)series.get(0)).markPoint(), "{value:'%s', coord:[%s,%s]},{value:'%s', coord:[%s,%s]}", trendLineMin, trendLineMin, "0", trendLineMax, trendLineMax, TransferUtils.getSeriesMaxDataLength(series) - 1 + "");
            }
        }
    }

    protected void configreTrendAsLine(Option p, String labelOnRight, String isDotted, String nameStr, String colorStr, String trendLineMin, String trendLineMax) {
        List series = p.getSeries();
        ((Series)series.get(0)).markLine().label().position((Object)"start");
        ((Series)series.get(0)).markLine().symbol((Object)"none");
        if (TransferUtils.is3DChart(p)) {
            ((Series)series.get(0)).markLine().tooltip().formatter((Object)"{c}");
        } else {
            ((Series)series.get(0)).markLine().tooltip().formatter((Object)"{b}");
        }
        ((Series)series.get(0)).markLine().itemStyle().color((Object)colorStr);
        if (this.isyValueAxis()) {
            TransferUtils.setTrendLineValue((AbstractData)((Series)series.get(0)).markLine(), "[{name:'%s', coord:[%s,%s]},{coord:[%s,%s]}]", nameStr, "0", trendLineMin, TransferUtils.getSeriesMaxDataLength(series) - 1 + "", trendLineMax);
        } else if (this.isxValueAxis()) {
            TransferUtils.setTrendLineValue((AbstractData)((Series)series.get(0)).markLine(), "[{name:'%s', coord:[%s,%s]},{coord:[%s,%s]}]", nameStr, trendLineMin, "0", trendLineMax, TransferUtils.getSeriesMaxDataLength(series) - 1 + "");
        }
        if (!"1".equals(isDotted)) {
            ((Series)series.get(0)).markLine().lineStyle().type(LineType.solid);
        } else {
            ((Series)series.get(0)).markLine().lineStyle().type(LineType.dotted);
        }
        if ("1".equals(labelOnRight)) {
            ((Series)series.get(0)).markLine().label().position((Object)"end");
        }
    }

    protected void configureDataNode(Option p, Chart chart, String[] chartCaptions) {
        boolean is3DChart = TransferUtils.is3DChart(p);
        int i = 0;
        int seriesCount = is3DChart ? p.getSeries().size() / 2 : p.getSeries().size();
        for (int j = 0; j < p.getSeries().size(); ++j) {
            Series s = (Series)p.getSeries().get(j);
            ArrayList<Object> r = new ArrayList<Object>();
            for (int n = 0; n < s.getData().size(); ++n) {
                Object d = s.getData().get(n);
                if (TransferUtils.isBelowZero(d)) {
                    Data sData = new Data();
                    sData.setValue(d);
                    if ("1".equals(chart.useRoundEdges) && s.getType() == SeriesType.bar && !is3DChart) {
                        this.setBlowZeroDataRoundEdges(sData, this.xValueAxis, j, n);
                    }
                    if (s.getType() == SeriesType.pictorialBar && "diamond".equals(s.getSymbol())) {
                        this.setPictorialBarPostion(s, sData, this.xValueAxis);
                    }
                    if (null == s.getLabel() && TransferUtils.isShowNumber(chartCaptions) && (!is3DChart || s.getType() != SeriesType.pictorialBar)) {
                        this.setBelowZeroDataShowNumberPostion(TransferUtils.isStackedSeries(s) || is3DChart, sData, this.xValueAxis, this.yValueAxis);
                    }
                    if ("1".equals(chart.plotGradientColor)) {
                        sData.itemStyle().normal().color((Object)new Var("plotGradientColorsB[" + i % seriesCount + ']'));
                    }
                    r.add(sData);
                    continue;
                }
                r.add(d);
            }
            s.setData(r);
            if (null == s.getLabel() && TransferUtils.isShowNumber(chartCaptions) && (!is3DChart || s.getType() != SeriesType.pictorialBar)) {
                this.setShowNumberPostion(is3DChart || TransferUtils.isStackedSeries(s), s, this.xValueAxis, this.yValueAxis);
            }
            if (s.getType() == SeriesType.pictorialBar) continue;
            ++i;
        }
    }

    protected void setBelowZeroDataShowNumberPostion(boolean forceInside, Data d, boolean x, boolean y) {
        d.label().show(Boolean.valueOf(true));
        if (forceInside) {
            d.label().normal().position(Position.inside);
        } else if (x) {
            d.label().normal().position(Position.left);
        } else if (y) {
            d.label().normal().position(Position.bottom);
        }
    }

    protected void setShowNumberPostion(boolean forceInside, Series<?> s, boolean x, boolean y) {
        s.label().normal().show(Boolean.valueOf(true));
        if (forceInside) {
            s.label().normal().position(Position.inside);
        } else if (x) {
            s.label().normal().position(Position.right);
        } else if (y) {
            s.label().normal().position(Position.top);
        } else {
            s.label().normal().position(Position.inside);
        }
    }

    protected void setBlowZeroDataRoundEdges(Data d, boolean x, int seriesIndex, int dataIndex) {
        if (x) {
            d.itemStyle().normal().barBorderRadius((Object)new Integer[]{10, 0, 0, 10});
        } else {
            d.itemStyle().normal().barBorderRadius((Object)new Integer[]{0, 0, 10, 10});
        }
    }

    protected void setPictorialBarPostion(Series<?> s, Data d, boolean x) {
        Object[] offObjects = s.getSymbolOffset();
        if (x) {
            d.symbolOffset((Object)"-50%", offObjects[1]);
        } else {
            d.symbolOffset(offObjects[0], (Object)"50%");
        }
    }

    protected void configureValueAxis(Option p, Chart chart, FusionChartDataNode data) {
        Object[] trendLine = (Object[])data.getFormula(FusionChartDataNode.TRENDLINES);
        String trendLineMin = null;
        String trendLineMax = null;
        if (null != trendLine) {
            trendLineMin = (String)trendLine[6];
            trendLineMax = (String)trendLine[7];
        }
        if (this.yValueAxis) {
            this.configureValueAxisXY(chart, data, trendLineMin, trendLineMax, p.getyAxis(), false);
        }
        if (this.xValueAxis) {
            if (this.yValueAxis) {
                this.configureValueAxisXY(chart, data, null, null, p.getxAxis(), true);
            } else {
                this.configureValueAxisXY(chart, data, trendLineMin, trendLineMax, p.getxAxis(), true);
            }
        }
    }

    protected void configureValueAxisXY(Chart chart, FusionChartDataNode data, String trendLineMin, String trendLineMax, List<Axis> axis, boolean isX) {
        String temp = null;
        if (null != trendLineMin && null != trendLineMax && Integer.parseInt(trendLineMin) > Integer.parseInt(trendLineMax)) {
            temp = trendLineMin;
            trendLineMin = trendLineMax;
            trendLineMax = temp;
        }
        if (!axis.isEmpty()) {
            Double interval;
            double n;
            double m;
            Axis ax = axis.get(0);
            Object[] values = (Object[])data.getData(FusionChartDataNode.XY_MAX_MIN);
            if (values == null || values.length == 0) {
                return;
            }
            Variant[][] vt = (Variant[][])values[2];
            Double dataMax = TransferUtils.getDataMax(data);
            if (vt != null && vt.length > 0 && vt[0][0].isNumber()) {
                String value = vt[0][0].getValue().toString();
                Double max = TransferUtils.getMax(value, trendLineMax);
                if (null != max) {
                    ax.setMax((Object)max);
                }
            } else if (null != trendLineMax && !isX) {
                if (null != dataMax && Double.parseDouble(trendLineMax) > dataMax) {
                    ax.setMax((Object)trendLineMax);
                }
            } else if (null != dataMax && (m = TransferUtils.ceil(dataMax)) != dataMax) {
                ax.setMax((Object)m);
            }
            vt = (Variant[][])values[3];
            Double dataMin = TransferUtils.getDataMin(data);
            if (vt != null && vt.length > 0 && vt[0][0].isNumber()) {
                String value = vt[0][0].getValue().toString();
                Double min = TransferUtils.getMin(value, trendLineMin);
                if (null != min) {
                    ax.setMin((Object)min);
                }
            } else if (null != trendLineMin) {
                if (null != dataMin && Double.parseDouble(trendLineMin) < dataMin) {
                    ax.setMin((Object)trendLineMin);
                }
            } else if (null != dataMin && (n = TransferUtils.ceil(dataMin)) != dataMin) {
                ax.setMin((Object)n);
            }
            if ("0".equals(chart.showYAxisValues2)) {
                ax.axisLabel().show(Boolean.valueOf(false));
            }
            if (null != (interval = TransferUtils.getInterval(chart))) {
                ax.setInterval((Object)interval);
            }
        }
    }

    protected void configureScaleMark(Option p, String[] chartCaptions) {
        List axis = new ArrayList();
        if (this.yValueAxis) {
            axis = p.getyAxis();
        } else if (this.xValueAxis) {
            axis = p.getxAxis();
        }
        if (null != axis && !axis.isEmpty()) {
            for (Axis s : axis) {
                s.splitArea().show(Boolean.valueOf(true));
                s.splitLine().lineStyle().opacity(Double.valueOf(chartCaptions.length >= 46 ? Double.valueOf(chartCaptions[45]) / 100.0 : 0.5));
                s.splitArea().areaStyle().opacity(Double.valueOf(chartCaptions.length >= 47 ? Double.valueOf(chartCaptions[46]) / 100.0 : 0.5));
            }
        }
    }

    protected void configureTrendLine(FusionChartDataNode data, Option p) {
        block11: {
            Object[] trendLine = (Object[])data.getFormula(FusionChartDataNode.TRENDLINES);
            List series = p.getSeries();
            if (null == trendLine || null == series || series.isEmpty()) break block11;
            String onTop = (String)trendLine[0];
            String labelOnRight = (String)trendLine[1];
            String isArea = (String)trendLine[2];
            String isDotted = (String)trendLine[3];
            if ("TRENDLINE - Null - VALUE".equals(trendLine[4])) {
                trendLine[4] = "";
            }
            String nameStr = (String)trendLine[4];
            String colorStr = (String)trendLine[5];
            String trendLineMin = (String)trendLine[6];
            String trendLineMax = (String)trendLine[7];
            String showMarkLineValue = (String)trendLine[8];
            if ("1".equals(isArea)) {
                ((Series)series.get(0)).markArea().itemStyle().color((Object)colorStr);
                ((Series)series.get(0)).markArea().tooltip().formatter((Object)"{b}");
                TransferUtils.setTrendLineValue((AbstractData)((Series)series.get(0)).markArea(), "[{name: '%s',yAxis: %s},{yAxis: %s}]", nameStr, trendLineMin, trendLineMax);
            } else {
                this.configreTrendAsLine(p, labelOnRight, isDotted, nameStr, colorStr, trendLineMin, trendLineMax);
            }
            this.configureTrendLineValue(p, colorStr, trendLineMin, trendLineMax, showMarkLineValue);
            if ("1".equals(onTop)) {
                boolean hasMarkArea = false;
                if (TransferUtils.is3DChart(p)) {
                    MarkArea m = ((Series)p.getSeries().get(0)).getMarkArea();
                    if (null != m) {
                        hasMarkArea = true;
                    }
                    MarkLine l = ((Series)p.getSeries().get(0)).getMarkLine();
                    ((Series)series.get(series.size() - 1)).setMarkArea(m);
                    ((Series)series.get(series.size() - 1)).setMarkLine(l);
                    ((Series)series.get(0)).setMarkArea(null);
                    ((Series)series.get(0)).setMarkLine(null);
                }
                for (Series s : series) {
                    Integer z = s.getZ();
                    if (hasMarkArea) {
                        s.setZ(Integer.valueOf(0));
                    }
                    if (null != z) continue;
                    s.setZ(Integer.valueOf(0));
                }
            } else {
                for (Series s : series) {
                    Integer z = s.getZ();
                    if (null == z) {
                        s.setZ(Integer.valueOf(5));
                        continue;
                    }
                    s.setZ(Integer.valueOf(z + 5));
                }
            }
        }
    }
}

