/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.transfer.impls.bar;

import com.github.abel533.echarts.Option;
import com.github.abel533.echarts.axis.CategoryAxis;
import com.github.abel533.echarts.axis.ValueAxis;
import com.github.abel533.echarts.code.PointerType;
import com.github.abel533.echarts.code.Trigger;
import com.github.abel533.echarts.series.Bar;
import com.github.abel533.echarts.series.PictorialBar;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.model.beans.bar.StackedBar3DBean;
import com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.constants.EChartConstants;
import com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.constants.EChartsType;
import com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.transfer.TransferUtils;
import com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.transfer.impls.AbstractStackedTransfer;
import com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.transfer.script.JSUtils;
import com.kingdee.bos.ctrl.kds.model.struct.embed.flashchart.FusionChartDataNode;

public class StackedBar3DBeanTransferImpl
extends AbstractStackedTransfer<StackedBar3DBean> {
    public StackedBar3DBeanTransferImpl() {
        super(EChartsType.BAR3D, "3d\u5806\u79ef\u6761\u5f62\u56fe\uff0c\u4f7f\u75282d\u56fe\u6a21\u62df\u62103d\u6548\u679c\u3002");
        this.setyValueAxis(false);
        this.setxValueAxis(true);
    }

    @Override
    public String initScript(StackedBar3DBean bean, FusionChartDataNode dataNode) {
        double[][] data = (double[][])dataNode.getData();
        return super.initScript(bean, dataNode) + this.buildColorStopsUp(data.length);
    }

    @Override
    public Option transfer2Opiton(StackedBar3DBean b, FusionChartDataNode dataNode) {
        double[][] data = (double[][])dataNode.getData();
        if (null == this.groups || null == data) {
            return null;
        }
        Object[] series = (String[])dataNode.getSeriesKeys();
        ValueAxis valueAxis = new ValueAxis();
        Option p = super.transfer2Opiton(b, dataNode);
        p.xAxis().add(valueAxis);
        if (null != p.getLegend()) {
            p.legend().data(series);
        }
        if (null != p.getTooltip()) {
            p.tooltip().trigger(Trigger.axis);
            p.tooltip().axisPointer().type(PointerType.shadow);
        }
        CategoryAxis caxis = new CategoryAxis();
        for (String group : this.groups) {
            caxis.data().add(group);
        }
        double[] proportion = TransferUtils.getStackedDiamondProportion(data);
        for (int i = 0; i < data.length; ++i) {
            Bar bar = new Bar();
            bar.name((String)series[i]);
            bar.itemStyle().normal().color((Object)("function(){return colorStop" + i + " ;}"));
            PictorialBar p2 = new PictorialBar();
            p2.z(Integer.valueOf(3));
            p2.name((String)series[i]);
            p2.tooltip().trigger(Trigger.none);
            p2.symbol((Object)"diamond");
            p2.symbolOffset((Object)"50%", (Object)0);
            p2.itemStyle().normal().color((Object)"function(index){return colors[((index.seriesIndex + 1) / 2 -1)  % colors.length];}");
            p2.symbolSize((Object)new String[]{proportion[i] * 30.0 + "%", "100%"});
            p2.setSymbolPosition((Object)"end");
            for (int j = 0; j < data[i].length; ++j) {
                bar.stack(this.groups[j]);
                bar.data().add(data[i][j]);
                p2.data().add(TransferUtils.stackValueGroupByNeg(data, j, i, data[i][j] < 0.0));
            }
            p.series().add(bar);
            p.series().add(p2);
        }
        p.yAxis().add(caxis);
        return p;
    }

    @Override
    public Option mockOption(StackedBar3DBean bean) {
        return null;
    }

    @Override
    public String initMockScript(StackedBar3DBean bean) {
        return super.initMockScript(bean) + this.buildColorStopsUp(5) + TransferUtils.getResourceAsString(this.getClass(), "StackedBar3DBeanTransferImpl.json", EChartConstants.DEMOFILE_ENCODING);
    }

    @Override
    public String afterMockScript(StackedBar3DBean bean) {
        return super.afterMockScript(bean) + JSUtils.ONLEGENDCHANGED_FUNCTION;
    }

    @Override
    public String afterScript(StackedBar3DBean b, FusionChartDataNode data, Option p) {
        return super.afterScript(b, data, p) + JSUtils.ONLEGENDCHANGED_FUNCTION;
    }
}

