/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.transfer.impls.combination;

import com.github.abel533.echarts.Grid3D;
import com.github.abel533.echarts.Option;
import com.github.abel533.echarts.axis.Axis;
import com.github.abel533.echarts.axis.CategoryAxis;
import com.github.abel533.echarts.axis.ValueAxis;
import com.github.abel533.echarts.code.PointerType;
import com.github.abel533.echarts.code.Trigger;
import com.github.abel533.echarts.series.Bar3D;
import com.github.abel533.echarts.series.Line3D;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.model.beans.combination.Combination3DBean;
import com.kingdee.bos.ctrl.extcommon.variant.Variant;
import com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.constants.EChartConstants;
import com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.constants.EChartsType;
import com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.transfer.ChartDataTransferUtil;
import com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.transfer.TransferUtils;
import com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.transfer.impls.ConfigurableAbstractTransferImpl;
import com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.transfer.script.JSUtils;
import com.kingdee.bos.ctrl.kds.model.struct.embed.flashchart.FusionChartDataNode;
import com.kingdee.bos.util.backport.Arrays;
import java.util.ArrayList;
import java.util.List;

public class Combination3DBeanTransferImpl
extends ConfigurableAbstractTransferImpl<Combination3DBean> {
    public Combination3DBeanTransferImpl() {
        super(EChartsType.BAR3D, "3d\u7ec4\u5408\u56fe\uff0c\u4f7f\u7528echart gl\u76843d\u56fe\u5f62\u7ed8\u5236\u3002");
    }

    @Override
    public String initMockScript(Combination3DBean bean) {
        return super.initMockScript(bean) + TransferUtils.getResourceAsString(this.getClass(), "Combination3DBeanTransferImpl.json", EChartConstants.DEMOFILE_ENCODING);
    }

    @Override
    public Option transfer2Opiton(Combination3DBean bean, FusionChartDataNode dataNode) {
        Option p = super.transfer2Opiton(bean, dataNode);
        if (null != p.getTooltip()) {
            p.tooltip().trigger(Trigger.axis);
            p.tooltip().axisPointer().type(PointerType.shadow);
        }
        String[] groups = ChartDataTransferUtil.parseStrings(dataNode, dataNode.getGroupFormula());
        Object[] dataValues = (Object[])dataNode.getData(FusionChartDataNode.COMBINATION_CHART_DATA_FORMULA);
        Object[] seriesNames = (Object[])dataNode.getData(FusionChartDataNode.COMBINATION_CHART_SERIES_NAMES);
        String[] types = ChartDataTransferUtil.parseValue2StringArray(dataNode.getData(FusionChartDataNode.COMBINATION_CHART_SERIES_TYPE));
        List asList = Arrays.asList((Object[])ChartDataTransferUtil.parseValue2StringArray(seriesNames));
        if (null != p.getLegend()) {
            p.legend().data(asList);
        }
        if (null == dataValues || null == groups) {
            return null;
        }
        CategoryAxis caxis = new CategoryAxis();
        for (String group : groups) {
            caxis.data().add(group);
        }
        int tLen = types.length;
        ArrayList<Bar3D> serieList = new ArrayList<Bar3D>();
        for (int i = 0; i < tLen; ++i) {
            if (!(dataValues[i] instanceof Variant[][])) continue;
            Variant[][] data = (Variant[][])dataValues[i];
            Bar3D serie = new Bar3D();
            serie.bevelSmoothness(Integer.valueOf(2));
            if (TransferUtils.isLineType(types[i])) {
                serie = new Line3D();
                serie.width(Integer.valueOf(3));
            } else if (TransferUtils.isAreaType(types[i])) {
                Line3D line = new Line3D();
                line.areaStyle();
                line.width(Integer.valueOf(10));
                line.height(Integer.valueOf(10));
                serie = line;
            }
            for (int j = 0; j < data.length; ++j) {
                for (int d = 0; d < data[j].length; ++d) {
                    Object[] xyData = new Object[]{j, i * 20, data[j][d].getValue()};
                    serie.data().add(xyData);
                }
            }
            String name = asList.get(i).toString();
            serie.name(name);
            serieList.add(serie);
        }
        CategoryAxis caxisy = new CategoryAxis();
        caxisy.data().add("");
        p.yAxis3D(new Axis[]{caxisy});
        ValueAxis valueAxis = new ValueAxis();
        p.zAxis3D(new Axis[]{valueAxis});
        p.xAxis3D().add(caxis);
        Grid3D grid3d = new Grid3D();
        grid3d.boxWidth(Integer.valueOf(200)).boxDepth(Integer.valueOf(20));
        grid3d.viewControl().alpha(Double.valueOf(10.0)).beta(Double.valueOf(20.0));
        p.setGrid3D(grid3d);
        p.series().addAll(serieList);
        return p;
    }

    @Override
    public Option mockOption(Combination3DBean bean) {
        return null;
    }

    @Override
    public String afterMockScript(Combination3DBean bean) {
        return super.afterMockScript(bean) + JSUtils.ONLEGENDCHANGED_FUNCTION;
    }

    @Override
    public String afterScript(Combination3DBean b, FusionChartDataNode data, Option p) {
        return super.afterScript(b, data, p) + JSUtils.ONLEGENDCHANGED_FUNCTION;
    }
}

