/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.model.struct.filter;

import com.kingdee.bos.ctrl.extcommon.variant.Variant;
import com.kingdee.bos.ctrl.kds.expans.model.ExtConst;
import com.kingdee.bos.ctrl.kds.expans.model.ExtProps;
import com.kingdee.bos.ctrl.kds.expans.model.collection.SortedExtPropFormulasArray;
import com.kingdee.bos.ctrl.kds.model.struct.Cell;
import com.kingdee.bos.ctrl.kds.model.struct.CellBlock;
import com.kingdee.bos.ctrl.kds.model.struct.MergeBlocks;
import com.kingdee.bos.ctrl.kds.model.struct.Range;
import com.kingdee.bos.ctrl.kds.model.struct.Row;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.kds.model.struct.SortedAttributeSpanArray;
import com.kingdee.bos.ctrl.kds.model.struct.SortedColumnArray;
import com.kingdee.bos.ctrl.kds.model.struct.SortedRowArray;
import com.kingdee.bos.ctrl.kds.model.struct.Span;
import com.kingdee.bos.ctrl.kds.model.struct.embed.EmbedObject;
import com.kingdee.bos.ctrl.kds.model.struct.embed.EmbedhLayer;
import com.kingdee.bos.ctrl.kds.model.struct.embed.chart.Chart;
import com.kingdee.bos.ctrl.kds.model.struct.embed.chart.ChartDataNode;
import com.kingdee.bos.ctrl.kds.model.struct.embed.chart.ChartModel;
import com.kingdee.bos.ctrl.kds.model.struct.embed.flashchart.FlashChart;
import com.kingdee.bos.ctrl.kds.model.struct.filter.ISheetAutoFilter;
import com.kingdee.bos.ctrl.kds.model.util.IntArray;
import com.kingdee.bos.ctrl.kds.model.util.SortedCellBlockArray;
import com.kingdee.bos.ctrl.kds.model.util.SortedSpanArray;
import java.awt.Rectangle;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;

public class AlgorithmUtil {
    public static SimpleDateFormat sd_yyyy_MM_dd = new SimpleDateFormat("yyyy-MM-dd");
    public static SimpleDateFormat sd_yyyy_MM_dd_HH_mm_ss = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public static void showRow(Sheet sheet, ArrayList<Integer> rows, boolean isHedden) {
        if (rows == null || rows.isEmpty()) {
            return;
        }
        sheet.getBook().setSkipListeners(true);
        if (rows.size() == 1) {
            sheet.getRowRange(rows.get(0), rows.get(0)).setHidden(isHedden, true);
        } else {
            int row1 = -1;
            int middle = -1;
            int row2 = -1;
            SortedCellBlockArray blockArray = new SortedCellBlockArray();
            int size = rows.size();
            for (int i = 0; i < size; ++i) {
                if (row1 == -1) {
                    middle = row1 = rows.get(i).intValue();
                    row2 = -1;
                    continue;
                }
                row2 = rows.get(i);
                if (middle + 1 == row2) {
                    middle = row2;
                    continue;
                }
                blockArray.insert(CellBlock.getCellBlock(row1, 0, middle, 65535));
                middle = row1 = row2;
                row2 = -1;
            }
            if (row1 != -1 && row2 == -1) {
                blockArray.insert(CellBlock.getCellBlock(row1, 0, row1, 65535));
            } else if (row1 != -1 && row2 != -1) {
                blockArray.insert(CellBlock.getCellBlock(row1, 0, row2, 65535));
            }
            if (!blockArray.isEmpty()) {
                Range r = new Range(sheet.getBook(), sheet, blockArray.toArray());
                r.setHidden(isHedden, true);
            }
        }
        sheet.getBook().setSkipListeners(false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean matchesQuestionMark(String regex, String matchString) {
        regex = "^" + regex + "$";
        List<String> questionMarkStringList = AlgorithmUtil.split(regex, '?', '~');
        if (questionMarkStringList.size() == 1) {
            regex = questionMarkStringList.get(0);
            regex = regex.substring(1, regex.length() - 1);
            return matchString.contains(regex = regex.replaceAll("~~", "~"));
        }
        int minLength = -2;
        for (String temp : questionMarkStringList) {
            String tempString = new String(temp);
            tempString = tempString.replaceAll("~~", "~");
            minLength += tempString.length();
        }
        if ((minLength += questionMarkStringList.size() - 1) > matchString.length()) {
            return false;
        }
        String copytemp = matchString;
        int indexZ = 0;
        block1: while (copytemp.length() > 0) {
            copytemp = matchString.substring(indexZ);
            if (copytemp.length() < minLength) {
                return false;
            }
            for (int index = 0; index < questionMarkStringList.size(); ++index) {
                String questionMarkString = questionMarkStringList.get(index);
                if (index == 0) {
                    questionMarkString = questionMarkString.substring(1);
                } else if (index == questionMarkStringList.size() - 1) {
                    questionMarkString = questionMarkString.substring(0, questionMarkString.length() - 1);
                }
                questionMarkString = questionMarkString.replaceAll("~~", "~");
                if (!copytemp.contains(questionMarkString)) return false;
                if (copytemp.startsWith(questionMarkString)) {
                    if (questionMarkString.length() + 1 >= copytemp.length()) {
                        return true;
                    }
                } else {
                    ++indexZ;
                    continue block1;
                }
                copytemp = copytemp.substring(questionMarkString.length() + 1);
            }
        }
        return false;
    }

    public static boolean matches(String regex, String matchString) {
        matchString = matchString == null ? "" : matchString;
        regex = "^" + (regex == null ? "" : regex) + "$";
        while (regex.contains("**")) {
            regex = regex.replace("**", "*");
        }
        List<String> regexs = AlgorithmUtil.split(regex, '*', '~');
        if (regexs.size() == 1) {
            regex = regexs.get(0);
            int length = (regex = regex.substring(1, regex.length() - 1)).replaceAll("~\\?", "?").replaceAll("~~", "~").length();
            return length == matchString.length() && AlgorithmUtil.matchesQuestionMark(regex, matchString);
        }
        int minLength = -2;
        for (String temp : regexs) {
            int length = temp.replaceAll("~\\?", "?").replaceAll("~~", "~").length();
            minLength += length;
        }
        if (matchString.length() < minLength) {
            return false;
        }
        boolean beginXing = false;
        boolean endXing = false;
        if ("^".equals(regexs.get(0))) {
            beginXing = true;
        }
        if ("$".equals(regexs.get(regexs.size() - 1))) {
            endXing = true;
        }
        ArrayList<Integer> intArray = new ArrayList<Integer>();
        intArray.add(0, -1);
        block2: while (true) {
            int index = 0;
            while (true) {
                String subString;
                int regexLeng;
                if (index >= regexs.size()) continue block2;
                String regexTemp = regexs.get(index);
                int indexX = (Integer)intArray.get(index) < 0 ? 0 : (Integer)intArray.get(index);
                String copymatchString = matchString.substring(indexX);
                if (index == 0) {
                    regexTemp = regexTemp.substring(1);
                    regexLeng = regexTemp.replaceAll("~\\?", "?").replaceAll("~~", "~").length();
                    if (beginXing) {
                        intArray.set(index, (Integer)intArray.get(index) + 1);
                    } else {
                        subString = copymatchString.substring(0, regexLeng);
                        if (!AlgorithmUtil.matchesQuestionMark(regexTemp = regexTemp.replaceAll("~\\*", "*"), subString)) {
                            return false;
                        }
                    }
                    intArray.add(index + 1, (Integer)intArray.get(index) + regexLeng);
                } else {
                    if (index == regexs.size() - 1) {
                        if (endXing) {
                            return true;
                        }
                        regexTemp = regexTemp.substring(0, regexTemp.length() - 1);
                        regexLeng = regexTemp.replaceAll("~\\?", "?").replaceAll("~~", "~").length();
                        subString = copymatchString.substring(copymatchString.length() - regexLeng);
                        return AlgorithmUtil.matchesQuestionMark(regexTemp, subString);
                    }
                    if (!AlgorithmUtil.matchesQuestionMark(regexTemp, copymatchString)) {
                        return false;
                    }
                    int length = (Integer)intArray.get(index);
                    int regexLeng2 = regexTemp.replaceAll("~\\?", "?").replaceAll("~~", "~").length();
                    String subString2 = matchString.substring(length, length + regexLeng2);
                    while (!AlgorithmUtil.matchesQuestionMark(regexTemp, subString2)) {
                        subString2 = matchString.substring(++length, length + regexLeng2);
                    }
                    intArray.add(index + 1, (Integer)intArray.get(index) + regexLeng2);
                }
                ++index;
            }
            break;
        }
    }

    private static List<String> split(String splitString, char breakString, char unBreakMark) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuffer workString = new StringBuffer();
        boolean isUnBreakMark = false;
        for (int fromIndex = 0; fromIndex < splitString.length(); ++fromIndex) {
            char temp = splitString.charAt(fromIndex);
            if (temp == unBreakMark) {
                if (isUnBreakMark) {
                    workString.append(unBreakMark);
                    workString.append(unBreakMark);
                    isUnBreakMark = false;
                    continue;
                }
                isUnBreakMark = true;
                continue;
            }
            if (temp == breakString) {
                if (isUnBreakMark) {
                    workString.append(breakString);
                    isUnBreakMark = false;
                    continue;
                }
                result.add(workString.toString());
                workString = new StringBuffer();
                continue;
            }
            if (isUnBreakMark) {
                workString.append(unBreakMark);
                isUnBreakMark = false;
            }
            workString.append(temp);
        }
        if (workString.length() > 0) {
            result.add(workString.toString());
        } else {
            result.add("");
        }
        return result;
    }

    public static ArrayList<Integer> getBeforeFilterArea(Sheet sheet, int filterBeginIndex) {
        ArrayList<Integer> beforeFilterArea = new ArrayList<Integer>();
        if (sheet.getAutoFilterArea() == null) {
            return beforeFilterArea;
        }
        int size = sheet.getAutoFilters().size();
        if (filterBeginIndex <= -1 || size == 0) {
            int begin = sheet.getAutoFilterArea().getRow();
            int end = sheet.getAutoFilterArea().getRow2();
            int[] securityRows = sheet.getSecHidedRows();
            for (int i = begin + 1; i <= end; ++i) {
                if (AlgorithmUtil.contain(securityRows, i)) continue;
                beforeFilterArea.add(i);
            }
            return beforeFilterArea;
        }
        if (filterBeginIndex >= size) {
            filterBeginIndex = size - 1;
        }
        beforeFilterArea = ((ISheetAutoFilter)sheet.getAutoFilters().get(filterBeginIndex)).getAfterFilterArea();
        return beforeFilterArea;
    }

    public static ArrayList<Integer> getBeforeFilterAreaLast(Sheet sheet) {
        ArrayList<Integer> beforeFilterArea = new ArrayList<Integer>();
        if (sheet.getAutoFilterArea() == null) {
            return beforeFilterArea;
        }
        return AlgorithmUtil.getBeforeFilterArea(sheet, sheet.getAutoFilters().size() - 1);
    }

    public static ArrayList<Integer> calcFilterResult(Sheet sheet, int beginIndex) {
        int index;
        if (sheet.getAutoFilterArea() == null) {
            return new ArrayList<Integer>();
        }
        int size = sheet.getAutoFilters().size();
        ArrayList<Integer> afterFilterArea = AlgorithmUtil.getBeforeFilterArea(sheet, index - 1);
        for (index = beginIndex <= -1 || beginIndex >= size ? 0 : beginIndex; index < size; ++index) {
            ISheetAutoFilter tempFilter = (ISheetAutoFilter)sheet.getAutoFilters().get(index);
            tempFilter.setBeforeFilterArea(afterFilterArea);
            tempFilter.exec();
            afterFilterArea = tempFilter.getAfterFilterArea();
        }
        return afterFilterArea;
    }

    public static boolean contain(int[] array, int value) {
        if (null == array || array.length == 0) {
            return false;
        }
        for (int i = 0; i < array.length - 1; i += 2) {
            if (array[i] > value || array[i + 1] < value) continue;
            return true;
        }
        return false;
    }

    public static void delHideRowsAndCols(int[] rows, int[] cols, Sheet sheet) {
        Range r;
        int i;
        int len;
        Range rg;
        if (rows != null && rows.length >= 2) {
            SortedSpanArray rowSpans = new SortedSpanArray();
            for (int i2 = 0; i2 < rows.length - 1; i2 += 2) {
                rowSpans.restruct(rows[i2], rows[i2 + 1]);
            }
            Span span = (Span)rowSpans.get(0);
            if (span != null) {
                rg = sheet.getRange(CellBlock.getCellBlock(span.getStart(), 0, span.getEnd(), 65535));
                int delRows = span.getEnd() - span.getStart() + 1;
                len = rowSpans.size();
                for (i = 1; i < len; ++i) {
                    span = (Span)rowSpans.get(i);
                    r = sheet.getRange(CellBlock.getCellBlock(span.getStart() - delRows, 0, span.getEnd() - delRows, 65535));
                    delRows += span.getEnd() - span.getStart() + 1;
                    rg.addAll(r);
                }
                AlgorithmUtil.delAction(rg, true, sheet);
            }
        }
        if (cols != null && cols.length >= 2) {
            SortedSpanArray colSpans = new SortedSpanArray();
            for (int j = 0; j < cols.length - 1; j += 2) {
                colSpans.restruct(cols[j], cols[j + 1]);
            }
            Span span = (Span)colSpans.get(0);
            if (span != null) {
                rg = sheet.getRange(CellBlock.getCellBlock(0, span.getStart(), 1048575, span.getEnd()));
                int delCols = span.getEnd() - span.getStart() + 1;
                len = colSpans.size();
                for (i = 1; i < len; ++i) {
                    span = (Span)colSpans.get(i);
                    r = sheet.getRange(CellBlock.getCellBlock(0, span.getStart() - delCols, 1048575, span.getEnd() - delCols));
                    delCols += span.getEnd() - span.getStart() + 1;
                    rg.addAll(r);
                }
                AlgorithmUtil.delAction(rg, false, sheet);
            }
        }
    }

    public static void delHideRowsAndColsWithOffset(Sheet srcSheet, Sheet sheet, int offsetRow, int offsetColumn, int[] rows, int[] cols) {
        Range r;
        int i;
        int len;
        int end;
        if (srcSheet == null || sheet == null) {
            return;
        }
        int maxRow = sheet.getMaxRowIndex(true);
        int maxCol = sheet.getMaxColIndex(true);
        maxRow += offsetRow;
        maxCol += offsetColumn;
        if (rows != null && rows.length >= 2) {
            Span span;
            SortedSpanArray rowSpans = new SortedSpanArray();
            for (int i2 = 0; i2 < rows.length - 1; i2 += 2) {
                int start = rows[i2];
                end = rows[i2 + 1];
                if (start < offsetRow && end < offsetRow) continue;
                if (end > maxRow) break;
                if (end > maxRow) {
                    end = maxRow;
                }
                if (rows[i2] < offsetRow) {
                    start = 0;
                }
                rowSpans.restruct(start - offsetRow, end - offsetRow);
            }
            if ((span = (Span)rowSpans.get(0)) != null) {
                Range rg = sheet.getRange(CellBlock.getCellBlock(span.getStart(), 0, span.getEnd(), 65535));
                int delRows = span.getEnd() - span.getStart() + 1;
                len = rowSpans.size();
                for (i = 1; i < len; ++i) {
                    span = (Span)rowSpans.get(i);
                    r = sheet.getRange(CellBlock.getCellBlock(span.getStart() - delRows, 0, span.getEnd() - delRows, 65535));
                    delRows += span.getEnd() - span.getStart() + 1;
                    rg.addAll(r);
                }
                AlgorithmUtil.delAction(rg, true, sheet);
            }
        }
        if (cols != null && cols.length >= 2) {
            Span span;
            SortedSpanArray colSpans = new SortedSpanArray();
            for (int j = 0; j < cols.length - 1; j += 2) {
                int start = cols[j];
                end = cols[j + 1];
                if (start < offsetColumn && end < offsetColumn) continue;
                if (start > maxCol) break;
                if (end > maxCol) {
                    end = maxCol;
                }
                if (start < offsetColumn) {
                    start = 0;
                }
                colSpans.restruct(start - offsetColumn, end - offsetColumn);
            }
            if ((span = (Span)colSpans.get(0)) != null) {
                Range rg = sheet.getRange(CellBlock.getCellBlock(0, span.getStart(), 1048575, span.getEnd()));
                int delCols = span.getEnd() - span.getStart() + 1;
                len = colSpans.size();
                for (i = 1; i < len; ++i) {
                    span = (Span)colSpans.get(i);
                    r = sheet.getRange(CellBlock.getCellBlock(0, span.getStart() - delCols, 1048575, span.getEnd() - delCols));
                    delCols += span.getEnd() - span.getStart() + 1;
                    rg.addAll(r);
                }
                AlgorithmUtil.delAction(rg, false, sheet);
            }
        }
    }

    public static void delAllHideRowsAndCols(Sheet dstSheet, Sheet srcSheet, int offsetRow, int offsetCol) {
        IntArray hidedRows = new IntArray();
        SortedAttributeSpanArray sasa = srcSheet.getRowSpans();
        int end = sasa.size();
        for (int i = 0; i < end; ++i) {
            SortedAttributeSpanArray.AttributeSpan span = sasa.getAttributeSpan(i);
            if (span == null || span.isVisible()) continue;
            hidedRows.add(span.getStart());
            hidedRows.add(span.getEnd());
        }
        IntArray hidedCols = new IntArray();
        sasa = srcSheet.getColSpans();
        int end2 = sasa.size();
        for (int i = 0; i < end2; ++i) {
            SortedAttributeSpanArray.AttributeSpan span = sasa.getAttributeSpan(i);
            if (span == null || span.isVisible()) continue;
            hidedCols.add(span.getStart());
            hidedCols.add(span.getEnd());
        }
        AlgorithmUtil.delHideRowsAndColsWithOffset(srcSheet, dstSheet, offsetRow, offsetCol, hidedRows.isEmpty() ? null : hidedRows.toArray(), hidedCols.isEmpty() ? null : hidedCols.toArray());
    }

    public static void changeValueToDisplayValue(Sheet srcSheet, Sheet dstSheet, int offsetRow, int offsetCol) {
        if (dstSheet == null || srcSheet == null) {
            return;
        }
        Sheet.ICellsIterator iterator = dstSheet.getCellsIterator(0, 0, dstSheet.getMaxRowIndex(true), dstSheet.getMaxColIndex(true), false, true);
        while (iterator.hasNext()) {
            SortedExtPropFormulasArray formulas;
            ExtProps props;
            Cell dstCll = iterator.next();
            Cell srcCll = srcSheet.getCell(dstCll.getRow() + offsetRow, dstCll.getCol() + offsetCol, false);
            if (srcCll == null || (props = srcCll.getExtProps(false)) == null || (formulas = props.getFormulas(false)) == null || formulas.get(ExtConst.FORMULA_DISP_VALUE) == null) continue;
            dstCll.setValue(new Variant(srcCll.getText(), 11));
        }
    }

    private static void delAction(Range rg, boolean isRow, Sheet sheet) {
        int i;
        int size;
        sheet.setEnableCalculation(false);
        EmbedhLayer layer = sheet.getEmbedments(false);
        if (layer != null) {
            size = layer.size();
            for (i = 0; i < size; ++i) {
                EmbedObject eo = layer.getEmbed(i);
                if (!(eo instanceof FlashChart)) continue;
                ((FlashChart)eo).getModel().getXml();
            }
        }
        size = rg.size();
        for (i = 0; i < size; ++i) {
            int k;
            Rectangle rect;
            EmbedObject eo;
            int j;
            int size1;
            CellBlock cllBlock = rg.getBlock(i);
            if (isRow) {
                SortedRowArray rows = sheet.getRows();
                rows.remove(cllBlock.getRow(), cllBlock.getRow2(), true, false);
                SortedAttributeSpanArray rowSpans = sheet.getRowSpans();
                rowSpans.deleteSpace(cllBlock.getRow(), cllBlock.getRow2(), false);
                layer = sheet.getEmbedments(false);
                if (layer != null) {
                    size1 = layer.size();
                    for (j = 0; j < size1; ++j) {
                        eo = layer.getEmbed(j);
                        rect = eo.getBounds();
                        for (k = cllBlock.getRow(); k <= cllBlock.getRow2(); ++k) {
                            rect.y += SheetBaseMath.getRowHeight(sheet, k);
                        }
                        eo.setBounds(rect);
                    }
                }
            } else {
                Sheet.RowsIterator ri = sheet.getRowsIterator(0, 1048575, false);
                if (ri.hasNext()) {
                    while (ri.hasNext()) {
                        Row rowObj = ri.next();
                        rowObj.remove(cllBlock.getCol(), cllBlock.getCol2(), false, false);
                    }
                }
                SortedColumnArray cols = sheet.getCols();
                cols.remove(cllBlock.getCol(), cllBlock.getCol2(), true, false);
                layer = sheet.getEmbedments(false);
                if (layer != null) {
                    size1 = layer.size();
                    for (j = 0; j < size1; ++j) {
                        eo = layer.getEmbed(j);
                        rect = eo.getBounds();
                        for (k = cllBlock.getCol(); k <= cllBlock.getCol2(); ++k) {
                            rect.y += SheetBaseMath.getColWidth(sheet, k);
                        }
                        eo.setBounds(rect);
                    }
                }
                SortedAttributeSpanArray colSpans = sheet.getColSpans();
                colSpans.deleteSpace(cllBlock.getCol(), cllBlock.getCol2(), false);
            }
            MergeBlocks merger = sheet.getMerger(false);
            if (merger != null) {
                merger.insdel(cllBlock, false, isRow);
            }
            sheet.getBorders().insdel(cllBlock, false, isRow, false);
        }
    }

    public static void calCharts(Sheet sheet) {
        EmbedhLayer layer = sheet.getEmbedments(false);
        if (null != layer) {
            int size = layer.size();
            for (int i = 0; i < size; ++i) {
                EmbedObject eo = layer.getEmbed(i);
                if (!(eo instanceof Chart)) continue;
                ChartModel model = ((Chart)eo).getModel();
                ChartDataNode node = model.getDataNode();
                node.setDirty(true);
                node.getData();
                node.setNeedRecalc(false);
                node.setDirty(false);
                model.refreshChartData(model.getChartType());
            }
        }
    }
}

