/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.jcr;

import com.kingdee.bos.ctrl.common.util.StringUtil;

public class PathUtil {
    public static final String SPLIT_TEXT = "/";
    public static final char SPLIT_CHAR = '/';
    public static final char[] INVALID_CHARS = "\\:*?\"'<>[]|".toCharArray();
    public static final String SPLIT_NSP_COLON = "/ctrl:";

    public static boolean isNameValid(String name) {
        for (int i = 0; i < name.length(); ++i) {
            char aChar = name.charAt(i);
            if (aChar >= 'A' && aChar <= 'Z' || aChar >= 'a' && aChar <= 'z') continue;
            if (i > 0) {
                if (aChar >= '0' && aChar <= '9' || aChar == '_') continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public static boolean isPathValid(String path) {
        if (StringUtil.isEmptyString((String)path)) {
            return false;
        }
        for (int i = 0; i < INVALID_CHARS.length; ++i) {
            if (path.indexOf(INVALID_CHARS[i]) == -1) continue;
            return false;
        }
        return true;
    }

    public static boolean isRelativePath(String path) {
        return !path.startsWith(SPLIT_TEXT);
    }

    public static String tieNamespace(String path) {
        boolean fix = false;
        if (!path.startsWith(SPLIT_TEXT)) {
            path = SPLIT_TEXT + path;
            fix = true;
        }
        path = path.replaceAll(SPLIT_TEXT, SPLIT_NSP_COLON);
        if (fix) {
            return path.substring(1);
        }
        return path;
    }

    public static String cutNamespace(String path) {
        boolean fix = false;
        if (!path.startsWith(SPLIT_TEXT)) {
            path = SPLIT_TEXT + path;
            fix = true;
        }
        path = path.replaceAll(SPLIT_NSP_COLON, SPLIT_TEXT);
        if (fix) {
            return path.substring(1);
        }
        return path;
    }

    public static String getParentPath(String path) {
        int i = path.lastIndexOf(SPLIT_TEXT);
        if (i > 1) {
            return path.substring(0, i);
        }
        return SPLIT_TEXT;
    }

    public static String makeChildPath(String parent, String child) {
        if (!PathUtil.isRelativePath(child)) {
            child = child.substring(1);
        }
        String middle = parent.charAt(parent.length() - 1) == '/' ? "" : SPLIT_TEXT;
        return new StringBuffer(parent + middle + child).toString();
    }

    public static final String makeSiblingPath(String path, String sibling) {
        return PathUtil.makeChildPath(PathUtil.getParentPath(path), sibling);
    }

    public static String[] splitPath(String path) {
        if (path.startsWith(SPLIT_TEXT)) {
            path = path.substring(1);
        }
        return path.split(SPLIT_TEXT);
    }
}

