/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.jcr;

import com.kingdee.bos.ctrl.common.util.StreamUtil;
import com.kingdee.bos.ctrl.jcr.Explorer;
import com.kingdee.bos.ctrl.jcr.NamespaceUtil;
import com.kingdee.bos.ctrl.jcr.SMResource;
import com.kingdee.bos.ctrl.jcr.exception.SMException;
import com.kingdee.bos.ctrl.jcr.exception.SMRuntimeException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.jcr.Node;
import javax.jcr.RepositoryException;

public class SMFile
extends SMResource {
    protected SMFile(Explorer explorer, Node node) {
        super(explorer, node);
    }

    @Override
    public boolean isFile() {
        return true;
    }

    public byte[] read() throws SMException {
        try {
            return StreamUtil.readInputStream((InputStream)this.getContent());
        }
        catch (IOException e) {
            throw SMException.makeException(e);
        }
    }

    public void write(byte[] content) throws SMException {
        ByteArrayInputStream bais = new ByteArrayInputStream(content);
        this.setContent(bais);
    }

    public InputStream getContent() throws SMException {
        try {
            return this.getNode().getProperty(NamespaceUtil.Content).getStream();
        }
        catch (RepositoryException e) {
            throw SMException.makeException(e);
        }
    }

    public void setContent(InputStream inputStream) throws SMException {
        if (inputStream == null) {
            throw new SMRuntimeException("Content must not be null.");
        }
        try {
            this.getNode().getProperty(NamespaceUtil.Content).setValue(inputStream);
        }
        catch (RepositoryException e) {
            throw SMException.makeException(e);
        }
        this.updateLastModified();
    }
}

