/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.jcr.search;

import com.kingdee.bos.ctrl.jcr.PathUtil;
import com.kingdee.bos.ctrl.jcr.search.PropertyInfo;

public class ResourceInfo {
    public static final int SEARCH_FOLDER = 1;
    public static final int SEARCH_FILE = 16;
    public static final int SEARCH_ALL = 17;
    private String _pathPattern;
    private PropertyInfo[] _propertyInfos;
    private int _searchResType = 17;

    public ResourceInfo(String pathPattern) {
        this(pathPattern, null);
    }

    public ResourceInfo(String pathPattern, PropertyInfo propertyInfo) {
        String string = this._pathPattern = pathPattern == null ? "*" : PathUtil.tieNamespace(pathPattern);
        if (propertyInfo != null) {
            this._propertyInfos = new PropertyInfo[]{propertyInfo};
        }
    }

    public void setPropertyInfos(PropertyInfo[] infos) {
        this._propertyInfos = infos;
    }

    public boolean isSearchFile() {
        return (this._searchResType & 0x10) == 16;
    }

    public boolean isSearchFolder() {
        return (this._searchResType & 1) == 1;
    }

    public void setSearchResType(int searchResType) {
        this._searchResType = searchResType;
    }

    public String toString() {
        boolean isOnlySearchFile = this.isSearchFile() && !this.isSearchFolder();
        boolean isOnlySearchFolder = !this.isSearchFile() && this.isSearchFolder();
        StringBuffer sb = new StringBuffer();
        if (this._propertyInfos != null || isOnlySearchFile || isOnlySearchFolder) {
            sb.append("[");
            if (this._propertyInfos != null) {
                for (int i = 0; i < this._propertyInfos.length; ++i) {
                    if (i > 0) {
                        sb.append(" and ");
                    }
                    sb.append(this._propertyInfos[i].toString());
                }
            }
            if (isOnlySearchFile || isOnlySearchFolder) {
                if (sb.length() > 0) {
                    sb.append(" and ");
                }
                if (isOnlySearchFolder) {
                    sb.append("not(");
                }
                sb.append("@");
                sb.append("content");
                if (isOnlySearchFolder) {
                    sb.append(")");
                }
            }
            sb.append("]");
        }
        sb.insert(0, this._pathPattern);
        return sb.toString();
    }
}

