/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.lucene.analysis.standard;

import com.kingdee.bos.ctrl.lucene.analysis.Token;
import com.kingdee.bos.ctrl.lucene.analysis.TokenFilter;
import com.kingdee.bos.ctrl.lucene.analysis.TokenStream;
import com.kingdee.bos.ctrl.lucene.analysis.standard.StandardTokenizerConstants;
import java.io.IOException;

public final class StandardFilter
extends TokenFilter
implements StandardTokenizerConstants {
    private static final String APOSTROPHE_TYPE = tokenImage[2];
    private static final String ACRONYM_TYPE = tokenImage[3];

    public StandardFilter(TokenStream in) {
        super(in);
    }

    @Override
    public final Token next() throws IOException {
        Token t = this.input.next();
        if (t == null) {
            return null;
        }
        String text = t.termText();
        String type = t.type();
        if (type == APOSTROPHE_TYPE && (text.endsWith("'s") || text.endsWith("'S"))) {
            return new Token(text.substring(0, text.length() - 2), t.startOffset(), t.endOffset(), type);
        }
        if (type == ACRONYM_TYPE) {
            StringBuffer trimmed = new StringBuffer();
            for (int i = 0; i < text.length(); ++i) {
                char c = text.charAt(i);
                if (c == '.') continue;
                trimmed.append(c);
            }
            return new Token(trimmed.toString(), t.startOffset(), t.endOffset(), type);
        }
        return t;
    }
}

