/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.lucene.search;

import com.kingdee.bos.ctrl.lucene.index.IndexReader;
import com.kingdee.bos.ctrl.lucene.search.BooleanClause;
import com.kingdee.bos.ctrl.lucene.search.BooleanScorer2;
import com.kingdee.bos.ctrl.lucene.search.ComplexExplanation;
import com.kingdee.bos.ctrl.lucene.search.Explanation;
import com.kingdee.bos.ctrl.lucene.search.Query;
import com.kingdee.bos.ctrl.lucene.search.Scorer;
import com.kingdee.bos.ctrl.lucene.search.Searcher;
import com.kingdee.bos.ctrl.lucene.search.Similarity;
import com.kingdee.bos.ctrl.lucene.search.SimilarityDelegator;
import com.kingdee.bos.ctrl.lucene.search.Weight;
import com.kingdee.bos.ctrl.lucene.util.ToStringUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Vector;

public class BooleanQuery
extends Query {
    private static int maxClauseCount = 1024;
    private ArrayList clauses = new ArrayList();
    private boolean disableCoord;
    protected int minNrShouldMatch = 0;
    private static boolean allowDocsOutOfOrder = false;

    public static int getMaxClauseCount() {
        return maxClauseCount;
    }

    public static void setMaxClauseCount(int maxClauseCount) {
        if (maxClauseCount < 1) {
            throw new IllegalArgumentException("maxClauseCount must be >= 1");
        }
        BooleanQuery.maxClauseCount = maxClauseCount;
    }

    public BooleanQuery() {
    }

    public BooleanQuery(boolean disableCoord) {
        this.disableCoord = disableCoord;
    }

    public boolean isCoordDisabled() {
        return this.disableCoord;
    }

    @Override
    public Similarity getSimilarity(Searcher searcher) {
        Similarity result = super.getSimilarity(searcher);
        if (this.disableCoord) {
            result = new SimilarityDelegator(result){

                @Override
                public float coord(int overlap, int maxOverlap) {
                    return 1.0f;
                }
            };
        }
        return result;
    }

    public void setMinimumNumberShouldMatch(int min) {
        this.minNrShouldMatch = min;
    }

    public int getMinimumNumberShouldMatch() {
        return this.minNrShouldMatch;
    }

    public void add(Query query, BooleanClause.Occur occur) {
        this.add(new BooleanClause(query, occur));
    }

    public void add(BooleanClause clause) {
        if (this.clauses.size() >= maxClauseCount) {
            throw new TooManyClauses();
        }
        this.clauses.add(clause);
    }

    public BooleanClause[] getClauses() {
        return this.clauses.toArray(new BooleanClause[this.clauses.size()]);
    }

    public List clauses() {
        return this.clauses;
    }

    public static void setAllowDocsOutOfOrder(boolean allow) {
        allowDocsOutOfOrder = allow;
    }

    public static boolean getAllowDocsOutOfOrder() {
        return allowDocsOutOfOrder;
    }

    public static void setUseScorer14(boolean use14) {
        BooleanQuery.setAllowDocsOutOfOrder(use14);
    }

    public static boolean getUseScorer14() {
        return BooleanQuery.getAllowDocsOutOfOrder();
    }

    @Override
    protected Weight createWeight(Searcher searcher) throws IOException {
        return new BooleanWeight(searcher);
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        BooleanClause c;
        if (this.clauses.size() == 1 && !(c = (BooleanClause)this.clauses.get(0)).isProhibited()) {
            Query query = c.getQuery().rewrite(reader);
            if (this.getBoost() != 1.0f) {
                if (query == c.getQuery()) {
                    query = (Query)query.clone();
                }
                query.setBoost(this.getBoost() * query.getBoost());
            }
            return query;
        }
        BooleanQuery clone = null;
        for (int i = 0; i < this.clauses.size(); ++i) {
            BooleanClause c2 = (BooleanClause)this.clauses.get(i);
            Query query = c2.getQuery().rewrite(reader);
            if (query == c2.getQuery()) continue;
            if (clone == null) {
                clone = (BooleanQuery)this.clone();
            }
            clone.clauses.set(i, new BooleanClause(query, c2.getOccur()));
        }
        if (clone != null) {
            return clone;
        }
        return this;
    }

    @Override
    public void extractTerms(Set terms) {
        for (BooleanClause clause : this.clauses) {
            clause.getQuery().extractTerms(terms);
        }
    }

    @Override
    public Object clone() {
        BooleanQuery clone = (BooleanQuery)super.clone();
        clone.clauses = (ArrayList)this.clauses.clone();
        return clone;
    }

    @Override
    public String toString(String field) {
        boolean needParens;
        StringBuffer buffer = new StringBuffer();
        boolean bl = needParens = (double)this.getBoost() != 1.0 || this.getMinimumNumberShouldMatch() > 0;
        if (needParens) {
            buffer.append("(");
        }
        for (int i = 0; i < this.clauses.size(); ++i) {
            BooleanClause c = (BooleanClause)this.clauses.get(i);
            if (c.isProhibited()) {
                buffer.append("-");
            } else if (c.isRequired()) {
                buffer.append("+");
            }
            Query subQuery = c.getQuery();
            if (subQuery instanceof BooleanQuery) {
                buffer.append("(");
                buffer.append(c.getQuery().toString(field));
                buffer.append(")");
            } else {
                buffer.append(c.getQuery().toString(field));
            }
            if (i == this.clauses.size() - 1) continue;
            buffer.append(" ");
        }
        if (needParens) {
            buffer.append(")");
        }
        if (this.getMinimumNumberShouldMatch() > 0) {
            buffer.append('~');
            buffer.append(this.getMinimumNumberShouldMatch());
        }
        if (this.getBoost() != 1.0f) {
            buffer.append(ToStringUtils.boost(this.getBoost()));
        }
        return buffer.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof BooleanQuery)) {
            return false;
        }
        BooleanQuery other = (BooleanQuery)o;
        return this.getBoost() == other.getBoost() && this.clauses.equals(other.clauses) && this.getMinimumNumberShouldMatch() == other.getMinimumNumberShouldMatch();
    }

    public int hashCode() {
        return Float.floatToIntBits(this.getBoost()) ^ this.clauses.hashCode() + this.getMinimumNumberShouldMatch();
    }

    private class BooleanWeight
    implements Weight {
        protected Similarity similarity;
        protected Vector weights = new Vector();

        public BooleanWeight(Searcher searcher) throws IOException {
            this.similarity = BooleanQuery.this.getSimilarity(searcher);
            for (int i = 0; i < BooleanQuery.this.clauses.size(); ++i) {
                BooleanClause c = (BooleanClause)BooleanQuery.this.clauses.get(i);
                this.weights.add(c.getQuery().createWeight(searcher));
            }
        }

        @Override
        public Query getQuery() {
            return BooleanQuery.this;
        }

        @Override
        public float getValue() {
            return BooleanQuery.this.getBoost();
        }

        @Override
        public float sumOfSquaredWeights() throws IOException {
            float sum = 0.0f;
            for (int i = 0; i < this.weights.size(); ++i) {
                BooleanClause c = (BooleanClause)BooleanQuery.this.clauses.get(i);
                Weight w = (Weight)this.weights.elementAt(i);
                float s = w.sumOfSquaredWeights();
                if (c.isProhibited()) continue;
                sum += s;
            }
            return sum *= BooleanQuery.this.getBoost() * BooleanQuery.this.getBoost();
        }

        @Override
        public void normalize(float norm) {
            norm *= BooleanQuery.this.getBoost();
            for (int i = 0; i < this.weights.size(); ++i) {
                BooleanClause c = (BooleanClause)BooleanQuery.this.clauses.get(i);
                Weight w = (Weight)this.weights.elementAt(i);
                w.normalize(norm);
            }
        }

        @Override
        public Scorer scorer(IndexReader reader) throws IOException {
            BooleanScorer2 result = new BooleanScorer2(this.similarity, BooleanQuery.this.minNrShouldMatch, allowDocsOutOfOrder);
            for (int i = 0; i < this.weights.size(); ++i) {
                BooleanClause c = (BooleanClause)BooleanQuery.this.clauses.get(i);
                Weight w = (Weight)this.weights.elementAt(i);
                Scorer subScorer = w.scorer(reader);
                if (subScorer != null) {
                    result.add(subScorer, c.isRequired(), c.isProhibited());
                    continue;
                }
                if (!c.isRequired()) continue;
                return null;
            }
            return result;
        }

        @Override
        public Explanation explain(IndexReader reader, int doc) throws IOException {
            int minShouldMatch = BooleanQuery.this.getMinimumNumberShouldMatch();
            ComplexExplanation sumExpl = new ComplexExplanation();
            sumExpl.setDescription("sum of:");
            int coord = 0;
            int maxCoord = 0;
            float sum = 0.0f;
            boolean fail = false;
            int shouldMatchCount = 0;
            for (int i = 0; i < this.weights.size(); ++i) {
                Explanation r;
                BooleanClause c = (BooleanClause)BooleanQuery.this.clauses.get(i);
                Weight w = (Weight)this.weights.elementAt(i);
                Explanation e = w.explain(reader, doc);
                if (!c.isProhibited()) {
                    ++maxCoord;
                }
                if (e.isMatch()) {
                    if (!c.isProhibited()) {
                        sumExpl.addDetail(e);
                        sum += e.getValue();
                        ++coord;
                    } else {
                        r = new Explanation(0.0f, "match on prohibited clause (" + c.getQuery().toString() + ")");
                        r.addDetail(e);
                        sumExpl.addDetail(r);
                        fail = true;
                    }
                    if (!c.getOccur().equals(BooleanClause.Occur.SHOULD)) continue;
                    ++shouldMatchCount;
                    continue;
                }
                if (!c.isRequired()) continue;
                r = new Explanation(0.0f, "no match on required clause (" + c.getQuery().toString() + ")");
                r.addDetail(e);
                sumExpl.addDetail(r);
                fail = true;
            }
            if (fail) {
                sumExpl.setMatch(Boolean.FALSE);
                sumExpl.setValue(0.0f);
                sumExpl.setDescription("Failure to meet condition(s) of required/prohibited clause(s)");
                return sumExpl;
            }
            if (shouldMatchCount < minShouldMatch) {
                sumExpl.setMatch(Boolean.FALSE);
                sumExpl.setValue(0.0f);
                sumExpl.setDescription("Failure to match minimum number of optional clauses: " + minShouldMatch);
                return sumExpl;
            }
            sumExpl.setMatch(0 < coord ? Boolean.TRUE : Boolean.FALSE);
            sumExpl.setValue(sum);
            float coordFactor = this.similarity.coord(coord, maxCoord);
            if (coordFactor == 1.0f) {
                return sumExpl;
            }
            ComplexExplanation result = new ComplexExplanation(sumExpl.isMatch(), sum * coordFactor, "product of:");
            result.addDetail(sumExpl);
            result.addDetail(new Explanation(coordFactor, "coord(" + coord + "/" + maxCoord + ")"));
            return result;
        }
    }

    public static class TooManyClauses
    extends RuntimeException {
        @Override
        public String getMessage() {
            return "maxClauseCount is set to " + maxClauseCount;
        }
    }
}

