/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.lucene.search;

import com.kingdee.bos.ctrl.lucene.index.Term;
import com.kingdee.bos.ctrl.lucene.index.TermEnum;
import java.io.IOException;

public abstract class FilteredTermEnum
extends TermEnum {
    private Term currentTerm = null;
    private TermEnum actualEnum = null;

    protected abstract boolean termCompare(Term var1);

    public abstract float difference();

    protected abstract boolean endEnum();

    protected void setEnum(TermEnum actualEnum) throws IOException {
        this.actualEnum = actualEnum;
        Term term = actualEnum.term();
        if (term != null && this.termCompare(term)) {
            this.currentTerm = term;
        } else {
            this.next();
        }
    }

    @Override
    public int docFreq() {
        if (this.actualEnum == null) {
            return -1;
        }
        return this.actualEnum.docFreq();
    }

    @Override
    public boolean next() throws IOException {
        if (this.actualEnum == null) {
            return false;
        }
        this.currentTerm = null;
        while (this.currentTerm == null) {
            if (this.endEnum()) {
                return false;
            }
            if (this.actualEnum.next()) {
                Term term = this.actualEnum.term();
                if (!this.termCompare(term)) continue;
                this.currentTerm = term;
                return true;
            }
            return false;
        }
        this.currentTerm = null;
        return false;
    }

    @Override
    public Term term() {
        return this.currentTerm;
    }

    @Override
    public void close() throws IOException {
        this.actualEnum.close();
        this.currentTerm = null;
        this.actualEnum = null;
    }
}

