/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.lucene.search;

import com.kingdee.bos.ctrl.lucene.search.FieldDocSortedHitQueue;
import com.kingdee.bos.ctrl.lucene.search.Filter;
import com.kingdee.bos.ctrl.lucene.search.HitQueue;
import com.kingdee.bos.ctrl.lucene.search.ScoreDoc;
import com.kingdee.bos.ctrl.lucene.search.Searchable;
import com.kingdee.bos.ctrl.lucene.search.Sort;
import com.kingdee.bos.ctrl.lucene.search.TopDocs;
import com.kingdee.bos.ctrl.lucene.search.TopFieldDocs;
import com.kingdee.bos.ctrl.lucene.search.Weight;
import com.kingdee.bos.ctrl.lucene.util.PriorityQueue;
import java.io.IOException;

class MultiSearcherThread
extends Thread {
    private Searchable searchable;
    private Weight weight;
    private Filter filter;
    private int nDocs;
    private TopDocs docs;
    private int i;
    private PriorityQueue hq;
    private int[] starts;
    private IOException ioe;
    private Sort sort;

    public MultiSearcherThread(Searchable searchable, Weight weight, Filter filter, int nDocs, HitQueue hq, int i, int[] starts, String name) {
        super(name);
        this.searchable = searchable;
        this.weight = weight;
        this.filter = filter;
        this.nDocs = nDocs;
        this.hq = hq;
        this.i = i;
        this.starts = starts;
    }

    public MultiSearcherThread(Searchable searchable, Weight weight, Filter filter, int nDocs, FieldDocSortedHitQueue hq, Sort sort, int i, int[] starts, String name) {
        super(name);
        this.searchable = searchable;
        this.weight = weight;
        this.filter = filter;
        this.nDocs = nDocs;
        this.hq = hq;
        this.i = i;
        this.starts = starts;
        this.sort = sort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.docs = this.sort == null ? this.searchable.search(this.weight, this.filter, this.nDocs) : this.searchable.search(this.weight, this.filter, this.nDocs, this.sort);
        }
        catch (IOException ioe) {
            this.ioe = ioe;
        }
        if (this.ioe == null) {
            if (this.sort != null) {
                ((FieldDocSortedHitQueue)this.hq).setFields(((TopFieldDocs)this.docs).fields);
            }
            ScoreDoc[] scoreDocs = this.docs.scoreDocs;
            for (int j = 0; j < scoreDocs.length; ++j) {
                ScoreDoc scoreDoc = scoreDocs[j];
                scoreDoc.doc += this.starts[this.i];
                PriorityQueue priorityQueue = this.hq;
                synchronized (priorityQueue) {
                    if (!this.hq.insert(scoreDoc)) {
                        break;
                    }
                    continue;
                }
            }
        }
    }

    public int hits() {
        return this.docs.totalHits;
    }

    public float getMaxScore() {
        return this.docs.getMaxScore();
    }

    public IOException getIOException() {
        return this.ioe;
    }
}

