/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.lucene.search;

import com.kingdee.bos.ctrl.lucene.index.IndexReader;
import com.kingdee.bos.ctrl.lucene.search.FieldDoc;
import com.kingdee.bos.ctrl.lucene.search.FieldSortedHitQueue;
import com.kingdee.bos.ctrl.lucene.search.ScoreDoc;
import com.kingdee.bos.ctrl.lucene.search.Sort;
import com.kingdee.bos.ctrl.lucene.search.TopDocCollector;
import com.kingdee.bos.ctrl.lucene.search.TopDocs;
import com.kingdee.bos.ctrl.lucene.search.TopFieldDocs;
import java.io.IOException;

public class TopFieldDocCollector
extends TopDocCollector {
    public TopFieldDocCollector(IndexReader reader, Sort sort, int numHits) throws IOException {
        super(numHits, new FieldSortedHitQueue(reader, sort.fields, numHits));
    }

    @Override
    public void collect(int doc, float score) {
        if (score > 0.0f) {
            ++this.totalHits;
            this.hq.insert(new FieldDoc(doc, score));
        }
    }

    @Override
    public TopDocs topDocs() {
        FieldSortedHitQueue fshq = (FieldSortedHitQueue)this.hq;
        ScoreDoc[] scoreDocs = new ScoreDoc[fshq.size()];
        for (int i = fshq.size() - 1; i >= 0; --i) {
            scoreDocs[i] = fshq.fillFields((FieldDoc)fshq.pop());
        }
        return new TopFieldDocs(this.totalHits, scoreDocs, fshq.getFields(), fshq.getMaxScore());
    }
}

