/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.lucene.search.payloads;

import com.kingdee.bos.ctrl.lucene.index.IndexReader;
import com.kingdee.bos.ctrl.lucene.index.Term;
import com.kingdee.bos.ctrl.lucene.index.TermPositions;
import com.kingdee.bos.ctrl.lucene.search.Explanation;
import com.kingdee.bos.ctrl.lucene.search.Scorer;
import com.kingdee.bos.ctrl.lucene.search.Searcher;
import com.kingdee.bos.ctrl.lucene.search.Similarity;
import com.kingdee.bos.ctrl.lucene.search.Weight;
import com.kingdee.bos.ctrl.lucene.search.spans.SpanScorer;
import com.kingdee.bos.ctrl.lucene.search.spans.SpanTermQuery;
import com.kingdee.bos.ctrl.lucene.search.spans.SpanWeight;
import com.kingdee.bos.ctrl.lucene.search.spans.TermSpans;
import java.io.IOException;

public class BoostingTermQuery
extends SpanTermQuery {
    public BoostingTermQuery(Term term) {
        super(term);
    }

    @Override
    protected Weight createWeight(Searcher searcher) throws IOException {
        return new BoostingTermWeight(this, searcher);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof BoostingTermQuery)) {
            return false;
        }
        BoostingTermQuery other = (BoostingTermQuery)o;
        return this.getBoost() == other.getBoost() && this.term.equals(other.term);
    }

    protected class BoostingTermWeight
    extends SpanWeight
    implements Weight {
        public BoostingTermWeight(BoostingTermQuery query, Searcher searcher) throws IOException {
            super(query, searcher);
        }

        @Override
        public Scorer scorer(IndexReader reader) throws IOException {
            return new BoostingSpanScorer((TermSpans)this.query.getSpans(reader), this, this.similarity, reader.norms(this.query.getField()));
        }

        class BoostingSpanScorer
        extends SpanScorer {
            byte[] payload;
            private TermPositions positions;
            protected float payloadScore;
            private int payloadsSeen;

            public BoostingSpanScorer(TermSpans spans, Weight weight, Similarity similarity, byte[] norms) throws IOException {
                super(spans, weight, similarity, norms);
                this.payload = new byte[256];
                this.positions = spans.getPositions();
            }

            @Override
            protected boolean setFreqCurrentDoc() throws IOException {
                if (!this.more) {
                    return false;
                }
                this.doc = this.spans.doc();
                this.freq = 0.0f;
                this.payloadScore = 0.0f;
                this.payloadsSeen = 0;
                Similarity similarity1 = this.getSimilarity();
                while (this.more && this.doc == this.spans.doc()) {
                    int matchLength = this.spans.end() - this.spans.start();
                    this.freq += similarity1.sloppyFreq(matchLength);
                    this.processPayload(similarity1);
                    this.more = this.spans.next();
                }
                return this.more || this.freq != 0.0f;
            }

            protected void processPayload(Similarity similarity) throws IOException {
                if (this.positions.isPayloadAvailable()) {
                    this.payload = this.positions.getPayload(this.payload, 0);
                    this.payloadScore += similarity.scorePayload(this.payload, 0, this.positions.getPayloadLength());
                    ++this.payloadsSeen;
                }
            }

            @Override
            public float score() throws IOException {
                return super.score() * (this.payloadsSeen > 0 ? this.payloadScore / (float)this.payloadsSeen : 1.0f);
            }

            @Override
            public Explanation explain(int doc) throws IOException {
                Explanation result = new Explanation();
                Explanation nonPayloadExpl = super.explain(doc);
                result.addDetail(nonPayloadExpl);
                Explanation payloadBoost = new Explanation();
                result.addDetail(payloadBoost);
                float avgPayloadScore = this.payloadScore / (float)this.payloadsSeen;
                payloadBoost.setValue(avgPayloadScore);
                payloadBoost.setDescription("scorePayload(...)");
                result.setValue(nonPayloadExpl.getValue() * avgPayloadScore);
                result.setDescription("btq, product of:");
                return result;
            }
        }
    }
}

