/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.commons.repository;

import com.kingdee.bos.ctrl.common.util.CommonSLF4JLogger;
import javax.jcr.Credentials;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.commons.AbstractRepository;
import org.apache.jackrabbit.commons.repository.RepositoryFactory;
import org.slf4j.Logger;

public class ProxyRepository
extends AbstractRepository {
    private static final Logger logger = CommonSLF4JLogger.getLogger(ProxyRepository.class);
    private final RepositoryFactory factory;

    public ProxyRepository(RepositoryFactory factory) {
        this.factory = factory;
    }

    public String[] getDescriptorKeys() {
        try {
            return this.factory.getRepository().getDescriptorKeys();
        }
        catch (RepositoryException e) {
            logger.warn("Unable to access proxied repository", (Throwable)e);
            return new String[0];
        }
    }

    public String getDescriptor(String key) {
        try {
            return this.factory.getRepository().getDescriptor(key);
        }
        catch (RepositoryException e) {
            logger.warn("Unable to access proxied repository", (Throwable)e);
            return null;
        }
    }

    public Session login(Credentials credentials, String workspace) throws RepositoryException {
        return this.factory.getRepository().login(credentials, workspace);
    }
}

