/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.cluster;

import EDU.oswego.cs.dl.util.concurrent.Mutex;
import com.kingdee.bos.ctrl.common.util.CommonSLF4JLogger;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.cluster.AbstractClusterOperation;
import org.apache.jackrabbit.core.cluster.ClusterContext;
import org.apache.jackrabbit.core.cluster.ClusterException;
import org.apache.jackrabbit.core.cluster.ClusterOperation;
import org.apache.jackrabbit.core.cluster.ClusterSession;
import org.apache.jackrabbit.core.cluster.ItemOperation;
import org.apache.jackrabbit.core.cluster.LockEventChannel;
import org.apache.jackrabbit.core.cluster.LockEventListener;
import org.apache.jackrabbit.core.cluster.LockOperation;
import org.apache.jackrabbit.core.cluster.NamespaceEventChannel;
import org.apache.jackrabbit.core.cluster.NamespaceEventListener;
import org.apache.jackrabbit.core.cluster.NodeAddedOperation;
import org.apache.jackrabbit.core.cluster.NodeDeletedOperation;
import org.apache.jackrabbit.core.cluster.NodeModifiedOperation;
import org.apache.jackrabbit.core.cluster.NodeOperation;
import org.apache.jackrabbit.core.cluster.NodeTypeEventChannel;
import org.apache.jackrabbit.core.cluster.NodeTypeEventListener;
import org.apache.jackrabbit.core.cluster.PropertyAddedOperation;
import org.apache.jackrabbit.core.cluster.PropertyDeletedOperation;
import org.apache.jackrabbit.core.cluster.PropertyModifiedOperation;
import org.apache.jackrabbit.core.cluster.PropertyOperation;
import org.apache.jackrabbit.core.cluster.Update;
import org.apache.jackrabbit.core.cluster.UpdateEventChannel;
import org.apache.jackrabbit.core.cluster.UpdateEventListener;
import org.apache.jackrabbit.core.config.ClusterConfig;
import org.apache.jackrabbit.core.config.ConfigurationException;
import org.apache.jackrabbit.core.config.JournalConfig;
import org.apache.jackrabbit.core.journal.FileRevision;
import org.apache.jackrabbit.core.journal.Journal;
import org.apache.jackrabbit.core.journal.JournalException;
import org.apache.jackrabbit.core.journal.Record;
import org.apache.jackrabbit.core.journal.RecordConsumer;
import org.apache.jackrabbit.core.nodetype.InvalidNodeTypeDefException;
import org.apache.jackrabbit.core.nodetype.NodeTypeDef;
import org.apache.jackrabbit.core.observation.EventState;
import org.apache.jackrabbit.core.observation.EventStateCollection;
import org.apache.jackrabbit.core.state.ChangeLog;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.slf4j.Logger;

public class ClusterNode
implements Runnable,
NamespaceEventChannel,
NodeTypeEventChannel,
RecordConsumer {
    public static final String SYSTEM_PROPERTY_NODE_ID = "org.apache.jackrabbit.core.cluster.node_id";
    private static final String REVISION_NAME = "revision";
    private static final String SHORT_PADDING = "0000";
    private static final String PRODUCER_ID = "JR";
    private static final int NONE = 0;
    private static final int STARTED = 1;
    private static final int STOPPED = 2;
    private static final int NTREG_REGISTER = 0;
    private static final int NTREG_REREGISTER = 0x40000000;
    private static final int NTREG_UNREGISTER = Integer.MIN_VALUE;
    private static final int NTREG_MASK = -1073741824;
    private static Logger log = CommonSLF4JLogger.getLogger(ClusterNode.class);
    private ClusterContext clusterContext;
    private String clusterNodeId;
    private long syncDelay;
    private Journal journal;
    private final Mutex syncLock = new Mutex();
    private int status;
    private final Map wspLockListeners = new HashMap();
    private final Map wspUpdateListeners = new HashMap();
    private UpdateEventListener versionUpdateListener;
    private NamespaceEventListener namespaceListener;
    private NodeTypeEventListener nodeTypeListener;
    private FileRevision instanceRevision;
    private String workspace;
    private ChangeLog changeLog;
    private List events;
    private Session lastSession;

    public void init(ClusterContext clusterContext) throws ClusterException {
        this.clusterContext = clusterContext;
        this.init();
    }

    protected void init() throws ClusterException {
        ClusterConfig cc = this.clusterContext.getClusterConfig();
        this.clusterNodeId = this.getClusterNodeId(cc.getId());
        this.syncDelay = cc.getSyncDelay();
        JournalConfig jc = cc.getJournalConfig();
        String revisionName = jc.getParameters().getProperty(REVISION_NAME);
        if (revisionName == null) {
            String msg = "Revision not specified.";
            throw new ClusterException(msg);
        }
        try {
            this.instanceRevision = new FileRevision(new File(revisionName));
            this.journal = (Journal)jc.newInstance();
            this.journal.init(this.clusterNodeId, this.clusterContext.getNamespaceResovler());
            this.journal.register(this);
        }
        catch (ConfigurationException e) {
            throw new ClusterException(e.getMessage(), e.getCause());
        }
        catch (JournalException e) {
            throw new ClusterException(e.getMessage(), e.getCause());
        }
    }

    public synchronized void start() throws ClusterException {
        if (this.status == 0) {
            this.sync();
            Thread t = new Thread((Runnable)this, "ClusterNode-" + this.clusterNodeId);
            t.setDaemon(true);
            t.start();
            this.status = 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            String msg;
            ClusterNode clusterNode = this;
            synchronized (clusterNode) {
                try {
                    this.wait(this.syncDelay);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.status == 2) {
                    return;
                }
            }
            try {
                this.sync();
                continue;
            }
            catch (ClusterException e) {
                msg = "Periodic sync of journal failed: " + e.getMessage();
                log.error(msg);
                continue;
            }
            catch (Exception e) {
                msg = "Unexpected error while syncing of journal: " + e.getMessage();
                log.error(msg, (Throwable)e);
                continue;
            }
            catch (Error e) {
                msg = "Unexpected error while syncing of journal: " + e.getMessage();
                log.error(msg, (Throwable)e);
                throw e;
            }
            break;
        }
    }

    public void sync() throws ClusterException {
        try {
            this.syncLock.acquire();
        }
        catch (InterruptedException e) {
            String msg = "Interrupted while waiting for mutex.";
            throw new ClusterException(msg);
        }
        try {
            this.journal.sync();
        }
        catch (JournalException e) {
            throw new ClusterException(e.getMessage(), e.getCause());
        }
        finally {
            this.syncLock.release();
        }
    }

    public synchronized void stop() {
        if (this.status == 1) {
            this.status = 2;
            this.journal.close();
            this.notifyAll();
        }
    }

    public UpdateEventChannel createUpdateChannel(String workspace) {
        return new WorkspaceUpdateChannel(workspace);
    }

    public LockEventChannel createLockChannel(String workspace) {
        return new WorkspaceLockChannel(workspace);
    }

    private String getClusterNodeId(String id) {
        if (id == null && (id = System.getProperty(SYSTEM_PROPERTY_NODE_ID)) == null) {
            id = ClusterNode.toHexString((short)(Math.random() * 65535.0));
        }
        return id;
    }

    private static String toHexString(short n) {
        String s = Integer.toHexString(n);
        int padlen = SHORT_PADDING.length() - s.length();
        if (padlen < 0) {
            s = s.substring(-padlen);
        } else if (padlen > 0) {
            s = SHORT_PADDING.substring(0, padlen) + s;
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remapped(String oldPrefix, String newPrefix, String uri) {
        if (this.status != 1) {
            log.info("not started: namespace operation ignored.");
            return;
        }
        Record record = null;
        boolean succeeded = false;
        try {
            record = this.journal.getProducer(PRODUCER_ID).append();
            record.writeString(null);
            ClusterNode.write(record, oldPrefix, newPrefix, uri);
            record.writeChar('\u0000');
            record.update();
            this.setRevision(record.getRevision());
            succeeded = true;
        }
        catch (JournalException e) {
            String msg = "Unable to create log entry: " + e.getMessage();
            log.error(msg);
        }
        catch (Throwable e) {
            String msg = "Unexpected error while creating log entry.";
            log.error(msg, e);
        }
        finally {
            if (!succeeded && record != null) {
                record.cancelUpdate();
            }
        }
    }

    @Override
    public void setListener(NamespaceEventListener listener) {
        this.namespaceListener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registered(Collection ntDefs) {
        if (this.status != 1) {
            log.info("not started: nodetype operation ignored.");
            return;
        }
        Record record = null;
        boolean succeeded = false;
        try {
            record = this.journal.getProducer(PRODUCER_ID).append();
            record.writeString(null);
            ClusterNode.write(record, ntDefs, true);
            record.writeChar('\u0000');
            record.update();
            this.setRevision(record.getRevision());
            succeeded = true;
        }
        catch (JournalException e) {
            String msg = "Unable to create log entry: " + e.getMessage();
            log.error(msg);
        }
        catch (Throwable e) {
            String msg = "Unexpected error while creating log entry.";
            log.error(msg, e);
        }
        finally {
            if (!succeeded && record != null) {
                record.cancelUpdate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reregistered(NodeTypeDef ntDef) {
        if (this.status != 1) {
            log.info("not started: nodetype operation ignored.");
            return;
        }
        Record record = null;
        boolean succeeded = false;
        try {
            record = this.journal.getProducer(PRODUCER_ID).append();
            record.writeString(null);
            ClusterNode.write(record, ntDef);
            record.writeChar('\u0000');
            record.update();
            this.setRevision(record.getRevision());
            succeeded = true;
        }
        catch (JournalException e) {
            String msg = "Unable to create log entry: " + e.getMessage();
            log.error(msg);
        }
        catch (Throwable e) {
            String msg = "Unexpected error while creating log entry.";
            log.error(msg, e);
        }
        finally {
            if (!succeeded && record != null) {
                record.cancelUpdate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregistered(Collection qnames) {
        if (this.status != 1) {
            log.info("not started: nodetype operation ignored.");
            return;
        }
        Record record = null;
        boolean succeeded = false;
        try {
            record = this.journal.getProducer(PRODUCER_ID).append();
            record.writeString(null);
            ClusterNode.write(record, qnames, false);
            record.writeChar('\u0000');
            record.update();
            this.setRevision(record.getRevision());
            succeeded = true;
        }
        catch (JournalException e) {
            String msg = "Unable to create log entry: " + e.getMessage();
            log.error(msg);
        }
        catch (Throwable e) {
            String msg = "Unexpected error while creating log entry.";
            log.error(msg, e);
        }
        finally {
            if (!succeeded && record != null) {
                record.cancelUpdate();
            }
        }
    }

    @Override
    public void setListener(NodeTypeEventListener listener) {
        this.nodeTypeListener = listener;
    }

    private void start(String workspace) {
        this.workspace = workspace;
        this.changeLog = new ChangeLog();
        this.events = new ArrayList();
    }

    private void process(ItemOperation operation) {
        operation.apply(this.changeLog);
    }

    private void process(EventState event) {
        this.events.add(event);
    }

    private void process(NodeId nodeId, boolean isDeep, String owner) {
        String msg;
        LockEventListener listener = (LockEventListener)this.wspLockListeners.get(this.workspace);
        if (listener == null) {
            try {
                this.clusterContext.lockEventsReady(this.workspace);
            }
            catch (RepositoryException e) {
                msg = "Unable to make lock listener for workspace " + this.workspace + " online: " + e.getMessage();
                log.warn(msg);
            }
            listener = (LockEventListener)this.wspLockListeners.get(this.workspace);
            if (listener == null) {
                String msg2 = "Lock channel unavailable for workspace: " + this.workspace;
                log.error(msg2);
                return;
            }
        }
        try {
            listener.externalLock(nodeId, isDeep, owner);
        }
        catch (RepositoryException e) {
            msg = "Unable to deliver lock event: " + e.getMessage();
            log.error(msg);
        }
    }

    private void process(NodeId nodeId) {
        String msg;
        LockEventListener listener = (LockEventListener)this.wspLockListeners.get(this.workspace);
        if (listener == null) {
            try {
                this.clusterContext.lockEventsReady(this.workspace);
            }
            catch (RepositoryException e) {
                msg = "Unable to make lock listener for workspace " + this.workspace + " online: " + e.getMessage();
                log.warn(msg);
            }
            listener = (LockEventListener)this.wspLockListeners.get(this.workspace);
            if (listener == null) {
                String msg2 = "Lock channel unavailable for workspace: " + this.workspace;
                log.error(msg2);
                return;
            }
        }
        try {
            listener.externalUnlock(nodeId);
        }
        catch (RepositoryException e) {
            msg = "Unable to deliver lock event: " + e.getMessage();
            log.error(msg);
        }
    }

    private void process(String oldPrefix, String newPrefix, String uri) {
        if (this.namespaceListener == null) {
            String msg = "Namespace listener unavailable.";
            log.error(msg);
            return;
        }
        try {
            this.namespaceListener.externalRemap(oldPrefix, newPrefix, uri);
        }
        catch (RepositoryException e) {
            String msg = "Unable to deliver namespace operation: " + e.getMessage();
            log.error(msg);
        }
    }

    private void process(Collection c, boolean register) {
        if (this.nodeTypeListener == null) {
            String msg = "NodeType listener unavailable.";
            log.error(msg);
            return;
        }
        try {
            if (register) {
                this.nodeTypeListener.externalRegistered(c);
            } else {
                this.nodeTypeListener.externalUnregistered(c);
            }
        }
        catch (InvalidNodeTypeDefException e) {
            String msg = "Unable to deliver node type operation: " + e.getMessage();
            log.error(msg);
        }
        catch (RepositoryException e) {
            String msg = "Unable to deliver node type operation: " + e.getMessage();
            log.error(msg);
        }
    }

    private void process(NodeTypeDef ntDef) {
        if (this.nodeTypeListener == null) {
            String msg = "NodeType listener unavailable.";
            log.error(msg);
            return;
        }
        try {
            this.nodeTypeListener.externalReregistered(ntDef);
        }
        catch (InvalidNodeTypeDefException e) {
            String msg = "Unable to deliver node type operation: " + e.getMessage();
            log.error(msg);
        }
        catch (RepositoryException e) {
            String msg = "Unable to deliver node type operation: " + e.getMessage();
            log.error(msg);
        }
    }

    private void end() {
        String msg;
        UpdateEventListener listener = null;
        if (this.workspace != null) {
            listener = (UpdateEventListener)this.wspUpdateListeners.get(this.workspace);
            if (listener == null) {
                try {
                    this.clusterContext.updateEventsReady(this.workspace);
                }
                catch (RepositoryException e) {
                    msg = "Error making update listener for workspace " + this.workspace + " online: " + e.getMessage();
                    log.warn(msg);
                }
                listener = (UpdateEventListener)this.wspUpdateListeners.get(this.workspace);
                if (listener == null) {
                    String msg2 = "Update listener unavailable for workspace: " + this.workspace;
                    log.error(msg2);
                    return;
                }
            }
        } else if (this.versionUpdateListener != null) {
            listener = this.versionUpdateListener;
        } else {
            String msg3 = "Version update listener unavailable.";
            log.error(msg3);
            return;
        }
        try {
            listener.externalUpdate(this.changeLog, this.events);
        }
        catch (RepositoryException e) {
            msg = "Unable to deliver update events: " + e.getMessage();
            log.error(msg);
        }
    }

    @Override
    public String getId() {
        return PRODUCER_ID;
    }

    @Override
    public long getRevision() {
        try {
            return this.instanceRevision.get();
        }
        catch (JournalException e) {
            log.warn("Unable to return current revision.", (Throwable)e);
            return Long.MAX_VALUE;
        }
    }

    @Override
    public void consume(Record record) {
        log.info("Processing revision: " + record.getRevision());
        String workspace = null;
        try {
            char c;
            workspace = record.readString();
            this.start(workspace);
            while ((c = record.readChar()) != '\u0000') {
                if (c == 'N') {
                    NodeOperation operation = NodeOperation.create(record.readByte());
                    operation.setId(record.readNodeId());
                    this.process(operation);
                    continue;
                }
                if (c == 'P') {
                    PropertyOperation operation = PropertyOperation.create(record.readByte());
                    operation.setId(record.readPropertyId());
                    this.process(operation);
                    continue;
                }
                if (c == 'E') {
                    byte type = record.readByte();
                    NodeId parentId = record.readNodeId();
                    Path parentPath = record.readPath();
                    NodeId childId = record.readNodeId();
                    Path.Element childRelPath = record.readPathElement();
                    Name ntName = record.readQName();
                    HashSet<Name> mixins = new HashSet<Name>();
                    int mixinCount = record.readInt();
                    for (int i = 0; i < mixinCount; ++i) {
                        mixins.add(record.readQName());
                    }
                    String userId = record.readString();
                    this.process(this.createEventState(type, parentId, parentPath, childId, childRelPath, ntName, mixins, userId));
                    continue;
                }
                if (c == 'L') {
                    NodeId nodeId = record.readNodeId();
                    boolean isLock = record.readBoolean();
                    if (isLock) {
                        boolean isDeep = record.readBoolean();
                        String owner = record.readString();
                        this.process(nodeId, isDeep, owner);
                        continue;
                    }
                    this.process(nodeId);
                    continue;
                }
                if (c == 'S') {
                    String oldPrefix = record.readString();
                    String newPrefix = record.readString();
                    String uri = record.readString();
                    this.process(oldPrefix, newPrefix, uri);
                    continue;
                }
                if (c == 'T') {
                    int size = record.readInt();
                    int opcode = size & 0xC0000000;
                    size &= 0x3FFFFFFF;
                    switch (opcode) {
                        case 0: {
                            HashSet<NodeTypeDef> ntDefs = new HashSet<NodeTypeDef>();
                            for (int i = 0; i < size; ++i) {
                                ntDefs.add(record.readNodeTypeDef());
                            }
                            this.process(ntDefs, true);
                            break;
                        }
                        case 0x40000000: {
                            this.process(record.readNodeTypeDef());
                            break;
                        }
                        case -2147483648: {
                            HashSet<Name> ntNames = new HashSet<Name>();
                            for (int i = 0; i < size; ++i) {
                                ntNames.add(record.readQName());
                            }
                            this.process(ntNames, false);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unknown opcode: " + opcode);
                        }
                    }
                    continue;
                }
                throw new IllegalArgumentException("Unknown entry type: " + c);
            }
            this.end();
        }
        catch (JournalException e) {
            String msg = "Unable to read revision '" + record.getRevision() + "'.";
            log.error(msg, (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            String msg = "Error while processing revision " + record.getRevision() + ": " + e.getMessage();
            log.error(msg);
        }
    }

    @Override
    public void setRevision(long revision) {
        try {
            this.instanceRevision.set(revision);
        }
        catch (JournalException e) {
            log.warn("Unable to set current revision to " + revision + ".", (Throwable)e);
        }
    }

    private EventState createEventState(int type, NodeId parentId, Path parentPath, NodeId childId, Path.Element childRelPath, Name ntName, Set mixins, String userId) {
        switch (type) {
            case 1: {
                return EventState.childNodeAdded(parentId, parentPath, childId, childRelPath, ntName, mixins, this.getOrCreateSession(userId), true);
            }
            case 2: {
                return EventState.childNodeRemoved(parentId, parentPath, childId, childRelPath, ntName, mixins, this.getOrCreateSession(userId), true);
            }
            case 4: {
                return EventState.propertyAdded(parentId, parentPath, childRelPath, ntName, mixins, this.getOrCreateSession(userId), true);
            }
            case 16: {
                return EventState.propertyChanged(parentId, parentPath, childRelPath, ntName, mixins, this.getOrCreateSession(userId), true);
            }
            case 8: {
                return EventState.propertyRemoved(parentId, parentPath, childRelPath, ntName, mixins, this.getOrCreateSession(userId), true);
            }
        }
        String msg = "Unexpected event type: " + type;
        throw new IllegalArgumentException(msg);
    }

    private Session getOrCreateSession(String userId) {
        if (this.lastSession == null || !this.lastSession.getUserID().equals(userId)) {
            this.lastSession = new ClusterSession(userId);
        }
        return this.lastSession;
    }

    private static void write(Record record, ChangeLog changeLog, EventStateCollection esc) throws JournalException {
        Iterator deletedStates = changeLog.deletedStates();
        while (deletedStates.hasNext()) {
            ItemState state = (ItemState)deletedStates.next();
            if (state.isNode()) {
                ClusterNode.write(record, NodeDeletedOperation.create((NodeState)state));
                continue;
            }
            ClusterNode.write(record, PropertyDeletedOperation.create((PropertyState)state));
        }
        Iterator modifiedStates = changeLog.modifiedStates();
        while (modifiedStates.hasNext()) {
            ItemState state = (ItemState)modifiedStates.next();
            if (state.isNode()) {
                ClusterNode.write(record, NodeModifiedOperation.create((NodeState)state));
                continue;
            }
            ClusterNode.write(record, PropertyModifiedOperation.create((PropertyState)state));
        }
        Iterator addedStates = changeLog.addedStates();
        while (addedStates.hasNext()) {
            ItemState state = (ItemState)addedStates.next();
            if (state.isNode()) {
                ClusterNode.write(record, NodeAddedOperation.create((NodeState)state));
                continue;
            }
            ClusterNode.write(record, PropertyAddedOperation.create((PropertyState)state));
        }
        for (EventState event : esc.getEvents()) {
            ClusterNode.write(record, event);
        }
    }

    private static void write(Record record, String oldPrefix, String newPrefix, String uri) throws JournalException {
        record.writeChar('S');
        record.writeString(oldPrefix);
        record.writeString(newPrefix);
        record.writeString(uri);
    }

    private static void write(Record record, Collection c, boolean register) throws JournalException {
        record.writeChar('T');
        int size = c.size();
        if (!register) {
            size |= Integer.MIN_VALUE;
        }
        record.writeInt(size);
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            if (register) {
                record.writeNodeTypeDef((NodeTypeDef)iter.next());
                continue;
            }
            record.writeQName((Name)iter.next());
        }
    }

    private static void write(Record record, NodeTypeDef ntDef) throws JournalException {
        record.writeChar('T');
        int size = 1;
        record.writeInt(size |= 0x40000000);
        record.writeNodeTypeDef(ntDef);
    }

    private static void write(Record record, PropertyOperation operation) throws JournalException {
        record.writeChar('P');
        record.writeByte(operation.getOperationType());
        record.writePropertyId(operation.getId());
    }

    private static void write(Record record, NodeOperation operation) throws JournalException {
        record.writeChar('N');
        record.writeByte(operation.getOperationType());
        record.writeNodeId(operation.getId());
    }

    private static void write(Record record, EventState event) throws JournalException {
        record.writeChar('E');
        record.writeByte(event.getType());
        record.writeNodeId(event.getParentId());
        record.writePath(event.getParentPath());
        record.writeNodeId(event.getChildId());
        record.writePathElement(event.getChildRelPath());
        record.writeQName(event.getNodeType());
        Set mixins = event.getMixinNames();
        record.writeInt(mixins.size());
        Iterator iter = mixins.iterator();
        while (iter.hasNext()) {
            record.writeQName((Name)iter.next());
        }
        record.writeString(event.getUserId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ended(AbstractClusterOperation operation, boolean successful) {
        Record record = operation.getRecord();
        boolean succeeded = false;
        try {
            if (successful) {
                record = operation.getRecord();
                record.writeString(operation.getWorkspace());
                operation.write();
                record.writeChar('\u0000');
                record.update();
                this.setRevision(record.getRevision());
                succeeded = true;
            }
        }
        catch (JournalException e) {
            String msg = "Unable to create log entry: " + e.getMessage();
            log.error(msg);
        }
        catch (Throwable e) {
            String msg = "Unexpected error while creating log entry.";
            log.error(msg, e);
        }
        finally {
            if (!succeeded) {
                record.cancelUpdate();
            }
        }
    }

    class WorkspaceLockChannel
    implements LockEventChannel {
        private final String workspace;

        public WorkspaceLockChannel(String workspace) {
            this.workspace = workspace;
        }

        @Override
        public ClusterOperation create(NodeId nodeId, boolean deep, String owner) {
            if (ClusterNode.this.status != 1) {
                log.info("not started: lock operation ignored.");
                return null;
            }
            try {
                Record record = ClusterNode.this.journal.getProducer(ClusterNode.PRODUCER_ID).append();
                return new LockOperation(ClusterNode.this, this.workspace, record, nodeId, deep, owner);
            }
            catch (JournalException e) {
                String msg = "Unable to create log entry: " + e.getMessage();
                log.error(msg);
                return null;
            }
            catch (Throwable e) {
                String msg = "Unexpected error while creating log entry.";
                log.error(msg, e);
                return null;
            }
        }

        @Override
        public ClusterOperation create(NodeId nodeId) {
            if (ClusterNode.this.status != 1) {
                log.info("not started: unlock operation ignored.");
                return null;
            }
            try {
                Record record = ClusterNode.this.journal.getProducer(ClusterNode.PRODUCER_ID).append();
                return new LockOperation(ClusterNode.this, this.workspace, record, nodeId);
            }
            catch (JournalException e) {
                String msg = "Unable to create log entry: " + e.getMessage();
                log.error(msg);
                return null;
            }
            catch (Throwable e) {
                String msg = "Unexpected error while creating log entry.";
                log.error(msg, e);
                return null;
            }
        }

        @Override
        public void setListener(LockEventListener listener) {
            ClusterNode.this.wspLockListeners.remove(this.workspace);
            if (listener != null) {
                ClusterNode.this.wspLockListeners.put(this.workspace, listener);
            }
        }
    }

    class WorkspaceUpdateChannel
    implements UpdateEventChannel {
        private static final String ATTRIBUTE_RECORD = "record";
        private final String workspace;

        public WorkspaceUpdateChannel(String workspace) {
            this.workspace = workspace;
        }

        @Override
        public void updateCreated(Update update) {
            if (ClusterNode.this.status != 1) {
                log.info("not started: update create ignored.");
                return;
            }
            try {
                Record record = ClusterNode.this.journal.getProducer(ClusterNode.PRODUCER_ID).append();
                update.setAttribute(ATTRIBUTE_RECORD, record);
            }
            catch (JournalException e) {
                String msg = "Unable to create log entry.";
                log.error(msg, (Throwable)e);
            }
            catch (Throwable e) {
                String msg = "Unexpected error while creating log entry.";
                log.error(msg, e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void updatePrepared(Update update) {
            if (ClusterNode.this.status != 1) {
                log.info("not started: update prepare ignored.");
                return;
            }
            Record record = (Record)update.getAttribute(ATTRIBUTE_RECORD);
            if (record == null) {
                String msg = "No record created.";
                log.warn(msg);
                return;
            }
            EventStateCollection events = update.getEvents();
            ChangeLog changes = update.getChanges();
            boolean succeeded = false;
            try {
                record.writeString(this.workspace);
                ClusterNode.write(record, changes, events);
                record.writeChar('\u0000');
                succeeded = true;
            }
            catch (JournalException e) {
                String msg = "Unable to create log entry: " + e.getMessage();
                log.error(msg);
            }
            catch (Throwable e) {
                String msg = "Unexpected error while preparing log entry.";
                log.error(msg, e);
            }
            finally {
                if (!succeeded && record != null) {
                    record.cancelUpdate();
                    update.setAttribute(ATTRIBUTE_RECORD, null);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void updateCommitted(Update update) {
            if (ClusterNode.this.status != 1) {
                log.info("not started: update commit ignored.");
                return;
            }
            Record record = (Record)update.getAttribute(ATTRIBUTE_RECORD);
            if (record == null) {
                String msg = "No record prepared.";
                log.warn(msg);
                return;
            }
            try {
                record.update();
                ClusterNode.this.setRevision(record.getRevision());
                log.info("Appended revision: " + record.getRevision());
            }
            catch (JournalException e) {
                String msg = "Unable to commit log entry.";
                log.error(msg, (Throwable)e);
            }
            catch (Throwable e) {
                String msg = "Unexpected error while committing log entry.";
                log.error(msg, e);
            }
            finally {
                update.setAttribute(ATTRIBUTE_RECORD, null);
            }
        }

        @Override
        public void updateCancelled(Update update) {
            if (ClusterNode.this.status != 1) {
                log.info("not started: update cancel ignored.");
                return;
            }
            Record record = (Record)update.getAttribute(ATTRIBUTE_RECORD);
            if (record != null) {
                record.cancelUpdate();
                update.setAttribute(ATTRIBUTE_RECORD, null);
            }
        }

        @Override
        public void setListener(UpdateEventListener listener) {
            if (this.workspace == null) {
                ClusterNode.this.versionUpdateListener = listener;
            } else {
                ClusterNode.this.wspUpdateListeners.remove(this.workspace);
                if (listener != null) {
                    ClusterNode.this.wspUpdateListeners.put(this.workspace, listener);
                }
            }
        }
    }
}

