/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.data.db;

import com.kingdee.bos.ctrl.kdf.util.CloseUtil;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TempFileInputStream
extends InputStream {
    private final File file;
    private final InputStream in;
    private boolean closed;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long writeToFileAndClose(InputStream in, File file) throws IOException {
        FileOutputStream out = null;
        try {
            int n;
            out = new FileOutputStream(file);
            byte[] b = new byte[4096];
            while ((n = in.read(b)) >= 0) {
                ((OutputStream)out).write(b, 0, n);
            }
        }
        catch (Throwable throwable) {
            CloseUtil.close((Closeable[])new Closeable[]{in});
            CloseUtil.close((Closeable[])new Closeable[]{out});
            throw throwable;
        }
        CloseUtil.close((Closeable[])new Closeable[]{in});
        CloseUtil.close((Closeable[])new Closeable[]{out});
        return file.length();
    }

    TempFileInputStream(File file) throws FileNotFoundException {
        this.file = file;
        this.in = new BufferedInputStream(new FileInputStream(file));
    }

    private int closeIfEOF(int read) throws IOException {
        if (read < 0) {
            this.close();
        }
        return read;
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.in.close();
            this.file.delete();
            this.closed = true;
        }
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public void mark(int readlimit) {
        this.in.mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }

    @Override
    public long skip(long n) throws IOException {
        return this.in.skip(n);
    }

    @Override
    public void reset() throws IOException {
        this.in.reset();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.closeIfEOF(this.in.read(b, off, len));
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.closeIfEOF(this.in.read(b));
    }

    @Override
    public int read() throws IOException {
        return this.closeIfEOF(this.in.read());
    }
}

