/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.fs.local;

import com.kingdee.bos.ctrl.common.util.CommonSLF4JLogger;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import org.apache.jackrabbit.core.fs.FileSystem;
import org.apache.jackrabbit.core.fs.FileSystemException;
import org.apache.jackrabbit.core.fs.RandomAccessOutputStream;
import org.apache.jackrabbit.core.fs.local.FileUtil;
import org.apache.jackrabbit.core.fs.local.HandleMonitor;
import org.apache.jackrabbit.core.fs.local.RAFOutputStream;
import org.apache.jackrabbit.util.LazyFileInputStream;
import org.slf4j.Logger;

public class LocalFileSystem
implements FileSystem {
    private static Logger log = CommonSLF4JLogger.getLogger(LocalFileSystem.class);
    private File root;
    private HandleMonitor monitor = null;

    public String getPath() {
        if (this.root != null) {
            return this.root.getPath();
        }
        return null;
    }

    public void setPath(String rootPath) {
        this.setRoot(new File(this.osPath(rootPath)));
    }

    public void setRoot(File root) {
        this.root = root;
    }

    public void setEnableHandleMonitor(String enable) {
        this.setEnableHandleMonitor(Boolean.valueOf(enable));
    }

    public void setEnableHandleMonitor(boolean enable) {
        if (enable && this.monitor == null) {
            this.monitor = new HandleMonitor();
        }
        if (!enable && this.monitor != null) {
            this.monitor = null;
        }
    }

    public String getEnableHandleMonitor() {
        return this.monitor == null ? "false" : "true";
    }

    private String osPath(String genericPath) {
        if (File.separator.equals("/")) {
            return genericPath;
        }
        return genericPath.replace('/', File.separatorChar);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof LocalFileSystem) {
            LocalFileSystem other = (LocalFileSystem)obj;
            if (this.root == null) {
                return other.root == null;
            }
            return this.root.equals(other.root);
        }
        return false;
    }

    public int hashCode() {
        return 0;
    }

    @Override
    public void init() throws FileSystemException {
        if (this.root == null) {
            String msg = "root directory not set";
            log.debug(msg);
            throw new FileSystemException(msg);
        }
        if (this.root.exists()) {
            if (!this.root.isDirectory()) {
                String msg = "path does not denote a folder";
                log.debug(msg);
                throw new FileSystemException(msg);
            }
        } else if (!this.root.mkdirs()) {
            String msg = "failed to create root";
            log.debug(msg);
            throw new FileSystemException(msg);
        }
        log.info("LocalFileSystem initialized at path " + this.root.getPath());
        if (this.monitor != null) {
            log.info("LocalFileSystem using handle monitor");
        }
    }

    @Override
    public void close() throws FileSystemException {
        this.root = null;
    }

    @Override
    public void copy(String srcPath, String destPath) throws FileSystemException {
        File src = new File(this.root, this.osPath(srcPath));
        File dest = new File(this.root, this.osPath(destPath));
        try {
            FileUtil.copy(src, dest);
        }
        catch (IOException ioe) {
            String msg = "copying " + src.getPath() + " to " + dest.getPath() + " failed";
            log.debug(msg);
            throw new FileSystemException(msg, ioe);
        }
    }

    @Override
    public void createFolder(String folderPath) throws FileSystemException {
        File f = new File(this.root, this.osPath(folderPath));
        if (f.exists()) {
            String msg = f.getPath() + " already exists";
            log.debug(msg);
            throw new FileSystemException(msg);
        }
        if (!f.mkdirs()) {
            String msg = "failed to create folder " + f.getPath();
            log.debug(msg);
            throw new FileSystemException(msg);
        }
    }

    @Override
    public void deleteFile(String filePath) throws FileSystemException {
        File f = new File(this.root, this.osPath(filePath));
        if (!f.isFile()) {
            String msg = f.getPath() + " does not denote an existing file";
            throw new FileSystemException(msg);
        }
        try {
            FileUtil.delete(f);
        }
        catch (IOException ioe) {
            String msg = "failed to delete " + f.getPath();
            if (this.monitor != null && this.monitor.isOpen(f)) {
                log.error("Unable to delete. There are still open streams.");
                this.monitor.dump(f);
            }
            throw new FileSystemException(msg, ioe);
        }
    }

    @Override
    public void deleteFolder(String folderPath) throws FileSystemException {
        File f = new File(this.root, this.osPath(folderPath));
        if (!f.isDirectory()) {
            String msg = f.getPath() + " does not denote an existing folder";
            log.debug(msg);
            throw new FileSystemException(msg);
        }
        try {
            FileUtil.delete(f);
        }
        catch (IOException ioe) {
            String msg = "failed to delete " + f.getPath();
            log.debug(msg);
            throw new FileSystemException(msg, ioe);
        }
    }

    @Override
    public boolean exists(String path) throws FileSystemException {
        File f = new File(this.root, this.osPath(path));
        return f.exists();
    }

    @Override
    public InputStream getInputStream(String filePath) throws FileSystemException {
        File f = new File(this.root, this.osPath(filePath));
        try {
            if (this.monitor == null) {
                return new LazyFileInputStream(f);
            }
            return this.monitor.open(f);
        }
        catch (FileNotFoundException fnfe) {
            String msg = f.getPath() + " does not denote an existing file";
            log.debug(msg);
            throw new FileSystemException(msg, fnfe);
        }
    }

    @Override
    public OutputStream getOutputStream(String filePath) throws FileSystemException {
        File f = new File(this.root, this.osPath(filePath));
        try {
            return new FileOutputStream(f);
        }
        catch (FileNotFoundException fnfe) {
            String msg = "failed to get output stream for " + f.getPath();
            log.debug(msg);
            throw new FileSystemException(msg, fnfe);
        }
    }

    @Override
    public RandomAccessOutputStream getRandomAccessOutputStream(String filePath) throws FileSystemException {
        File f = new File(this.root, this.osPath(filePath));
        try {
            return new RAFOutputStream(new RandomAccessFile(f, "rw"));
        }
        catch (IOException e) {
            String msg = "failed to get output stream for " + f.getPath();
            log.debug(msg);
            throw new FileSystemException(msg, e);
        }
    }

    @Override
    public boolean hasChildren(String path) throws FileSystemException {
        File f = new File(this.root, this.osPath(path));
        if (!f.exists()) {
            String msg = f.getPath() + " does not exist";
            log.debug(msg);
            throw new FileSystemException(msg);
        }
        if (f.isFile()) {
            return false;
        }
        return f.list().length > 0;
    }

    @Override
    public boolean isFile(String path) throws FileSystemException {
        File f = new File(this.root, this.osPath(path));
        return f.isFile();
    }

    @Override
    public boolean isFolder(String path) throws FileSystemException {
        File f = new File(this.root, this.osPath(path));
        return f.isDirectory();
    }

    @Override
    public long lastModified(String path) throws FileSystemException {
        File f = new File(this.root, this.osPath(path));
        return f.lastModified();
    }

    @Override
    public long length(String filePath) throws FileSystemException {
        File f = new File(this.root, this.osPath(filePath));
        if (!f.exists()) {
            return -1L;
        }
        return f.length();
    }

    @Override
    public void touch(String filePath) throws FileSystemException {
        File f = new File(this.root, this.osPath(filePath));
        f.setLastModified(System.currentTimeMillis());
    }

    @Override
    public String[] list(String folderPath) throws FileSystemException {
        File f = new File(this.root, this.osPath(folderPath));
        String[] entries = f.list();
        if (entries == null) {
            String msg = folderPath + " does not denote a folder";
            log.debug(msg);
            throw new FileSystemException(msg);
        }
        return entries;
    }

    @Override
    public String[] listFiles(String folderPath) throws FileSystemException {
        File folder = new File(this.root, this.osPath(folderPath));
        File[] files = folder.listFiles(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isFile();
            }
        });
        if (files == null) {
            String msg = folderPath + " does not denote a folder";
            log.debug(msg);
            throw new FileSystemException(msg);
        }
        String[] entries = new String[files.length];
        for (int i = 0; i < files.length; ++i) {
            entries[i] = files[i].getName();
        }
        return entries;
    }

    @Override
    public String[] listFolders(String folderPath) throws FileSystemException {
        File file = new File(this.root, this.osPath(folderPath));
        File[] folders = file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory();
            }
        });
        if (folders == null) {
            String msg = folderPath + " does not denote a folder";
            log.debug(msg);
            throw new FileSystemException(msg);
        }
        String[] entries = new String[folders.length];
        for (int i = 0; i < folders.length; ++i) {
            entries[i] = folders[i].getName();
        }
        return entries;
    }

    @Override
    public void move(String srcPath, String destPath) throws FileSystemException {
        File destParent;
        File src = new File(this.root, this.osPath(srcPath));
        File dest = new File(this.root, this.osPath(destPath));
        if (dest.exists()) {
            try {
                FileUtil.delete(dest);
            }
            catch (IOException ioe) {
                String msg = "moving " + src.getPath() + " to " + dest.getPath() + " failed";
                log.debug(msg);
                throw new FileSystemException(msg, ioe);
            }
        }
        if (!(destParent = dest.getParentFile()).exists() && !destParent.mkdirs()) {
            String msg = "moving " + src.getPath() + " to " + dest.getPath() + " failed";
            log.debug(msg);
            throw new FileSystemException(msg);
        }
        if (!src.renameTo(dest)) {
            String msg = "moving " + src.getPath() + " to " + dest.getPath() + " failed";
            log.debug(msg);
            throw new FileSystemException(msg);
        }
    }
}

