/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.nodetype;

import java.util.Arrays;
import java.util.HashSet;
import org.apache.jackrabbit.core.nodetype.ItemDefImpl;
import org.apache.jackrabbit.core.nodetype.NodeDef;
import org.apache.jackrabbit.core.nodetype.NodeDefId;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.name.NameConstants;

public class NodeDefImpl
extends ItemDefImpl
implements NodeDef {
    private Name defaultPrimaryType = null;
    private HashSet requiredPrimaryTypes = new HashSet();
    private boolean allowsSameNameSiblings;
    private NodeDefId id;

    public NodeDefImpl() {
        this.requiredPrimaryTypes.add(NameConstants.NT_BASE);
        this.allowsSameNameSiblings = false;
        this.id = null;
    }

    public void setDefaultPrimaryType(Name defaultNodeType) {
        this.id = null;
        this.defaultPrimaryType = defaultNodeType;
    }

    public void setRequiredPrimaryTypes(Name[] requiredPrimaryTypes) {
        if (requiredPrimaryTypes == null) {
            throw new IllegalArgumentException("requiredPrimaryTypes can not be null");
        }
        this.id = null;
        this.requiredPrimaryTypes.clear();
        this.requiredPrimaryTypes.addAll(Arrays.asList(requiredPrimaryTypes));
    }

    public void setAllowsSameNameSiblings(boolean allowsSameNameSiblings) {
        this.id = null;
        this.allowsSameNameSiblings = allowsSameNameSiblings;
    }

    @Override
    public void setDeclaringNodeType(Name declaringNodeType) {
        this.id = null;
        super.setDeclaringNodeType(declaringNodeType);
    }

    @Override
    public void setName(Name name) {
        this.id = null;
        super.setName(name);
    }

    @Override
    public void setAutoCreated(boolean autoCreated) {
        this.id = null;
        super.setAutoCreated(autoCreated);
    }

    @Override
    public void setOnParentVersion(int onParentVersion) {
        this.id = null;
        super.setOnParentVersion(onParentVersion);
    }

    @Override
    public void setProtected(boolean writeProtected) {
        this.id = null;
        super.setProtected(writeProtected);
    }

    @Override
    public void setMandatory(boolean mandatory) {
        this.id = null;
        super.setMandatory(mandatory);
    }

    @Override
    public NodeDefId getId() {
        if (this.id == null) {
            this.id = new NodeDefId(this);
        }
        return this.id;
    }

    @Override
    public Name getDefaultPrimaryType() {
        return this.defaultPrimaryType;
    }

    @Override
    public Name[] getRequiredPrimaryTypes() {
        if (this.requiredPrimaryTypes.isEmpty()) {
            return Name.EMPTY_ARRAY;
        }
        return this.requiredPrimaryTypes.toArray(new Name[this.requiredPrimaryTypes.size()]);
    }

    @Override
    public boolean allowsSameNameSiblings() {
        return this.allowsSameNameSiblings;
    }

    @Override
    public boolean definesNode() {
        return true;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof NodeDefImpl) {
            NodeDefImpl other = (NodeDefImpl)obj;
            return super.equals(obj) && this.requiredPrimaryTypes.equals(other.requiredPrimaryTypes) && (this.defaultPrimaryType == null ? other.defaultPrimaryType == null : this.defaultPrimaryType.equals(other.defaultPrimaryType)) && this.allowsSameNameSiblings == other.allowsSameNameSiblings;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 0;
    }
}

