/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.observation;

import com.kingdee.bos.ctrl.common.util.CommonSLF4JLogger;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import org.apache.jackrabbit.core.ItemId;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.observation.EventFilter;
import org.apache.jackrabbit.core.observation.EventState;
import org.apache.jackrabbit.core.observation.EventStateCollection;
import org.apache.jackrabbit.core.observation.FilteredEventIterator;
import org.apache.jackrabbit.core.state.ItemState;
import org.slf4j.Logger;

class EventConsumer {
    private static final Logger log = CommonSLF4JLogger.getLogger(EventConsumer.class);
    private final SessionImpl session;
    private final EventListener listener;
    private final EventFilter filter;
    private final Map accessDenied = Collections.synchronizedMap(new WeakHashMap());
    private int hashCode;

    EventConsumer(SessionImpl session, EventListener listener, EventFilter filter) throws NullPointerException {
        if (session == null) {
            throw new NullPointerException("session");
        }
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (filter == null) {
            throw new NullPointerException("filter");
        }
        this.session = session;
        this.listener = listener;
        this.filter = filter;
    }

    Session getSession() {
        return this.session;
    }

    EventListener getEventListener() {
        return this.listener;
    }

    void prepareEvents(EventStateCollection events) {
        Iterator it = events.iterator();
        HashSet<ItemId> denied = null;
        while (it.hasNext()) {
            EventState state = (EventState)it.next();
            if (state.getType() != 2 && state.getType() != 8 || this.session.equals(state.getSession())) continue;
            ItemId targetId = state.getTargetId();
            boolean granted = false;
            try {
                granted = this.session.getAccessManager().isGranted(targetId, 1);
            }
            catch (RepositoryException e) {
                log.warn("Unable to check access rights for item: " + targetId);
            }
            if (granted) continue;
            if (denied == null) {
                denied = new HashSet<ItemId>();
            }
            denied.add(targetId);
        }
        if (denied != null) {
            this.accessDenied.put(events, denied);
        }
    }

    void prepareDeleted(EventStateCollection events, Iterator deletedItems) {
        HashSet<ItemId> denied = null;
        while (deletedItems.hasNext()) {
            ItemState item = (ItemState)deletedItems.next();
            boolean granted = false;
            try {
                granted = this.session.getAccessManager().isGranted(item.getId(), 1);
            }
            catch (RepositoryException e) {
                log.warn("Unable to check access rights for item: " + item.getId());
            }
            if (granted) continue;
            if (denied == null) {
                denied = new HashSet<ItemId>();
            }
            denied.add(item.getId());
        }
        if (denied != null) {
            this.accessDenied.put(events, denied);
        }
    }

    void consumeEvents(EventStateCollection events) throws RepositoryException {
        HashSet<ItemId> denied = (HashSet<ItemId>)this.accessDenied.remove(events);
        Object it = events.iterator();
        while (it.hasNext() && this.session.isLive()) {
            EventState state = (EventState)it.next();
            if (state.getType() != 1 && state.getType() != 4 && state.getType() != 16) continue;
            ItemId targetId = state.getTargetId();
            if (this.session.getAccessManager().isGranted(targetId, 1)) continue;
            if (denied == null) {
                denied = new HashSet<ItemId>();
            }
            denied.add(targetId);
        }
        if (!this.session.isLive()) {
            return;
        }
        it = new FilteredEventIterator(events, this.filter, denied);
        if (it.hasNext()) {
            this.listener.onEvent((EventIterator)it);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof EventConsumer) {
            EventConsumer other = (EventConsumer)obj;
            return this.session.equals(other.session) && this.listener.equals(other.listener);
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.session.hashCode() ^ this.listener.hashCode();
        }
        return this.hashCode;
    }
}

