/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.persistence.bundle.util;

import com.kingdee.bos.ctrl.common.util.CommonSLF4JLogger;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.PropertyId;
import org.apache.jackrabbit.core.nodetype.NodeDefId;
import org.apache.jackrabbit.core.nodetype.PropDefId;
import org.apache.jackrabbit.core.persistence.PersistenceManager;
import org.apache.jackrabbit.core.persistence.bundle.util.BundleBinding;
import org.apache.jackrabbit.core.persistence.util.BLOBStore;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.slf4j.Logger;

public class NodePropBundle {
    static final String CVS_ID = "$URL: http://svn.apache.org/repos/asf/jackrabbit/tags/1.4/jackrabbit-core/src/main/java/org/apache/jackrabbit/core/persistence/bundle/util/NodePropBundle.java $ $Rev: 605147 $ $Date: 2007-12-18 11:08:39 +0200 (Tue, 18 Dec 2007) $";
    private static Logger log = CommonSLF4JLogger.getLogger(NodePropBundle.class);
    private final BundleBinding binding;
    private final NodeId id;
    private NodeId parentId;
    private Name nodeTypeName;
    private Set mixinTypeNames;
    private NodeDefId nodeDefId;
    private LinkedList childNodeEntries = new LinkedList();
    private HashMap properties = new HashMap();
    private boolean isNew = true;
    private boolean isReferenceable = false;
    private short modCount = 0;
    private long size = 0L;

    public NodePropBundle(BundleBinding binding, NodeId id) {
        this.binding = binding;
        this.id = id;
    }

    public NodePropBundle(BundleBinding binding, NodeState state) {
        this(binding, (NodeId)state.getId());
        this.update(state);
    }

    public void update(NodeState state) {
        if (!this.id.equals(state.getNodeId())) {
            throw new IllegalArgumentException("Not allowed to update forgein state.");
        }
        this.parentId = state.getParentId();
        this.nodeTypeName = state.getNodeTypeName();
        this.mixinTypeNames = state.getMixinTypeNames();
        this.nodeDefId = state.getDefinitionId();
        this.isReferenceable = state.hasPropertyName(NameConstants.JCR_UUID);
        this.modCount = state.getModCount();
        List list = state.getChildNodeEntries();
        Iterator iter = list.iterator();
        this.childNodeEntries.clear();
        while (iter.hasNext()) {
            NodeState.ChildNodeEntry cne = (NodeState.ChildNodeEntry)iter.next();
            this.addChildNodeEntry(cne.getName(), cne.getId());
        }
    }

    public NodeState createNodeState(PersistenceManager pMgr) {
        NodeState state = pMgr.createNew(this.id);
        state.setParentId(this.parentId);
        state.setNodeTypeName(this.nodeTypeName);
        state.setMixinTypeNames(this.mixinTypeNames);
        state.setDefinitionId(this.nodeDefId);
        state.setModCount(this.modCount);
        for (ChildNodeEntry e : this.childNodeEntries) {
            state.addChildNodeEntry(e.getName(), e.getId());
        }
        state.setPropertyNames(this.properties.keySet());
        state.addPropertyName(NameConstants.JCR_PRIMARYTYPE);
        if (this.mixinTypeNames.size() > 0) {
            state.addPropertyName(NameConstants.JCR_MIXINTYPES);
        }
        if (this.isReferenceable) {
            state.addPropertyName(NameConstants.JCR_UUID);
        }
        return state;
    }

    public PropertyState createPropertyState(PersistenceManager pMgr, Name name) {
        PropertyEntry p = this.getPropertyEntry(name);
        if (p == null) {
            return null;
        }
        PropertyState ps = pMgr.createNew(new PropertyId(this.id, name));
        ps.setDefinitionId(p.getPropDefId());
        ps.setMultiValued(p.isMultiValued());
        ps.setType(p.getType());
        ps.setValues(p.getValues());
        ps.setModCount(p.getModCount());
        return ps;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public void markOld() {
        this.isNew = false;
    }

    public NodeId getId() {
        return this.id;
    }

    public NodeId getParentId() {
        return this.parentId;
    }

    public void setParentId(NodeId parentId) {
        this.parentId = parentId;
    }

    public Name getNodeTypeName() {
        return this.nodeTypeName;
    }

    public void setNodeTypeName(Name nodeTypeName) {
        this.nodeTypeName = nodeTypeName;
    }

    public Set getMixinTypeNames() {
        return this.mixinTypeNames;
    }

    public void setMixinTypeNames(Set mixinTypeNames) {
        this.mixinTypeNames = mixinTypeNames;
    }

    public NodeDefId getNodeDefId() {
        return this.nodeDefId;
    }

    public void setNodeDefId(NodeDefId nodeDefId) {
        this.nodeDefId = nodeDefId;
    }

    public boolean isReferenceable() {
        return this.isReferenceable;
    }

    public void setReferenceable(boolean referenceable) {
        this.isReferenceable = referenceable;
    }

    public short getModCount() {
        return this.modCount;
    }

    public void setModCount(short modCount) {
        this.modCount = modCount;
    }

    public List getChildNodeEntries() {
        return this.childNodeEntries;
    }

    public void addChildNodeEntry(Name name, NodeId id) {
        this.childNodeEntries.add(new ChildNodeEntry(name, id));
    }

    public void addProperty(PropertyEntry entry) {
        this.properties.put(entry.getName(), entry);
    }

    public void addProperty(PropertyState state) {
        PropertyEntry old = this.properties.put(state.getName(), new PropertyEntry(state));
        if (old != null) {
            old.destroy(this.binding.getBlobStore());
        }
    }

    public boolean hasProperty(Name name) {
        return this.properties.containsKey(name) || name.equals(NameConstants.JCR_PRIMARYTYPE) || this.isReferenceable && name.equals(NameConstants.JCR_UUID) || this.mixinTypeNames.size() > 0 && name.equals(NameConstants.JCR_MIXINTYPES);
    }

    public Set getPropertyNames() {
        return this.properties.keySet();
    }

    public Collection getPropertyEntries() {
        return this.properties.values();
    }

    public PropertyEntry getPropertyEntry(Name name) {
        return (PropertyEntry)this.properties.get(name);
    }

    public void removeAllProperties() {
        Iterator iter = this.properties.keySet().iterator();
        while (iter.hasNext()) {
            Name name = (Name)iter.next();
            this.removeProperty(name);
            iter = this.properties.keySet().iterator();
        }
    }

    public void removeProperty(Name name) {
        PropertyEntry pe = (PropertyEntry)this.properties.remove(name);
        if (pe != null) {
            pe.destroy(this.binding.getBlobStore());
        }
    }

    public long getSize() {
        return 500L + this.size + (long)(300 * (this.childNodeEntries.size() + this.properties.size() + 3));
    }

    public void setSize(long size) {
        this.size = size;
    }

    public static class PropertyEntry {
        private final PropertyId id;
        private InternalValue[] values;
        private int type;
        private boolean multiValued;
        private PropDefId propDefId;
        private String[] blobIds = null;
        private short modCount = 0;

        public PropertyEntry(PropertyId id) {
            this.id = id;
        }

        public PropertyEntry(PropertyState state) {
            this((PropertyId)state.getId());
            this.values = state.getValues();
            this.type = state.getType();
            this.multiValued = state.isMultiValued();
            this.propDefId = state.getDefinitionId();
            this.modCount = state.getModCount();
            if (this.type == 2) {
                this.blobIds = new String[this.values.length];
            }
        }

        public PropertyId getId() {
            return this.id;
        }

        public Name getName() {
            return this.id.getName();
        }

        public InternalValue[] getValues() {
            return this.values;
        }

        public void setValues(InternalValue[] values) {
            this.values = values;
        }

        public int getType() {
            return this.type;
        }

        public void setType(int type) {
            this.type = type;
        }

        public boolean isMultiValued() {
            return this.multiValued;
        }

        public void setMultiValued(boolean multiValued) {
            this.multiValued = multiValued;
        }

        public PropDefId getPropDefId() {
            return this.propDefId;
        }

        public void setPropDefId(PropDefId propDefId) {
            this.propDefId = propDefId;
        }

        public String getBlobId(int n) {
            return this.blobIds[n];
        }

        public void setBlobIds(String[] blobIds) {
            this.blobIds = blobIds;
        }

        public void setBlobId(String blobId, int n) {
            this.blobIds[n] = blobId;
        }

        public short getModCount() {
            return this.modCount;
        }

        public void setModCount(short modCount) {
            this.modCount = modCount;
        }

        private void destroy(BLOBStore blobStore) {
            if (this.blobIds != null) {
                for (int i = 0; i < this.blobIds.length; ++i) {
                    if (this.blobIds[i] == null) continue;
                    try {
                        blobStore.remove(this.blobIds[i]);
                        log.debug("removed blob {}", (Object)this.blobIds[i]);
                        continue;
                    }
                    catch (Exception e) {
                        log.error("Ingoring error while removing blob {}", (Object)this.blobIds[i], (Object)e);
                    }
                }
            }
        }
    }

    public static class ChildNodeEntry {
        private final Name name;
        private final NodeId id;

        public ChildNodeEntry(Name name, NodeId id) {
            this.name = name;
            this.id = id;
        }

        public Name getName() {
            return this.name;
        }

        public NodeId getId() {
            return this.id;
        }
    }
}

