/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import com.kingdee.bos.ctrl.lucene.document.Document;
import com.kingdee.bos.ctrl.lucene.index.IndexReader;
import com.kingdee.bos.ctrl.lucene.index.Term;
import com.kingdee.bos.ctrl.lucene.index.TermDocs;
import com.kingdee.bos.ctrl.lucene.search.Explanation;
import com.kingdee.bos.ctrl.lucene.search.HitCollector;
import com.kingdee.bos.ctrl.lucene.search.Query;
import com.kingdee.bos.ctrl.lucene.search.Scorer;
import com.kingdee.bos.ctrl.lucene.search.Searcher;
import com.kingdee.bos.ctrl.lucene.search.Similarity;
import com.kingdee.bos.ctrl.lucene.search.TermQuery;
import com.kingdee.bos.ctrl.lucene.search.Weight;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.query.lucene.FieldNames;
import org.apache.jackrabbit.core.query.lucene.hits.AdaptingHits;
import org.apache.jackrabbit.core.query.lucene.hits.Hits;
import org.apache.jackrabbit.core.query.lucene.hits.HitsIntersection;
import org.apache.jackrabbit.core.query.lucene.hits.ScorerHits;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.ItemStateManager;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.spi.Name;

class ChildAxisQuery
extends Query {
    private final ItemStateManager itemMgr;
    private Query contextQuery;
    private final String nameTest;
    private final int position;
    private Scorer contextScorer;
    private Scorer nameTestScorer;

    ChildAxisQuery(ItemStateManager itemMgr, Query context, String nameTest) {
        this(itemMgr, context, nameTest, -2147483647);
    }

    ChildAxisQuery(ItemStateManager itemMgr, Query context, String nameTest, int position) {
        this.itemMgr = itemMgr;
        this.contextQuery = context;
        this.nameTest = nameTest;
        this.position = position;
    }

    @Override
    protected Weight createWeight(Searcher searcher) {
        return new ChildAxisWeight(searcher);
    }

    @Override
    public void extractTerms(Set terms) {
        this.contextQuery.extractTerms(terms);
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        Query cQuery = this.contextQuery.rewrite(reader);
        if (cQuery == this.contextQuery) {
            return this;
        }
        return new ChildAxisQuery(this.itemMgr, cQuery, this.nameTest, this.position);
    }

    @Override
    public String toString(String field) {
        return "ChildAxisQuery";
    }

    private class ChildAxisScorer
    extends Scorer {
        private final IndexReader reader;
        private int nextDoc;
        private Hits hits;

        protected ChildAxisScorer(Similarity similarity, IndexReader reader) {
            super(similarity);
            this.nextDoc = -1;
            this.reader = reader;
        }

        @Override
        public boolean next() throws IOException {
            this.calculateChildren();
            do {
                this.nextDoc = this.hits.next();
            } while (this.nextDoc > -1 && !this.indexIsValid(this.nextDoc));
            return this.nextDoc > -1;
        }

        @Override
        public int doc() {
            return this.nextDoc;
        }

        @Override
        public float score() throws IOException {
            return 1.0f;
        }

        @Override
        public boolean skipTo(int target) throws IOException {
            this.calculateChildren();
            this.nextDoc = this.hits.skipTo(target);
            while (this.nextDoc > -1 && !this.indexIsValid(this.nextDoc)) {
                this.next();
            }
            return this.nextDoc > -1;
        }

        @Override
        public Explanation explain(int doc) throws IOException {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void calculateChildren() throws IOException {
            if (this.hits == null) {
                ArrayList<String> uuids = new ArrayList<String>();
                final AdaptingHits contextHits = new AdaptingHits();
                ChildAxisQuery.this.contextScorer.score(new HitCollector(){

                    @Override
                    public void collect(int doc, float score) {
                        contextHits.set(doc);
                    }
                });
                int i = contextHits.next();
                while (i > -1) {
                    String uuid = this.reader.document(i).get(FieldNames.UUID);
                    uuids.add(uuid);
                    i = contextHits.next();
                }
                AdaptingHits childrenHits = new AdaptingHits();
                try (TermDocs docs = this.reader.termDocs();){
                    Iterator it = uuids.iterator();
                    while (it.hasNext()) {
                        docs.seek(new Term(FieldNames.PARENT, (String)it.next()));
                        while (docs.next()) {
                            childrenHits.set(docs.doc());
                        }
                    }
                }
                this.hits = ChildAxisQuery.this.nameTestScorer != null ? new HitsIntersection(childrenHits, new ScorerHits(ChildAxisQuery.this.nameTestScorer)) : childrenHits;
            }
        }

        private boolean indexIsValid(int i) throws IOException {
            if (ChildAxisQuery.this.position != -2147483647) {
                Document node = this.reader.document(i);
                NodeId parentId = NodeId.valueOf(node.get(FieldNames.PARENT));
                NodeId id = NodeId.valueOf(node.get(FieldNames.UUID));
                try {
                    NodeState state = (NodeState)ChildAxisQuery.this.itemMgr.getItemState(parentId);
                    if (ChildAxisQuery.this.nameTest == null) {
                        if (ChildAxisQuery.this.position == Integer.MIN_VALUE) {
                            List childNodes = state.getChildNodeEntries();
                            if (childNodes.size() == 0 || !((NodeState.ChildNodeEntry)childNodes.get(childNodes.size() - 1)).getId().equals(id)) {
                                return false;
                            }
                        } else {
                            List childNodes = state.getChildNodeEntries();
                            if (ChildAxisQuery.this.position < 1 || childNodes.size() < ChildAxisQuery.this.position || !((NodeState.ChildNodeEntry)childNodes.get(ChildAxisQuery.this.position - 1)).getId().equals(id)) {
                                return false;
                            }
                        }
                    } else if (ChildAxisQuery.this.position == Integer.MIN_VALUE) {
                        NodeState.ChildNodeEntry entry = state.getChildNodeEntry(id);
                        if (entry == null) {
                            return false;
                        }
                        Name name = entry.getName();
                        List childNodes = state.getChildNodeEntries(name);
                        if (childNodes.size() == 0 || !((NodeState.ChildNodeEntry)childNodes.get(childNodes.size() - 1)).getId().equals(id)) {
                            return false;
                        }
                    } else {
                        NodeState.ChildNodeEntry entry = state.getChildNodeEntry(id);
                        if (entry == null) {
                            return false;
                        }
                        if (entry.getIndex() != ChildAxisQuery.this.position) {
                            return false;
                        }
                    }
                }
                catch (ItemStateException e) {
                    return false;
                }
            }
            return true;
        }
    }

    private class ChildAxisWeight
    implements Weight {
        private final Searcher searcher;

        private ChildAxisWeight(Searcher searcher) {
            this.searcher = searcher;
        }

        @Override
        public Query getQuery() {
            return ChildAxisQuery.this;
        }

        @Override
        public float getValue() {
            return 1.0f;
        }

        @Override
        public float sumOfSquaredWeights() throws IOException {
            return 1.0f;
        }

        @Override
        public void normalize(float norm) {
        }

        @Override
        public Scorer scorer(IndexReader reader) throws IOException {
            ChildAxisQuery.this.contextScorer = ChildAxisQuery.this.contextQuery.weight(this.searcher).scorer(reader);
            if (ChildAxisQuery.this.nameTest != null) {
                ChildAxisQuery.this.nameTestScorer = new TermQuery(new Term(FieldNames.LABEL, ChildAxisQuery.this.nameTest)).weight(this.searcher).scorer(reader);
            }
            return new ChildAxisScorer(this.searcher.getSimilarity(), reader);
        }

        @Override
        public Explanation explain(IndexReader reader, int doc) throws IOException {
            return new Explanation();
        }
    }
}

