/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import com.kingdee.bos.ctrl.lucene.index.IndexReader;
import com.kingdee.bos.ctrl.lucene.index.Term;
import com.kingdee.bos.ctrl.lucene.index.TermDocs;
import com.kingdee.bos.ctrl.lucene.search.Explanation;
import com.kingdee.bos.ctrl.lucene.search.HitCollector;
import com.kingdee.bos.ctrl.lucene.search.Query;
import com.kingdee.bos.ctrl.lucene.search.Scorer;
import com.kingdee.bos.ctrl.lucene.search.Searcher;
import com.kingdee.bos.ctrl.lucene.search.Similarity;
import com.kingdee.bos.ctrl.lucene.search.TermQuery;
import com.kingdee.bos.ctrl.lucene.search.Weight;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.jackrabbit.core.query.lucene.FieldNames;

class DerefQuery
extends Query {
    private final Query contextQuery;
    private final String refProperty;
    private final String nameTest;
    private Scorer contextScorer;
    private Scorer nameTestScorer;

    DerefQuery(Query context, String refProperty, String nameTest) {
        this.contextQuery = context;
        this.refProperty = refProperty;
        this.nameTest = nameTest;
    }

    @Override
    protected Weight createWeight(Searcher searcher) {
        return new DerefWeight(searcher);
    }

    @Override
    public String toString(String field) {
        return "DerefQuery";
    }

    @Override
    public void extractTerms(Set terms) {
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        Query cQuery = this.contextQuery.rewrite(reader);
        if (cQuery == this.contextQuery) {
            return this;
        }
        return new DerefQuery(cQuery, this.refProperty, this.nameTest);
    }

    private class DerefScorer
    extends Scorer {
        private final IndexReader reader;
        private final BitSet hits;
        private List uuids;
        private int nextDoc;

        protected DerefScorer(Similarity similarity, IndexReader reader) {
            super(similarity);
            this.uuids = null;
            this.nextDoc = -1;
            this.reader = reader;
            this.hits = new BitSet(reader.maxDoc());
        }

        @Override
        public boolean next() throws IOException {
            this.calculateChildren();
            this.nextDoc = this.hits.nextSetBit(this.nextDoc + 1);
            return this.nextDoc > -1;
        }

        @Override
        public int doc() {
            return this.nextDoc;
        }

        @Override
        public float score() throws IOException {
            return 1.0f;
        }

        @Override
        public boolean skipTo(int target) throws IOException {
            this.calculateChildren();
            this.nextDoc = this.hits.nextSetBit(target);
            return this.nextDoc > -1;
        }

        @Override
        public Explanation explain(int doc) throws IOException {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void calculateChildren() throws IOException {
            if (this.uuids == null) {
                this.uuids = new ArrayList();
                DerefQuery.this.contextScorer.score(new HitCollector(){

                    @Override
                    public void collect(int doc, float score) {
                        DerefScorer.this.hits.set(doc);
                    }
                });
                final BitSet nameTestHits = new BitSet();
                if (DerefQuery.this.nameTestScorer != null) {
                    DerefQuery.this.nameTestScorer.score(new HitCollector(){

                        @Override
                        public void collect(int doc, float score) {
                            nameTestHits.set(doc);
                        }
                    });
                }
                String prefix = FieldNames.createNamedValue(DerefQuery.this.refProperty, "");
                int i = this.hits.nextSetBit(0);
                while (i >= 0) {
                    String[] values = this.reader.document(i).getValues(FieldNames.PROPERTIES);
                    if (values != null) {
                        for (int v = 0; v < values.length; ++v) {
                            if (!values[v].startsWith(prefix)) continue;
                            this.uuids.add(values[v].substring(prefix.length()));
                        }
                    }
                    i = this.hits.nextSetBit(i + 1);
                }
                this.hits.clear();
                Iterator it = this.uuids.iterator();
                while (it.hasNext()) {
                    try (TermDocs node = this.reader.termDocs(new Term(FieldNames.UUID, (String)it.next()));){
                        while (node.next()) {
                            this.hits.set(node.doc());
                        }
                    }
                }
                if (DerefQuery.this.nameTestScorer != null) {
                    this.hits.and(nameTestHits);
                }
            }
        }
    }

    private class DerefWeight
    implements Weight {
        private final Searcher searcher;

        private DerefWeight(Searcher searcher) {
            this.searcher = searcher;
        }

        @Override
        public Query getQuery() {
            return DerefQuery.this;
        }

        @Override
        public float getValue() {
            return 1.0f;
        }

        @Override
        public float sumOfSquaredWeights() throws IOException {
            return 1.0f;
        }

        @Override
        public void normalize(float norm) {
        }

        @Override
        public Scorer scorer(IndexReader reader) throws IOException {
            DerefQuery.this.contextScorer = DerefQuery.this.contextQuery.weight(this.searcher).scorer(reader);
            if (DerefQuery.this.nameTest != null) {
                DerefQuery.this.nameTestScorer = new TermQuery(new Term(FieldNames.LABEL, DerefQuery.this.nameTest)).weight(this.searcher).scorer(reader);
            }
            return new DerefScorer(this.searcher.getSimilarity(), reader);
        }

        @Override
        public Explanation explain(IndexReader reader, int doc) throws IOException {
            return new Explanation();
        }
    }
}

