/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import com.kingdee.bos.ctrl.lucene.index.IndexReader;
import com.kingdee.bos.ctrl.lucene.search.Explanation;
import com.kingdee.bos.ctrl.lucene.search.Query;
import com.kingdee.bos.ctrl.lucene.search.Scorer;
import com.kingdee.bos.ctrl.lucene.search.Searcher;
import com.kingdee.bos.ctrl.lucene.search.Similarity;
import com.kingdee.bos.ctrl.lucene.search.Weight;
import java.io.IOException;
import java.util.Set;

class NotQuery
extends Query {
    private final Query context;
    private Scorer contextScorer;

    NotQuery(Query context) {
        this.context = context;
    }

    @Override
    protected Weight createWeight(Searcher searcher) {
        return new NotQueryWeight(searcher);
    }

    @Override
    public String toString(String field) {
        return "NotQuery";
    }

    @Override
    public void extractTerms(Set terms) {
        this.context.extractTerms(terms);
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        Query cQuery = this.context.rewrite(reader);
        if (cQuery == this.context) {
            return this;
        }
        return new NotQuery(cQuery);
    }

    private class NotQueryScorer
    extends Scorer {
        private final IndexReader reader;
        private int docNo;
        private int contextNo;

        NotQueryScorer(IndexReader reader) {
            super(Similarity.getDefault());
            this.docNo = -1;
            this.contextNo = -1;
            this.reader = reader;
        }

        @Override
        public boolean next() throws IOException {
            if (this.docNo == -1 && NotQuery.this.contextScorer.next()) {
                this.contextNo = NotQuery.this.contextScorer.doc();
            }
            do {
                ++this.docNo;
            } while (this.reader.isDeleted(this.docNo) && this.docNo < this.reader.maxDoc());
            while (this.contextNo != -1 && this.contextNo == this.docNo) {
                ++this.docNo;
                if (NotQuery.this.contextScorer.next()) {
                    this.contextNo = NotQuery.this.contextScorer.doc();
                    continue;
                }
                this.contextNo = -1;
            }
            return this.docNo < this.reader.maxDoc();
        }

        @Override
        public int doc() {
            return this.docNo;
        }

        @Override
        public float score() throws IOException {
            return 1.0f;
        }

        @Override
        public boolean skipTo(int target) throws IOException {
            if (this.contextNo != -1 && this.contextNo < target) {
                this.contextNo = NotQuery.this.contextScorer.skipTo(target) ? NotQuery.this.contextScorer.doc() : -1;
            }
            this.docNo = target - 1;
            return this.next();
        }

        @Override
        public Explanation explain(int doc) throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    private class NotQueryWeight
    implements Weight {
        private final Searcher searcher;

        NotQueryWeight(Searcher searcher) {
            this.searcher = searcher;
        }

        @Override
        public Query getQuery() {
            return NotQuery.this;
        }

        @Override
        public float getValue() {
            return 1.0f;
        }

        @Override
        public float sumOfSquaredWeights() throws IOException {
            return 1.0f;
        }

        @Override
        public void normalize(float norm) {
        }

        @Override
        public Scorer scorer(IndexReader reader) throws IOException {
            NotQuery.this.contextScorer = NotQuery.this.context.weight(this.searcher).scorer(reader);
            return new NotQueryScorer(reader);
        }

        @Override
        public Explanation explain(IndexReader reader, int doc) throws IOException {
            throw new UnsupportedOperationException();
        }
    }
}

