/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import com.kingdee.bos.ctrl.common.util.CommonSLF4JLogger;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.jackrabbit.core.fs.FileSystemException;
import org.apache.jackrabbit.core.fs.FileSystemResource;
import org.apache.jackrabbit.core.query.lucene.SynonymProvider;
import org.slf4j.Logger;

public class PropertiesSynonymProvider
implements SynonymProvider {
    private static final Logger log = CommonSLF4JLogger.getLogger(PropertiesSynonymProvider.class);
    private static final String[] EMPTY_ARRAY = new String[0];
    private static final long CHECK_INTERVAL = 10000L;
    private FileSystemResource config;
    private long lastCheck;
    private long configLastModified;
    private Map synonyms = new HashMap();

    @Override
    public synchronized void initialize(FileSystemResource fsr) throws IOException {
        if (fsr == null) {
            throw new IOException("PropertiesSynonymProvider requires a path configuration");
        }
        try {
            this.config = fsr;
            this.synonyms = PropertiesSynonymProvider.getSynonyms(this.config);
            this.configLastModified = this.config.lastModified();
            this.lastCheck = System.currentTimeMillis();
        }
        catch (FileSystemException e) {
            IOException ex = new IOException();
            ex.initCause(e);
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getSynonyms(String term) {
        String[] syns;
        this.checkConfigUpdated();
        term = term.toLowerCase();
        PropertiesSynonymProvider propertiesSynonymProvider = this;
        synchronized (propertiesSynonymProvider) {
            syns = (String[])this.synonyms.get(term);
        }
        if (syns == null) {
            syns = EMPTY_ARRAY;
        }
        return syns;
    }

    private synchronized void checkConfigUpdated() {
        if (this.lastCheck + 10000L > System.currentTimeMillis()) {
            return;
        }
        try {
            if (this.configLastModified != this.config.lastModified()) {
                this.synonyms = PropertiesSynonymProvider.getSynonyms(this.config);
                this.configLastModified = this.config.lastModified();
                log.info("Reloaded synonyms from {}", (Object)this.config.getPath());
            }
        }
        catch (Exception e) {
            log.error("Exception while reading synonyms", (Throwable)e);
        }
        this.lastCheck = System.currentTimeMillis();
    }

    private static Map getSynonyms(FileSystemResource config) throws IOException {
        try {
            HashMap synonyms = new HashMap();
            Properties props = new Properties();
            props.load(config.getInputStream());
            for (Map.Entry<Object, Object> e : props.entrySet()) {
                String key = (String)e.getKey();
                String value = (String)e.getValue();
                PropertiesSynonymProvider.addSynonym(key, value, synonyms);
                PropertiesSynonymProvider.addSynonym(value, key, synonyms);
            }
            return synonyms;
        }
        catch (FileSystemException e) {
            IOException ex = new IOException();
            ex.initCause(e);
            throw ex;
        }
    }

    private static void addSynonym(String term, String synonym, Map synonyms) {
        String[] syns = (String[])synonyms.get(term = term.toLowerCase());
        if (syns == null) {
            syns = new String[]{synonym};
        } else {
            String[] tmp = new String[syns.length + 1];
            System.arraycopy(syns, 0, tmp, 0, syns.length);
            tmp[syns.length] = synonym;
            syns = tmp;
        }
        synonyms.put(term, syns);
    }
}

