/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import com.kingdee.bos.ctrl.lucene.analysis.Analyzer;
import com.kingdee.bos.ctrl.lucene.document.Document;
import com.kingdee.bos.ctrl.lucene.index.Term;
import com.kingdee.bos.ctrl.lucene.store.RAMDirectory;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.collections.map.LinkedMap;
import org.apache.jackrabbit.core.query.lucene.AbstractIndex;
import org.apache.jackrabbit.core.query.lucene.CommittableIndexReader;
import org.apache.jackrabbit.core.query.lucene.FieldNames;
import org.apache.jackrabbit.core.query.lucene.IndexingQueue;
import org.apache.jackrabbit.core.query.lucene.Util;

class VolatileIndex
extends AbstractIndex {
    private static final int DEFAULT_BUFFER_SIZE = 10;
    private final Map pending = new LinkedMap();
    private int bufferSize = 10;
    private int numDocs = 0;

    VolatileIndex(Analyzer analyzer, IndexingQueue indexingQueue) throws IOException {
        super(analyzer, new RAMDirectory(), null, indexingQueue);
    }

    @Override
    void addDocuments(Document[] docs) throws IOException {
        for (int i = 0; i < docs.length; ++i) {
            Document old = this.pending.put(docs[i].get(FieldNames.UUID), docs[i]);
            if (old != null) {
                Util.disposeDocument(old);
            }
            if (this.pending.size() >= this.bufferSize) {
                this.commitPending();
            }
            ++this.numDocs;
        }
        this.invalidateSharedReader();
    }

    @Override
    int removeDocument(Term idTerm) throws IOException {
        int num;
        Document doc = (Document)this.pending.remove(idTerm.text());
        if (doc != null) {
            Util.disposeDocument(doc);
            num = 1;
        } else {
            num = super.getIndexReader().deleteDocuments(idTerm);
        }
        this.numDocs -= num;
        return num;
    }

    int getNumDocuments() throws IOException {
        return this.numDocs;
    }

    @Override
    protected synchronized CommittableIndexReader getIndexReader() throws IOException {
        this.commitPending();
        return super.getIndexReader();
    }

    @Override
    protected synchronized void commit(boolean optimize) throws IOException {
        this.commitPending();
        super.commit(optimize);
    }

    void setBufferSize(int size) {
        this.bufferSize = size;
    }

    private void commitPending() throws IOException {
        super.addDocuments(this.pending.values().toArray(new Document[this.pending.size()]));
        this.pending.clear();
    }
}

