/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security;

import com.kingdee.bos.ctrl.common.util.CommonSLF4JLogger;
import java.io.File;
import java.io.FileInputStream;
import java.security.Principal;
import java.security.acl.Group;
import java.util.Enumeration;
import java.util.Properties;
import javax.jcr.AccessDeniedException;
import org.apache.jackrabbit.core.ItemId;
import org.apache.jackrabbit.core.security.AMContext;
import org.apache.jackrabbit.core.security.AccessManager;
import org.slf4j.Logger;

public class SimpleJBossAccessManager
implements AccessManager {
    private static Logger log = CommonSLF4JLogger.getLogger(SimpleJBossAccessManager.class);
    protected boolean system = false;
    protected boolean anonymous = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(AMContext context) throws AccessDeniedException, Exception {
        Properties rolemaps = new Properties();
        File rolemap = new File(context.getHomeDir(), "rolemapping.properties");
        log.info("Loading jbossgroup role mappings from {}", (Object)rolemap.getPath());
        try (FileInputStream rolefs = new FileInputStream(rolemap);){
            rolemaps.load(rolefs);
        }
        for (Principal principal : context.getSubject().getPrincipals()) {
            if (!(principal instanceof Group) || !principal.getName().equalsIgnoreCase("Roles")) continue;
            Group group = (Group)principal;
            Enumeration members = group.members();
            while (members.hasMoreElements()) {
                Principal member = (Principal)members.nextElement();
                String role = rolemaps.getProperty(member.getName());
                this.system = this.system || "full".equalsIgnoreCase(role);
                this.anonymous = this.anonymous || "read".equalsIgnoreCase(role);
            }
        }
    }

    @Override
    public synchronized void close() {
    }

    @Override
    public void checkPermission(ItemId id, int permissions) throws AccessDeniedException {
        if (!this.isGranted(id, permissions)) {
            throw new AccessDeniedException("Access denied");
        }
    }

    @Override
    public boolean isGranted(ItemId id, int permissions) {
        return this.system || this.anonymous && (permissions & 6) == 0;
    }

    @Override
    public boolean canAccess(String workspaceName) {
        return this.system || this.anonymous;
    }
}

