/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.state;

import EDU.oswego.cs.dl.util.concurrent.ReadWriteLock;
import EDU.oswego.cs.dl.util.concurrent.ReentrantWriterPreferenceReadWriteLock;
import EDU.oswego.cs.dl.util.concurrent.Sync;
import org.apache.jackrabbit.core.ItemId;
import org.apache.jackrabbit.core.state.ChangeLog;
import org.apache.jackrabbit.core.state.ISMLocking;

public class DefaultISMLocking
implements ISMLocking {
    private boolean noLockHack = false;
    private final ReadWriteLock rwLock = new ReentrantWriterPreferenceReadWriteLock(){

        protected boolean allowReader() {
            return this.activeWriter_ == null || this.activeWriter_ == Thread.currentThread() || DefaultISMLocking.this.noLockHack;
        }
    };

    public void setNoLockHack(boolean noLockHack) {
        this.noLockHack = noLockHack;
    }

    @Override
    public ISMLocking.ReadLock acquireReadLock(ItemId id) throws InterruptedException {
        return new ReadLockImpl(this.rwLock.readLock());
    }

    @Override
    public ISMLocking.WriteLock acquireWriteLock(ChangeLog changeLog) throws InterruptedException {
        return new ISMLocking.WriteLock(){
            {
                DefaultISMLocking.this.rwLock.writeLock().acquire();
            }

            @Override
            public void release() {
                DefaultISMLocking.this.rwLock.writeLock().release();
            }

            @Override
            public ISMLocking.ReadLock downgrade() throws InterruptedException {
                ReadLockImpl rLock = new ReadLockImpl(DefaultISMLocking.this.rwLock.readLock());
                this.release();
                return rLock;
            }
        };
    }

    private static final class ReadLockImpl
    implements ISMLocking.ReadLock {
        private final Sync readLock;

        private ReadLockImpl(Sync readLock) throws InterruptedException {
            this.readLock = readLock;
            this.readLock.acquire();
        }

        @Override
        public void release() {
            this.readLock.release();
        }
    }
}

