/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.state;

import com.kingdee.bos.ctrl.common.util.CommonSLF4JLogger;
import java.io.PrintStream;
import org.apache.jackrabbit.core.ItemId;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.core.state.ItemStateCache;
import org.apache.jackrabbit.core.state.ItemStateCacheFactory;
import org.apache.jackrabbit.core.state.ItemStateReferenceMap;
import org.apache.jackrabbit.core.util.Dumpable;
import org.slf4j.Logger;

public class ItemStateReferenceCache
implements ItemStateCache,
Dumpable {
    private static Logger log = CommonSLF4JLogger.getLogger(ItemStateReferenceCache.class);
    private final ItemStateReferenceMap refs;
    private final ItemStateCache cache;

    public ItemStateReferenceCache(ItemStateCacheFactory cacheFactory) {
        this(cacheFactory.newItemStateCache());
    }

    public ItemStateReferenceCache(ItemStateCache cache) {
        this.cache = cache;
        this.refs = new ItemStateReferenceMap();
    }

    @Override
    public synchronized boolean isCached(ItemId id) {
        return this.refs.contains(id);
    }

    @Override
    public synchronized ItemState retrieve(ItemId id) {
        this.cache.retrieve(id);
        return this.refs.get(id);
    }

    @Override
    public synchronized ItemState[] retrieveAll() {
        return this.refs.values().toArray(new ItemState[this.refs.size()]);
    }

    @Override
    public synchronized void cache(ItemState state) {
        ItemId id = state.getId();
        if (this.refs.contains(id)) {
            log.warn("overwriting cached entry " + id);
        }
        this.cache.cache(state);
        this.refs.put(state);
    }

    @Override
    public synchronized void evict(ItemId id) {
        this.cache.evict(id);
        this.refs.remove(id);
    }

    @Override
    public synchronized void dispose() {
        this.cache.dispose();
    }

    @Override
    public synchronized void evictAll() {
        this.cache.evictAll();
        this.refs.clear();
    }

    @Override
    public synchronized void update(ItemId id) {
        this.cache.update(id);
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.refs.isEmpty();
    }

    @Override
    public synchronized void dump(PrintStream ps) {
        ps.println("ItemStateReferenceCache (" + this + ")");
        ps.println();
        ps.print("[refs] ");
        this.refs.dump(ps);
    }
}

