/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi.commons;

import java.util.Arrays;
import java.util.TreeSet;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.QNodeDefinition;
import org.apache.jackrabbit.spi.commons.QItemDefinitionImpl;

public class QNodeDefinitionImpl
extends QItemDefinitionImpl
implements QNodeDefinition {
    private final Name defaultPrimaryType;
    private final Name[] requiredPrimaryTypes;
    private final boolean allowsSameNameSiblings;

    public QNodeDefinitionImpl(QNodeDefinition nodeDef) {
        this(nodeDef.getName(), nodeDef.getDeclaringNodeType(), nodeDef.isAutoCreated(), nodeDef.isMandatory(), nodeDef.getOnParentVersion(), nodeDef.isProtected(), nodeDef.getDefaultPrimaryType(), nodeDef.getRequiredPrimaryTypes(), nodeDef.allowsSameNameSiblings());
    }

    public QNodeDefinitionImpl(Name name, Name declaringNodeType, boolean isAutoCreated, boolean isMandatory, int onParentVersion, boolean isProtected, Name defaultPrimaryType, Name[] requiredPrimaryTypes, boolean allowsSameNameSiblings) {
        super(name, declaringNodeType, isAutoCreated, isMandatory, onParentVersion, isProtected);
        this.defaultPrimaryType = defaultPrimaryType;
        this.requiredPrimaryTypes = requiredPrimaryTypes;
        this.allowsSameNameSiblings = allowsSameNameSiblings;
    }

    @Override
    public Name getDefaultPrimaryType() {
        return this.defaultPrimaryType;
    }

    @Override
    public Name[] getRequiredPrimaryTypes() {
        return this.requiredPrimaryTypes;
    }

    @Override
    public boolean allowsSameNameSiblings() {
        return this.allowsSameNameSiblings;
    }

    @Override
    public boolean definesNode() {
        return true;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof QNodeDefinition) {
            QNodeDefinition other = (QNodeDefinition)obj;
            return super.equals(obj) && Arrays.equals(this.requiredPrimaryTypes, other.getRequiredPrimaryTypes()) && (this.defaultPrimaryType == null ? other.getDefaultPrimaryType() == null : this.defaultPrimaryType.equals(other.getDefaultPrimaryType())) && this.allowsSameNameSiblings == other.allowsSameNameSiblings();
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (this.hashCode == 0) {
            StringBuffer sb = new StringBuffer();
            if (this.getDeclaringNodeType() != null) {
                sb.append(this.getDeclaringNodeType().toString());
                sb.append('/');
            }
            if (this.definesResidual()) {
                sb.append('*');
            } else {
                sb.append(this.getName().toString());
            }
            sb.append('/');
            TreeSet<Name> set = new TreeSet<Name>();
            Name[] names = this.getRequiredPrimaryTypes();
            for (int i = 0; i < names.length; ++i) {
                set.add(names[i]);
            }
            sb.append(set.toString());
            this.hashCode = sb.toString().hashCode();
        }
        return this.hashCode;
    }
}

