/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.common.io;

import com.kingdee.bos.ctrl.kdf.common.DocInfo;
import com.kingdee.bos.ctrl.kdf.common.Kdf;
import com.kingdee.bos.ctrl.kdf.common.PrintInfo;
import com.kingdee.bos.ctrl.kdf.util.Base64;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kdf.util.style.StyleParser;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import javax.print.attribute.HashPrintRequestAttributeSet;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class Kdf2Xml {
    public static final String SAX_PARSER_NAME = "org.apache.xerces.parsers.SAXParser";
    public static final Namespace NS_COMMON = Namespace.getNamespace((String)"c", (String)"http://www.kingdee.com/Common");
    public static final Namespace NS_XSI = Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance");
    public static final String T_DOC_ROOT = "DocRoot";
    public static final String T_DOC_INFO = "DocInfo";
    public static final String T_AUTHORS = "Authors";
    public static final String T_CREATED = "Created";
    public static final String T_COMPANY = "Company";
    public static final String T_LAST_MODIFIED = "LastModified";
    public static final String T_STYLES = "Styles";
    public static final String T_STYLE = "Style";
    public static final String T_DATA_SOURCES = "DataSources";
    public static final String T_DATA_SOURCE = "DataSource";
    public static final String T_PRINT_INFO = "PrintInfo";
    public static final String T_PAGE_SETUP = "PageSetup";
    public static final String T_PAGE_MARGIN = "PageMargin";
    public static final String A_LEFT = "left";
    public static final String A_RIGHT = "right";
    public static final String A_TOP = "top";
    public static final String A_BOTTOM = "bottom";
    public static final String A_HEADER = "header";
    public static final String A_FOOTER = "footer";
    public static final String T_ORIENTATION = "Orientation";
    public static final String V_PORTRAIT = "portrait";
    public static final String V_LANDSCAPE = "landscape";
    public static final String V_REVERSE_PORTRAIT = "reversePortrait";
    public static final String V_REVERSE_LANDSCAPE = "reverseLandscape";
    public static final String T_PAPER_SIZE_NAME = "PaperSizeName";
    public static final String T_CUSTOMIZE_PAPER_SIZE = "CustomizePaperSize";
    public static final String A_WIDTH = "width";
    public static final String A_HEIGHT = "height";
    public static final String A_UNIT = "unit";
    public static final String V_MM = "mm";
    public static final String V_INCH = "inch";
    public static final String T_PRINTER_SETUP = "PrinterSetup";
    public static final String T_HEADERS = "Headers";
    public static final String T_HEADER = "Header";
    public static final String T_FOOTERS = "Footers";
    public static final String T_FOOTER = "Footer";
    public static final String A_VERSION = "version";
    public static final String A_ID = "id";

    public static Element makeDocRoot(Kdf kdf) {
        Element xml = new Element(T_DOC_ROOT);
        xml.addNamespaceDeclaration(NS_XSI);
        xml.addNamespaceDeclaration(NS_COMMON);
        xml.addContent((Content)Kdf2Xml.makeDocInfo(kdf.getDocInfo()));
        xml.addContent((Content)Kdf2Xml.makeStyles(kdf.getStyles()));
        xml.addContent((Content)Kdf2Xml.makeDataSources(kdf.getDataSources()));
        xml.addContent((Content)Kdf2Xml.makePrintInfo(kdf.getPrintInfo()));
        return xml;
    }

    public static Element makeStyles(Map obj) {
        Element xml = new Element(T_STYLES);
        StyleParser.writeStyles((Element)xml, (Namespace)NS_COMMON, obj.entrySet().iterator());
        return xml;
    }

    public static Element makeStyle(Style obj) {
        return null;
    }

    public static Element makeDocInfo(DocInfo docInfo) {
        Element elm;
        Element xml = new Element(T_DOC_INFO);
        String s = docInfo.getAuthors();
        if (s != null) {
            elm = new Element(T_AUTHORS, NS_COMMON);
            elm.setText(s);
            xml.addContent((Content)elm);
        }
        if ((s = docInfo.getCompany()) != null) {
            elm = new Element(T_COMPANY, NS_COMMON);
            elm.setText(s);
            xml.addContent((Content)elm);
        }
        if ((s = docInfo.getCreated()) != null) {
            elm = new Element(T_CREATED, NS_COMMON);
            elm.setText(s);
            xml.addContent((Content)elm);
        }
        if ((s = docInfo.getLastModified()) != null) {
            elm = new Element(T_LAST_MODIFIED, NS_COMMON);
            elm.setText(s);
            xml.addContent((Content)elm);
        }
        return xml;
    }

    public static Element makeDataSources(Map obj) {
        Element xml = new Element(T_DATA_SOURCES);
        Iterator itr = obj.entrySet().iterator();
        while (itr.hasNext()) {
            xml.addContent((Content)Kdf2Xml.makeDataSource(itr.next()));
        }
        return xml;
    }

    public static Element makeDataSource(Object obj) {
        Element elm = new Element(T_DATA_SOURCE);
        elm.setAttribute(A_ID, "");
        return elm;
    }

    public static Element makePrintInfo(PrintInfo printInfo) {
        Element xml = new Element(T_PRINT_INFO);
        Element xmlPS = new Element(T_PAGE_SETUP, NS_COMMON);
        xml.addContent((Content)xmlPS);
        Element xmlPM = new Element(T_PAGE_MARGIN, NS_COMMON);
        xmlPM.setAttribute(A_LEFT, Integer.toString(printInfo.getMarginLeft()));
        xmlPM.setAttribute(A_RIGHT, Integer.toString(printInfo.getMarginRight()));
        xmlPM.setAttribute(A_TOP, Integer.toString(printInfo.getMarginTop()));
        xmlPM.setAttribute(A_BOTTOM, Integer.toString(printInfo.getMarginBottom()));
        xmlPS.addContent((Content)xmlPM);
        Element xmlOrn = new Element(T_ORIENTATION, NS_COMMON);
        xmlOrn.setText(printInfo.getOrientation());
        xmlPS.addContent((Content)xmlOrn);
        String s = printInfo.getPaperSizeName();
        if (s == null) {
            Element xmlCPS = new Element(T_CUSTOMIZE_PAPER_SIZE, NS_COMMON);
            xmlPM.setAttribute(A_WIDTH, Integer.toString(printInfo.getCustomizePaperWidth()));
            xmlPM.setAttribute(A_HEIGHT, Integer.toString(printInfo.getCustomizePaperHeight()));
            xmlPS.addContent((Content)xmlCPS);
        } else {
            Element xmlPSN = new Element(T_PAPER_SIZE_NAME, NS_COMMON);
            xmlPSN.setText(printInfo.getPaperSizeName());
            xmlPS.addContent((Content)xmlPSN);
        }
        HashPrintRequestAttributeSet pras = printInfo.getPrinterSetup();
        if (pras != null) {
            Element xmlPRT = new Element(T_PAPER_SIZE_NAME, NS_COMMON);
            xmlPRT.setText(Base64.encodeObject((Serializable)pras));
            xml.addContent((Content)xmlPRT);
        }
        return xml;
    }
}

