/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.data.config;

import com.kingdee.bos.ctrl.kdf.util.CloseUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.xml.sax.InputSource;

public final class BOSConfig {
    private File configFile;
    private Document doc;
    private Element root;
    private HashMap infoMap;
    private BOSInfo[] bosis;

    public BOSConfig(String fileName) {
        this.configFile = new File(fileName);
        if (!this.configFile.exists()) {
            throw new RuntimeException("Can not find config file: " + fileName);
        }
        this.loadFile();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadFile() {
        FileInputStream fis = null;
        try {
            SAXBuilder builder = new SAXBuilder("org.apache.xerces.parsers.SAXParser");
            fis = new FileInputStream(this.configFile);
            this.doc = builder.build(new InputSource(fis));
        }
        catch (JDOMException err) {
            try {
                throw new RuntimeException("Error on analysis XML file, info: " + err.getMessage());
                catch (IOException err2) {
                    throw new RuntimeException("Failed loading File");
                }
            }
            catch (Throwable throwable) {
                CloseUtil.close((Closeable[])new Closeable[]{fis});
                throw throwable;
            }
        }
        CloseUtil.close((Closeable[])new Closeable[]{fis});
        this.root = this.doc.getRootElement();
        this.infoMap = new HashMap();
        List bosconns = this.root.getChildren("BOSConnection");
        int i = 0;
        while (i < bosconns.size()) {
            Element ele = (Element)bosconns.get(i);
            BOSInfo bosi = new BOSInfo();
            bosi.id = ele.getAttributeValue("id");
            bosi.solution = ele.getChildText("Solution");
            bosi.ais = ele.getChildText("AIS");
            bosi.locale = ele.getChildText("Locale");
            bosi.user = ele.getChildText("User");
            bosi.pwd = ele.getChildText("Password");
            bosi.url = ele.getChildText("URL");
            this.infoMap.put(bosi.id, bosi);
            ++i;
        }
        return;
    }

    public BOSInfo getBOSInfo(String id) {
        return (BOSInfo)this.infoMap.get(id);
    }

    public BOSInfo getBOSInfo(int idx) {
        if (this.bosis == null) {
            this.bosis = this.infoMap.values().toArray(new BOSInfo[0]);
        }
        if (idx < 0 || idx >= this.bosis.length) {
            return null;
        }
        return this.bosis[idx];
    }

    public int getBOSInfoSize() {
        return this.infoMap.size();
    }

    public static final class BOSInfo {
        public String id;
        public String user;
        public String pwd;
        public String solution;
        public String ais;
        public String locale;
        public String url;
    }
}

