/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.data.datasource;

import com.kingdee.bos.ctrl.kdf.data.datasource.DataSource;
import com.kingdee.bos.ctrl.kdf.util.file.KDFXmlReader;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Element;

public final class BOSQueryDataSource
extends DataSource {
    private String source;
    private int type = 1;
    private String name;
    private String packageName;
    private String connectionID;
    private boolean linked = false;
    public static final int TYPE_ENTITY = 0;
    public static final int TYPE_QUERY = 1;

    public BOSQueryDataSource() {
    }

    public BOSQueryDataSource(String id, String pkName, String name) {
        super(id);
        this.packageName = pkName;
        this.name = name;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getConnectionID() {
        return this.connectionID;
    }

    public void setConnectionID(String connectionID) {
        this.connectionID = connectionID;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public void setSource(String source) {
        this.source = source;
    }

    @Override
    public boolean isLinked() {
        return this.linked;
    }

    public void setLinked(boolean linked) {
        this.linked = linked;
    }

    @Override
    public Object readFromNode(Element ele) {
        Element eleEntity;
        String src;
        this.setID(ele.getAttributeValue("id").trim());
        this.setUri(ele.getAttributeValue("uri"));
        Element dsn = ele.getChild("DesignedDataSource", ele.getNamespace());
        if (dsn != null) {
            this.setUserObject(dsn.clone());
        }
        Element eleSource = ele.getChild("BosQueryDataSource", ele.getNamespace());
        this.connectionID = eleSource.getAttributeValue("connection");
        String type = eleSource.getAttributeValue("type");
        if (type != null) {
            if (type.equalsIgnoreCase("entity")) {
                this.type = 0;
            } else if (type.equalsIgnoreCase("query")) {
                this.type = 1;
            }
        }
        if ((src = (eleEntity = eleSource.getChild("QueryXmlSource", ele.getNamespace())).getAttributeValue("src")) != null && src.trim().length() > 0) {
            this.linked = true;
            this.setSource(src);
        } else {
            this.setSource(KDFXmlReader.readNodeContentSource(eleEntity));
        }
        this.name = eleEntity.getAttributeValue("name");
        this.packageName = eleEntity.getAttributeValue("package");
        this.setParams(this.resolveParamsNode(eleSource));
        return this;
    }

    @Override
    public Element writeToNode() {
        Element eleDS = this.createDSNode();
        eleDS.setAttribute("id", this.getID());
        if (this.getUri() != null) {
            eleDS.setAttribute("uri", this.getUri());
        }
        Element eleSource = new Element("BosQueryDataSource", eleDS.getNamespace());
        if (this.connectionID != null) {
            eleSource.setAttribute("connection", this.connectionID);
        }
        switch (this.type) {
            case 0: {
                eleSource.setAttribute("type", "entity");
                break;
            }
            case 1: {
                eleSource.setAttribute("type", "query");
                break;
            }
        }
        eleDS.addContent((Content)eleSource);
        if (this.getUserObject() instanceof Element) {
            eleDS.addContent((Content)((Element)this.getUserObject()));
        }
        Element eleEntity = new Element("QueryXmlSource", eleSource.getNamespace());
        if (this.isLinked()) {
            eleEntity.setAttribute("src", this.source);
        } else {
            eleEntity.setText(this.source);
        }
        eleEntity.setAttribute("name", this.name);
        eleEntity.setAttribute("package", this.packageName);
        eleSource.addContent((Content)eleEntity);
        eleSource.addContent((Content)this.buildParamsNode(eleSource.getNamespace()));
        return eleDS;
    }

    public void setSortFields(List sorts) {
        this._sorts = sorts;
    }
}

