/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.data.pool;

import com.kingdee.bos.ctrl.kdf.data.exception.BlockIsBusyException;
import com.kingdee.bos.ctrl.kdf.data.exception.BlockIsExistsException;
import com.kingdee.bos.ctrl.kdf.data.exception.BlockNotFoundException;
import com.kingdee.bos.ctrl.kdf.data.exception.TaskInvalidException;
import com.kingdee.bos.ctrl.kdf.data.exception.TaskNotFoundException;
import com.kingdee.bos.ctrl.kdf.data.pool.Block;
import com.kingdee.bos.ctrl.kdf.data.pool.Cache;
import com.kingdee.bos.ctrl.kdf.data.pool.DataPoolProperties;
import com.kingdee.bos.ctrl.kdf.data.pool.IOCache;
import com.kingdee.bos.ctrl.kdf.data.pool.Task;
import com.kingdee.bos.ctrl.kdf.data.pool.TaskTrack;
import java.util.Iterator;

public class CacheManager {
    private Cache cache;
    private TaskTrack track = TaskTrack.getInstance();
    private DataPoolProperties prop = DataPoolProperties.getInstance();

    public CacheManager() {
        this.cache = new IOCache();
    }

    public int newTask(int validTime) {
        int taskID = this.track.newTask(validTime);
        this.cache.addTask(taskID);
        return taskID;
    }

    public int newTask() {
        int taskID = this.track.newTask(this.prop.getValidTime());
        this.cache.addTask(taskID);
        return taskID;
    }

    public void writeBlock(int taskID, int blockID, byte[] block) throws BlockIsExistsException, TaskInvalidException {
        Task task = this.track.getTask(taskID);
        if (task.getValidTime() < 0 || task.getActiveTime() + (long)(task.getValidTime() * 1000) > System.currentTimeMillis()) {
            Block b = task.getBlock(blockID);
            if (b == null) {
                task.addBlock(blockID);
                task.setActiveTime(System.currentTimeMillis());
                this.cache.addBlock(taskID, blockID, block);
            } else if (!b.getDeleteTag()) {
                throw new BlockIsExistsException();
            }
        } else {
            throw new TaskInvalidException();
        }
    }

    public byte[] readBlock(int taskID, int blockID) throws BlockNotFoundException, TaskInvalidException, TaskNotFoundException, BlockIsBusyException {
        Block b;
        byte[] block = new byte[]{};
        Task task = this.track.getTask(taskID);
        if (task == null) {
            throw new TaskNotFoundException();
        }
        if (task.getValidTime() < 0 || task.getActiveTime() + (long)(task.getValidTime() * 1000) > System.currentTimeMillis()) {
            b = task.getBlock(blockID);
            if (b == null || b.getDeleteTag()) {
                throw new BlockNotFoundException();
            }
            if (!b.canAccess()) {
                throw new BlockIsBusyException();
            }
        } else {
            throw new TaskInvalidException();
        }
        b.readLocked();
        block = this.cache.getBlock(taskID, blockID);
        b.readUnlocked();
        return block;
    }

    public byte[][] readBlock(int taskID) throws TaskInvalidException, TaskNotFoundException {
        Iterator iter = this.track.getTask(taskID).Iterator();
        int size = this.track.getTask(taskID).size();
        byte[][] block = new byte[size][];
        int i = 0;
        while (iter.hasNext()) {
            int blockID = ((Block)iter.next()).getBlockID();
            try {
                block[i] = this.readBlock(taskID, blockID);
            }
            catch (BlockNotFoundException e) {
                e.printStackTrace();
            }
            catch (BlockIsBusyException e) {
                e.printStackTrace();
            }
            ++i;
        }
        return block;
    }

    public void delete(int taskID) {
        this.track.clear(taskID);
    }

    public void delete(int taskID, int blockID) {
        this.track.remove(taskID, blockID);
    }

    public void delete() {
        this.track.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void clear() {
        Iterator iter;
        Iterator iterator = iter = this.track.Iterator();
        synchronized (iterator) {
            while (iter.hasNext()) {
                Task task = (Task)iter.next();
                if (!task.canRemove()) continue;
                this.cache.removeTask(task.getTaskID());
                task.remove();
            }
        }
    }
}

