/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.data.query;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.data.query.IDataTable;
import com.kingdee.bos.ctrl.kdf.data.query.QueryColumn;
import com.kingdee.bos.ctrl.kdf.data.query.QueryElement;
import com.kingdee.bos.ctrl.kdf.util.Tools;
import java.util.LinkedList;
import java.util.List;
import org.jdom2.Element;

public abstract class KDBasicQuery
extends QueryElement
implements IDataTable,
Cloneable {
    public static final int QUERY_TYPE_BOS = 0;
    public static final int QUERY_TYPE_DATABASE = 1;
    public static final int QUERY_TYPE_CSV = 2;
    public static final int QUERY_TYPE_XML = 3;
    public static final int QUERY_TYPE_OBJECT = 4;
    private LinkedList columnList;
    private int queryType;

    protected KDBasicQuery(String id, String name, int queryType) {
        this.ID = id;
        this.name = name;
        this.queryType = queryType;
    }

    @Override
    public List getColumns() {
        return this.getColumnList();
    }

    public Element getXmlNode() {
        return null;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof KDBasicQuery) {
            KDBasicQuery query = (KDBasicQuery)obj;
            if (!(this.getName() != null ? this.getName().equals(query.getName()) : query.getName() == null)) {
                return false;
            }
            if (this.getQueryType() != query.getQueryType()) {
                return false;
            }
            if (!(this.getComment() != null ? this.getComment().equals(query.getComment()) : query.getComment() == null)) {
                return false;
            }
            return this.getColumnList() != null ? this.getColumnList().equals(query.getColumnList()) : query.getColumnList() == null;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int[] seeds = new int[]{this.ID == null ? 0 : this.ID.hashCode(), this.comment == null ? 0 : this.comment.hashCode(), this.name == null ? 0 : this.name.hashCode(), this.columnList == null ? 0 : this.columnList.hashCode(), this.queryType};
        return Tools.hashCalculate((int[])seeds);
    }

    public LinkedList getColumnList() {
        if (this.columnList == null) {
            this.columnList = new LinkedList();
        }
        return this.columnList;
    }

    public void setColumnList(LinkedList columnList) {
        this.columnList = columnList;
    }

    public int getQueryType() {
        return this.queryType;
    }

    @Override
    public String toString() {
        if (StringUtil.isEmptyString((String)this.getName())) {
            return this.getID();
        }
        return this.getName();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        KDBasicQuery kdBasicQuery = (KDBasicQuery)super.clone();
        kdBasicQuery.columnList = this.columnList != null ? (LinkedList)this.columnList.clone() : null;
        return kdBasicQuery;
    }

    public void setQueryType(int queryType) {
        this.queryType = queryType;
    }

    public QueryColumn getColumnByName(String name) {
        for (Object oQry : this.getColumnList()) {
            QueryColumn qry;
            if (!(oQry instanceof QueryColumn) || !StringUtil.equals((String)(qry = (QueryColumn)oQry).getName(), (String)name)) continue;
            return qry;
        }
        return null;
    }

    public QueryColumn getColumnByID(String programID) {
        for (Object oQry : this.getColumnList()) {
            QueryColumn qry;
            if (!(oQry instanceof QueryColumn) || !StringUtil.equals((String)(qry = (QueryColumn)oQry).getProgramID(), (String)programID)) continue;
            return qry;
        }
        return null;
    }
}

