/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.excel.wrapper;

import com.kingdee.bos.ctrl.excel.model.struct.validate.util.Validate;
import java.util.HashMap;
import java.util.Map;

public class CompareOnOperatorMapping {
    private static final Map<String, String> QUALIFIER_TO_OPERATOR = new HashMap<String, String>();
    private static final Map<String, String> OPERATOR_TO_QUALIFIER = new HashMap<String, String>();
    private static final int[] spread2ExcelIntMapping = new int[]{0, 1, 2, 4, 5, 6, 3, 7};
    private static final int[] excel2SpreadIntMapping = new int[]{0, 1, 2, 6, 3, 4, 5, 7};
    private static final String[] EXCEL_OPERATORS = new String[]{"notBetween", "between", "equal", "notEqual", "greaterThan", "lessThan", "greaterThanOrEqual", "lessThanOrEqual"};

    private CompareOnOperatorMapping() {
    }

    public static final int getSpread2ExcelIntMapping(int spreadValidateTypeIndex) {
        if (spreadValidateTypeIndex < 0 || spreadValidateTypeIndex > 7) {
            return 7;
        }
        return spread2ExcelIntMapping[spreadValidateTypeIndex];
    }

    public static final int getExcel2SpreadIntMapping(int excelValidateTypeIndex) {
        if (excelValidateTypeIndex < 0 || excelValidateTypeIndex > 7) {
            return 7;
        }
        return excel2SpreadIntMapping[excelValidateTypeIndex];
    }

    public static final String getExcelOperator(String qualifier) {
        return QUALIFIER_TO_OPERATOR.get(qualifier);
    }

    public static final String getQualifier(String excelOperator) {
        return OPERATOR_TO_QUALIFIER.get(excelOperator);
    }

    static {
        QUALIFIER_TO_OPERATOR.put(Validate.NotBetween, EXCEL_OPERATORS[0]);
        QUALIFIER_TO_OPERATOR.put(Validate.Between, EXCEL_OPERATORS[1]);
        QUALIFIER_TO_OPERATOR.put(Validate.Equal, EXCEL_OPERATORS[2]);
        QUALIFIER_TO_OPERATOR.put(Validate.NotEqual, EXCEL_OPERATORS[3]);
        QUALIFIER_TO_OPERATOR.put(Validate.Greater, EXCEL_OPERATORS[4]);
        QUALIFIER_TO_OPERATOR.put(Validate.Less, EXCEL_OPERATORS[5]);
        QUALIFIER_TO_OPERATOR.put(Validate.GreaterOrEqual, EXCEL_OPERATORS[6]);
        QUALIFIER_TO_OPERATOR.put(Validate.LessOrEqual, EXCEL_OPERATORS[7]);
        OPERATOR_TO_QUALIFIER.put(EXCEL_OPERATORS[0], Validate.NotBetween);
        OPERATOR_TO_QUALIFIER.put(EXCEL_OPERATORS[1], Validate.Between);
        OPERATOR_TO_QUALIFIER.put(EXCEL_OPERATORS[2], Validate.Equal);
        OPERATOR_TO_QUALIFIER.put(EXCEL_OPERATORS[3], Validate.NotEqual);
        OPERATOR_TO_QUALIFIER.put(EXCEL_OPERATORS[4], Validate.Greater);
        OPERATOR_TO_QUALIFIER.put(EXCEL_OPERATORS[5], Validate.Less);
        OPERATOR_TO_QUALIFIER.put(EXCEL_OPERATORS[6], Validate.GreaterOrEqual);
        OPERATOR_TO_QUALIFIER.put(EXCEL_OPERATORS[7], Validate.LessOrEqual);
    }
}

