/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.excel.wrapper;

import com.kingdee.bos.ctrl.common.hyperlink.HyperLink;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.util.UnitConverter;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Comment;
import com.kingdee.bos.ctrl.excel.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.excel.model.struct.cformat.ConditionalFormat;
import com.kingdee.bos.ctrl.excel.model.struct.cformat.ConditionalFormatList;
import com.kingdee.bos.ctrl.excel.model.struct.cformat.util.Condition;
import com.kingdee.bos.ctrl.excel.model.struct.validate.Validation;
import com.kingdee.bos.ctrl.excel.model.struct.validate.ValidationList;
import com.kingdee.bos.ctrl.excel.model.struct.validate.util.MessagedValidate;
import com.kingdee.bos.ctrl.excel.model.util.SortedCellBlockArray;
import com.kingdee.bos.ctrl.kdf.excel.AbstractDataWrapper;
import com.kingdee.bos.ctrl.kdf.excel.ExportUtils;
import com.kingdee.bos.ctrl.kdf.excel.MultiPartMergeData;
import com.kingdee.bos.ctrl.kdf.excel.ui.EventQueue;
import com.kingdee.bos.ctrl.kdf.excel.ui.ExportEvent;
import com.kingdee.bos.ctrl.kdf.excel.wrapper.CompareOnOperatorMapping;
import com.kingdee.bos.ctrl.kdf.excel.wrapper.IExportWrapper;
import com.kingdee.bos.ctrl.kdf.util.ColorUtil;
import com.kingdee.bos.ctrl.kdf.util.style.LineStyle;
import com.kingdee.bos.ctrl.kdf.util.style.Pattern;
import com.kingdee.bos.ctrl.kdf.util.style.PenStyle;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.StyleUtil;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.kdf.util.style.styledesigner.DigitFormatPane;
import com.kingdee.bos.util.backport.Collections;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.common.usermodel.HyperlinkType;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.ConditionalFormattingRule;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.streaming.SXSSFDrawing;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFConditionalFormattingRule;
import org.apache.poi.xssf.usermodel.XSSFDataValidationConstraint;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFFontFormatting;
import org.apache.poi.xssf.usermodel.XSSFHyperlink;
import org.apache.poi.xssf.usermodel.XSSFPatternFormatting;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFSheetConditionalFormatting;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTWorksheet;

public class SXSSFExportWrapper
implements IExportWrapper {
    private AbstractDataWrapper dataSource;
    private SXSSFWorkbook workbook;
    private Sheet currentSheet;
    private boolean notify = true;
    private EventQueue queue;
    private CellStyle dateStyle;
    private CellStyle dateTimeStyle;
    private CellStyle emptyStyle;
    private DataFormat format;
    private short textFormat;
    private XSSFCellStyle textStyle;
    private HashMap<Integer, Object> stylesMap;
    private HashMap<Integer, XSSFCellStyle> textFormatStylesMap;
    private HashMap<Integer, Object> fontsMap;
    private MultiPartMergeData mutiPartMergeData;
    private List<AbstractDataWrapper.MergeBlock> headMergeData;
    private static int DEFAULT_KEEP_ROWS = 500;
    private long startTimeAll;

    public SXSSFExportWrapper(AbstractDataWrapper dataSource) {
        this.dataSource = dataSource;
        this.workbook = new SXSSFWorkbook(DEFAULT_KEEP_ROWS);
        this.emptyStyle = this.workbook.createCellStyle();
        this.format = this.workbook.createDataFormat();
        this.textStyle = (XSSFCellStyle)this.workbook.createCellStyle();
        this.textStyle.setDataFormat(this.textFormat);
        this.textFormat = this.format.getFormat("TEXT");
        this.stylesMap = new HashMap();
        this.textFormatStylesMap = new HashMap();
        this.fontsMap = new HashMap();
        this.mutiPartMergeData = MultiPartMergeData.getData();
        this.headMergeData = new ArrayList<AbstractDataWrapper.MergeBlock>();
    }

    public void setNOTIFY(boolean nOTIFY) {
        this.notify = nOTIFY;
    }

    @Override
    public boolean write(String filePath) {
        block3: {
            try {
                FileOutputStream out = new FileOutputStream(filePath);
                boolean flag = this.write(out);
                if (flag && this.queue != null && this.notify) {
                    this.queue.complete(new ExportEvent("export workbook", "(" + (System.currentTimeMillis() - this.startTimeAll) + " ms consumed)!"));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (this.queue == null || !this.notify) break block3;
                this.queue.complete(new ExportEvent(ExportEvent.STEP_NAME_ERROR, "exception occur:" + e.getMessage()));
            }
        }
        return false;
    }

    public boolean write(OutputStream out) throws Exception {
        boolean flag = false;
        this.startTimeAll = System.currentTimeMillis();
        try {
            if (this.queue != null && this.notify) {
                this.queue.enQueue(new ExportEvent("export workbook", "add embedObjects"));
            }
            this.dataSource.configSourceRepaint(false);
            int leftActiveSheetHideNum = 0;
            int allHideNum = 0;
            for (int i = 0; i < this.dataSource.getSheetCount(); ++i) {
                String sheetName = this.dataSource.sheetName(i);
                if (StringUtil.isEmptyString((String)sheetName)) {
                    if (i < this.dataSource.getActiveSheetIndex()) {
                        ++leftActiveSheetHideNum;
                    }
                    ++allHideNum;
                    continue;
                }
                this.dataSource.setCurrentSheetIndex(i);
                this.currentSheet = this.workbook.createSheet(sheetName);
                this.workbook.setSheetHidden(i - allHideNum, this.dataSource.isHideSheet(i));
                this.fillSheet(this.currentSheet);
                this.addProtection(this.currentSheet);
                this.addAutoFilter(this.currentSheet);
                this.addDataValidations(this.currentSheet);
                this.addConditionalFormat(this.currentSheet);
                this.addFreezeLine(this.currentSheet);
                this.addPrintSetup(this.currentSheet);
                this.addPrintArea(this.currentSheet);
                this.addEmbed(this.currentSheet);
                this.addGridLine(this.currentSheet);
                this.addGroupInfo(this.currentSheet);
                this.setSheetView(this.currentSheet);
                this.addMergeBlock2Sheet(this.currentSheet);
            }
            this.workbook.setActiveSheet(this.dataSource.getActiveSheetIndex() - leftActiveSheetHideNum);
            this.workbook.setSelectedTab(this.dataSource.getActiveSheetIndex() - leftActiveSheetHideNum);
            this.workbook.write(out);
            out.flush();
            flag = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (null != this.workbook) {
                try {
                    this.workbook.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (null != out) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            this.dataSource.configSourceRepaint(true);
        }
        return flag;
    }

    private void fillSheet(Sheet currentSheet) throws IOException {
        int rowNum = 0;
        int excelRowNum = 0;
        int rowIndex = 0;
        boolean isMergeHeadRowsExport = this.dataSource.isMergeHeadRowsExport();
        while (!this.dataSource.isRowEnd(rowNum)) {
            if (this.dataSource.isHideRow(rowNum) || this.dataSource.isExportHeadRow(rowNum) && rowNum < this.dataSource.getHeadNumber() && rowNum > 0 && isMergeHeadRowsExport) {
                ++rowNum;
                continue;
            }
            if (excelRowNum > 1048575) {
                throw new IllegalArgumentException("too much rows!");
            }
            Row row = currentSheet.createRow(rowIndex++);
            if (this.dataSource.hasGroupInfo()) {
                this.dataSource.addGroupRow(currentSheet, row, rowNum);
            } else if (this.dataSource.rowHeightAt(rowNum) != 20) {
                row.setHeight((short)(StyleUtil.lomToPt((double)((float)UnitConverter.px2mm((int)this.dataSource.rowHeightAt(rowNum)) * 10.0f)) * 20.0));
            }
            this.fillRow(row, rowNum, excelRowNum);
            ++excelRowNum;
            ++rowNum;
        }
        this.headMergeData.clear();
    }

    private void fillRow(Row row, int rowNum, int excelRowNum) throws IOException {
        if (this.queue != null && this.notify) {
            ExportEvent event = new ExportEvent("export sheet(" + this.getSheetName() + ")", "filling data(" + excelRowNum + ")");
            event.setRow(rowNum);
            this.queue.enQueue(event);
        }
        int colNum = 0;
        int excelColNum = 0;
        int cellIndex = 0;
        boolean isMergeHeadRowsExport = this.dataSource.isMergeHeadRowsExport();
        while (!this.dataSource.isColEnd(colNum)) {
            AbstractDataWrapper.MergeBlock merge;
            int valueType;
            Object value;
            if (this.dataSource.isExportHeadRow(rowNum) && rowNum == 0 && isMergeHeadRowsExport) {
                for (int n = 0; n < this.dataSource.getHeadNumber(); ++n) {
                    this.addHeadMergerData(rowNum + n, colNum);
                }
                StringBuilder builder = new StringBuilder();
                AbstractDataWrapper.MergeBlock last = null;
                for (int m = 0; m < this.dataSource.getHeadNumber(); ++m) {
                    Object k;
                    boolean match = false;
                    for (int d = this.headMergeData.size() - 1; d >= 0; --d) {
                        AbstractDataWrapper.MergeBlock b = this.headMergeData.get(d);
                        if (!b.contains(m, colNum) || last == b) continue;
                        builder.append(b.getGroup());
                        match = true;
                        last = b;
                    }
                    if (match || null == (k = this.dataSource.valueAt(m, colNum))) continue;
                    builder.append(k.toString());
                }
                value = builder.toString();
                valueType = 1;
            } else {
                value = this.dataSource.valueAt(rowNum, colNum);
                valueType = this.dataSource.valueTypeAt(rowNum, colNum);
            }
            String formula = this.dataSource.formulaAt(rowNum, colNum);
            boolean isZero = this.dataSource.isZero(rowNum, colNum);
            if (excelColNum > 16383) {
                throw new IOException("too much columns!");
            }
            if (this.dataSource.isExportHeadRow(excelRowNum)) {
                merge = null;
                if (!isMergeHeadRowsExport && null != (merge = this.dataSource.getMergeBlock(rowNum, colNum))) {
                    merge = this.dataSource.getExcelMergeBlock(excelRowNum, excelColNum, merge);
                    this.mutiPartMergeData.merge(merge);
                }
            } else if (this.dataSource.isExportMergeBlocks() && !this.dataSource.isExportRPT() && this.dataSource.isGroupCol(colNum) && this.dataSource.isMergeCol(colNum) && this.mutiPartMergeData.merge(AbstractDataWrapper.getMergeBlock(excelRowNum, excelColNum, excelRowNum, excelColNum, colNum, colNum, null == value ? "" : value.toString()))) {
                value = null;
            }
            if (this.dataSource.isHideCol(colNum)) {
                ++colNum;
                continue;
            }
            if (this.dataSource.isExportMergeBlocks() && this.dataSource.isExportRPT()) {
                merge = this.dataSource.getMergeBlock(rowNum, colNum);
                this.mutiPartMergeData.addBlock(this.dataSource.getExcelMergeBlock(excelRowNum, excelColNum, merge));
            }
            org.apache.poi.ss.usermodel.Cell cell = row.createCell(cellIndex++);
            switch (valueType) {
                case 3: {
                    break;
                }
                case 4: {
                    if (value instanceof Boolean) {
                        value = this.dataSource.booleanValue((Boolean)value);
                    }
                    cell.setCellValue((String)value);
                    break;
                }
                case 2: {
                    if (!StringUtil.isEmptyString((String)formula) && formula.charAt(0) == '=') {
                        formula = formula.substring(1, formula.length());
                    }
                    try {
                        boolean emptyFormula = StringUtil.isEmptyString((String)formula);
                        if (!emptyFormula) {
                            cell.setCellFormula(formula);
                        }
                        if (isZero) {
                            value = BigDecimal.ZERO;
                        }
                        if (value instanceof Number) {
                            cell.setCellValue(((Number)value).doubleValue());
                            if (!emptyFormula) break;
                            cell.setCellType(CellType.NUMERIC);
                            break;
                        }
                        if (value instanceof String) {
                            if (StringUtil.isExcelNumber((String)((String)value)) && ((String)value).charAt(0) != '0') {
                                try {
                                    cell.setCellValue(Double.parseDouble((String)value));
                                    if (!emptyFormula) break;
                                    cell.setCellType(CellType.NUMERIC);
                                }
                                catch (NumberFormatException nfe) {
                                    if (StringUtil.isEmptyString((String)((String)value))) {
                                        cell.setCellValue((String)null);
                                        if (!emptyFormula) break;
                                        cell.setCellType(CellType.BLANK);
                                        break;
                                    }
                                    if (!emptyFormula) break;
                                    cell.setCellValue((String)value);
                                    cell.setCellType(CellType.STRING);
                                }
                                break;
                            }
                            if (!emptyFormula) break;
                            cell.setCellValue((String)value);
                            cell.setCellType(CellType.STRING);
                            break;
                        }
                        if (value instanceof Date) {
                            cell.setCellValue((Date)value);
                            valueType = 6;
                            break;
                        }
                        if (value instanceof Calendar) {
                            cell.setCellValue((Calendar)value);
                            valueType = 6;
                            break;
                        }
                        if (!emptyFormula) break;
                        cell.setCellValue(value == null ? "" : value.toString());
                    }
                    catch (RuntimeException ex) {
                        if (value == null) {
                            value = new BigDecimal(0.0);
                        }
                        if (value instanceof Number) {
                            cell.setCellValue(((Number)value).doubleValue());
                            cell.setCellType(CellType.NUMERIC);
                            break;
                        }
                        if (value instanceof String) {
                            cell.setCellValue((String)value);
                        } else {
                            cell.setCellValue(value.toString());
                        }
                        cell.setCellType(CellType.STRING);
                    }
                    break;
                }
                case 0: {
                    if (value instanceof Number) {
                        cell.setCellValue(Double.valueOf(value.toString()).doubleValue());
                        break;
                    }
                    if (value instanceof Date) {
                        cell.setCellValue((Date)value);
                        valueType = 6;
                        break;
                    }
                    if (value instanceof Calendar) {
                        Calendar calendar = (Calendar)value;
                        GregorianCalendar newCalendar = new GregorianCalendar(1900, 0, 1);
                        if (calendar.before(newCalendar)) {
                            cell.setCellValue(calendar.getTime().toLocaleString());
                            cell.setCellType(CellType.STRING);
                            break;
                        }
                        cell.setCellValue((Calendar)value);
                        valueType = 6;
                        break;
                    }
                    if (!(value instanceof String) || StringUtil.isEmptyString((String)((String)value))) break;
                    cell.setCellValue(value.toString());
                    cell.setCellType(CellType.STRING);
                    break;
                }
                case 1: {
                    if (value == null) break;
                    String str = value.toString();
                    if (StringUtil.isEmptyString((String)str)) {
                        cell.setCellValue("");
                        cell.setCellType(CellType.STRING);
                        break;
                    }
                    cell.setCellValue(str);
                    cell.setCellType(CellType.STRING);
                    break;
                }
                case 7: {
                    valueType = 1;
                    cell.setCellValue((String)value);
                    cell.setCellType(CellType.STRING);
                    break;
                }
                case 5: {
                    if (value == null) {
                        value = "error";
                    }
                    cell.setCellValue(value.toString());
                    break;
                }
                default: {
                    cell.setCellValue("");
                    cell.setCellType(CellType.STRING);
                }
            }
            if (row.getRowNum() == 0 && !this.dataSource.hasGroupInfo()) {
                int columnWidth = Math.min(this.dataSource.colWidthAt(colNum) / 8, 255);
                this.currentSheet.setColumnWidth(excelColNum, columnWidth * 256);
            }
            this.addStyle(rowNum, colNum, (short)valueType, cell, value, !StringUtil.isEmptyString((String)formula));
            this.addHyperLink(rowNum, colNum, cell);
            this.addAnnotate(rowNum, colNum, cell);
            ++excelColNum;
            ++colNum;
        }
    }

    private void addMergeBlock2Sheet(Sheet currentSheet) {
        Map<String, List<AbstractDataWrapper.MergeBlock>> map = this.mutiPartMergeData.getBlockMap();
        for (Map.Entry<String, List<AbstractDataWrapper.MergeBlock>> entry : map.entrySet()) {
            List<AbstractDataWrapper.MergeBlock> list = entry.getValue();
            for (AbstractDataWrapper.MergeBlock b : list) {
                if (this.dataSource.isHideCol(b.getGpCol1()) || ExportUtils.isCell(b)) continue;
                CellRangeAddress cra = new CellRangeAddress(b.getRow(), b.getRow2(), b.getCol(), b.getCol2());
                currentSheet.addMergedRegionUnsafe(cra);
            }
        }
        this.mutiPartMergeData.clear();
    }

    private void addHeadMergerData(int rowNum, int colNum) {
        AbstractDataWrapper.MergeBlock block = this.dataSource.getMergeBlock(rowNum, colNum);
        if (null != block) {
            this.headMergeData.add(block);
        }
    }

    public String getSheetName() {
        return this.currentSheet.getSheetName();
    }

    private void addFreezeLine(Sheet currentSheet) {
        this.dataSource.addFreezeLine(currentSheet);
    }

    private void addAnnotate(int rowNum, int colNum, org.apache.poi.ss.usermodel.Cell cell) {
        if (cell == null) {
            return;
        }
        if (this.dataSource.getSheet() == null) {
            return;
        }
        Cell theCell = this.dataSource.getSheet().getCell(rowNum, colNum, false);
        if (theCell == null) {
            return;
        }
        Comment theComment = theCell.getComment();
        if (theComment == null) {
            return;
        }
        Drawing drawing = this.currentSheet.createDrawingPatriarch();
        XSSFClientAnchor anchor = this.getDefaultRectFromString(rowNum, colNum, theComment.getText());
        org.apache.poi.ss.usermodel.Comment comment = drawing.createCellComment((ClientAnchor)anchor);
        comment.setString((RichTextString)new XSSFRichTextString(theComment.getText()));
        if (theComment.getAuthor() != null) {
            comment.setAuthor(theComment.getAuthor());
        }
        cell.setCellComment(comment);
    }

    private XSSFClientAnchor getDefaultRectFromString(int row, int col, String str) {
        str = str == null || "\n".equals(str) ? "" : str;
        String[] strs = str.split("\n");
        String maxLengthString = (String)Collections.max(Arrays.asList(strs), (Comparator)new Comparator<String>(){

            @Override
            public int compare(String str1, String str2) {
                int length2;
                int length1 = ExportUtils.getDefaultRealLength(str1);
                if (length1 == (length2 = ExportUtils.getDefaultRealLength(str2))) {
                    return 0;
                }
                if (length1 > length2) {
                    return 1;
                }
                return -1;
            }
        });
        int maxLength = ExportUtils.getDefaultRealLength(maxLengthString);
        int count = strs.length;
        if (maxLength > 156) {
            maxLength = 156;
            count = 0;
            for (String theStr : strs) {
                count += ExportUtils.getLineNumber(theStr, 151);
            }
        } else {
            maxLength = maxLength * 14 * 74 / 730;
        }
        int maxHeight = ExportUtils.getDefaultRealHeigh() * (count + 1) + ExportUtils.getDefaultLeading() * count;
        maxHeight = maxHeight * 9 * 21 / 108;
        Rectangle leftUp = SheetBaseMath.getCellRect((com.kingdee.bos.ctrl.excel.model.struct.Sheet)this.dataSource.getSheet(), (int)(row + 1), (int)(col + 1), (boolean)true);
        int rightDownRow = SheetBaseMath.rowAtPoint((com.kingdee.bos.ctrl.excel.model.struct.Sheet)this.dataSource.getSheet(), (Point2D)new Point(leftUp.x + maxLength, leftUp.y + maxHeight));
        int rightDownCol = SheetBaseMath.colAtPoint((com.kingdee.bos.ctrl.excel.model.struct.Sheet)this.dataSource.getSheet(), (Point2D)new Point(leftUp.x + maxLength, leftUp.y + maxHeight));
        return new XSSFClientAnchor(0, 0, 0, 0, col, row, Math.max(rightDownCol, col), Math.max(row, rightDownRow));
    }

    private void addStyle(int rowNum, int colNum, short valueType, org.apache.poi.ss.usermodel.Cell cell, Object value, boolean hasFormula) {
        boolean isDateValue;
        ShareStyleAttributes ssa = this.dataSource.SSAAt(rowNum, colNum);
        boolean bl = isDateValue = valueType == 6;
        if (ssa.isEmpty() && !isDateValue) {
            cell.setCellStyle(this.emptyStyle);
            return;
        }
        if (null != value && isDateValue && StringUtil.isEmptyString((String)ssa.getNumberFormat())) {
            Calendar cal;
            if (this.dateTimeStyle == null) {
                this.dateTimeStyle = this.workbook.createCellStyle();
                this.dateStyle = this.workbook.createCellStyle();
                Font dateFont = this.workbook.createFont();
                dateFont.setFontName(ssa.getFontName());
                dateFont.setFontHeightInPoints((short)ssa.getFontSize());
                this.dateTimeStyle.setDataFormat(this.format.getFormat("yyyy-m-d hh:mm"));
                this.dateTimeStyle.setFont(dateFont);
                this.dateStyle.setDataFormat(this.format.getFormat("yyyy-m-d"));
                this.dateStyle.setFont(dateFont);
            }
            if (value instanceof Date) {
                cal = Calendar.getInstance();
                cal.setTime((Date)value);
            } else {
                cal = (Calendar)value;
            }
            if (ssa.isEmpty()) {
                if (cal.get(12) != 0 || cal.get(11) != 0) {
                    cell.setCellStyle(this.dateTimeStyle);
                } else {
                    cell.setCellStyle(this.dateStyle);
                }
            } else {
                StyleAttributes sa = Styles.getSA((ShareStyleAttributes)ssa);
                if (cal.get(12) != 0 || cal.get(11) != 0) {
                    sa.setNumberFormat("yyyy-m-d hh:mm");
                } else {
                    sa.setNumberFormat("yyyy-m-d");
                }
                ssa = Styles.getSSA((StyleAttributes)sa);
                Integer hash = new Integer(ssa.hashCode());
                XSSFCellStyle style = (XSSFCellStyle)this.stylesMap.get(hash);
                if (style == null) {
                    XSSFCellStyle fullStyle = (XSSFCellStyle)this.workbook.createCellStyle();
                    this.parseStyle(ssa, fullStyle, hash, rowNum, colNum, false);
                    cell.setCellStyle((CellStyle)fullStyle);
                    fullStyle = null;
                } else {
                    cell.setCellStyle((CellStyle)style);
                }
            }
            return;
        }
        Integer hash = ssa.hashCode();
        XSSFCellStyle style = null;
        boolean setTextFormat = false;
        if (this.dataSource.isConvertFormula2Text() && (hasFormula || value instanceof String && StringUtil.isExcelFormula((String)value.toString()))) {
            style = this.textFormatStylesMap.get(hash);
            setTextFormat = true;
        } else {
            style = (XSSFCellStyle)this.stylesMap.get(hash);
        }
        if (style == null || DigitFormatPane.DataModel.isSpecialFormat((String)ssa.getNumberFormat())) {
            XSSFCellStyle fullStyle = (XSSFCellStyle)this.workbook.createCellStyle();
            this.parseStyle(ssa, fullStyle, hash, rowNum, colNum, setTextFormat);
            cell.setCellStyle((CellStyle)fullStyle);
            fullStyle = null;
        } else {
            cell.setCellStyle((CellStyle)style);
        }
    }

    private void parseStyle(ShareStyleAttributes ssa, XSSFCellStyle fullStyle, Integer id, int rowNum, int colNum, boolean setTextFormat) {
        Style stl = Styles.getStyle((ShareStyleAttributes)ssa);
        XSSFFont f = this.parseFont((ShareStyleAttributes)stl, id);
        fullStyle.setFont((Font)f);
        fullStyle.setLocked(stl.isLocked());
        FillPatternType pattern = this.parsePattern((ShareStyleAttributes)stl);
        if (pattern.getCode() == 0) {
            fullStyle.setFillPattern(pattern);
        } else if (pattern.getCode() == 1) {
            Color clr = stl.getBackground();
            if (Color.WHITE.equals(clr)) {
                fullStyle.setFillPattern(FillPatternType.NO_FILL);
            } else {
                fullStyle.setFillForegroundColor(this.parseColor(stl.getBackground()));
                fullStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            }
            fullStyle.setFillBackgroundColor(this.parseColor(stl.getFontColor()));
        } else {
            fullStyle.setFillBackgroundColor(this.parseColor(stl.getBackground()));
            fullStyle.setFillForegroundColor(this.parseColor(stl.getFontColor()));
            fullStyle.setFillPattern(pattern);
        }
        Styles.Position p = Styles.Position.LEFT;
        if (!LineStyle.isNull((LineStyle)stl.getBorderLineStyle(p))) {
            fullStyle.setBorderLeft(this.parseBorder((ShareStyleAttributes)stl, p));
            fullStyle.setLeftBorderColor(this.parseColor(stl.getBorderColor(p)));
        }
        if (!LineStyle.isNull((LineStyle)stl.getBorderLineStyle(p = Styles.Position.RIGHT))) {
            fullStyle.setBorderRight(this.parseBorder((ShareStyleAttributes)stl, p));
            fullStyle.setRightBorderColor(this.parseColor(stl.getBorderColor(p)));
        }
        if (!LineStyle.isNull((LineStyle)stl.getBorderLineStyle(p = Styles.Position.TOP))) {
            fullStyle.setBorderTop(this.parseBorder((ShareStyleAttributes)stl, p));
            fullStyle.setTopBorderColor(this.parseColor(stl.getBorderColor(p)));
        }
        if (!LineStyle.isNull((LineStyle)stl.getBorderLineStyle(p = Styles.Position.BOTTOM))) {
            fullStyle.setBorderBottom(this.parseBorder((ShareStyleAttributes)stl, p));
            fullStyle.setBottomBorderColor(this.parseColor(stl.getBorderColor(p)));
        }
        fullStyle.setAlignment(this.getHorizontalAlignment((ShareStyleAttributes)stl));
        fullStyle.setVerticalAlignment(this.getVerticalAlignment((ShareStyleAttributes)stl));
        fullStyle.setWrapText(stl.isWrapText());
        fullStyle.setShrinkToFit(stl.isShrinkText());
        if (stl.isShrinkText() && fullStyle.getAlignmentEnum() == HorizontalAlignment.JUSTIFY) {
            fullStyle.setAlignment(HorizontalAlignment.LEFT);
        }
        fullStyle.setRotation((short)(0 - (short)stl.getRotation()));
        fullStyle.setIndention((short)stl.getIndentation());
        if (stl.isVerticalText()) {
            fullStyle.setRotation((short)255);
        }
        if (this.dataSource.isBookProtected()) {
            fullStyle.setLocked(true);
        } else {
            fullStyle.setLocked(stl.isLocked());
        }
        fullStyle.setHidden(stl.isHided());
        String numberFormat = stl.getNumberFormat();
        if (numberFormat.length() != 0) {
            if (!"000000".equals(numberFormat) && DigitFormatPane.DataModel.isSpecialFormat((String)numberFormat)) {
                String cellText = this.dataSource.textAt(rowNum, colNum);
                if (StringUtil.isEmptyString((String)cellText)) {
                    numberFormat = "";
                } else {
                    numberFormat = cellText.replaceAll("\\.", "\\\\.");
                    numberFormat = numberFormat + ";" + numberFormat;
                    numberFormat = numberFormat.replaceAll("^-", "");
                }
            }
            if ("G/\u901a\u7528\u683c\u5f0f".equalsIgnoreCase(numberFormat)) {
                numberFormat = "General";
            }
            if (ExportUtils.isScience(numberFormat)) {
                numberFormat = numberFormat.substring(0, numberFormat.length() - 3) + "E+0";
            }
            numberFormat = numberFormat.replace("!", "\\");
            short builtInFormat = this.format.getFormat(numberFormat);
            fullStyle.setDataFormat(builtInFormat);
        }
        if (setTextFormat) {
            fullStyle.setDataFormat(this.textFormat);
            this.textFormatStylesMap.put(id, fullStyle);
        } else {
            this.stylesMap.put(id, fullStyle);
        }
    }

    private XSSFFont parseFont(ShareStyleAttributes ssa, Integer id) {
        XSSFFont cellFont = (XSSFFont)this.fontsMap.get(id);
        if (cellFont == null) {
            cellFont = (XSSFFont)this.workbook.createFont();
            cellFont.setFontName(ssa.getFontName());
            cellFont.setColor(this.parseColor(ssa.getFontColor()));
            cellFont.setFontHeightInPoints((short)ssa.getFontSize());
            if (ssa.isUnderline()) {
                cellFont.setUnderline((byte)1);
            }
            if (ssa.isStrikeThrough()) {
                cellFont.setStrikeout(true);
            }
            if (ssa.isBold()) {
                cellFont.setBold(true);
            }
            if (ssa.isItalic()) {
                cellFont.setItalic(true);
            }
            this.fontsMap.put(id, cellFont);
        }
        return cellFont;
    }

    private XSSFColor parseColor(Color awtColor) {
        return new XSSFColor(awtColor);
    }

    private BorderStyle parseBorder(ShareStyleAttributes ssa, Styles.Position pos) {
        PenStyle ps = ssa.getBorderPenStyle(pos);
        int width = ssa.getBorderLineStyle(pos).getWidth();
        switch (width) {
            case 0: {
                return BorderStyle.NONE;
            }
            case 1: {
                if (ps == PenStyle.PS_SOLID) {
                    return BorderStyle.THIN;
                }
                if (ps == PenStyle.PS_CONTINUOUS) {
                    return BorderStyle.DOTTED;
                }
                if (ps == PenStyle.PS_DOT) {
                    return BorderStyle.DASHED;
                }
                if (ps == PenStyle.PS_DASHDOTDOT) {
                    return BorderStyle.DASH_DOT;
                }
                if (ps == PenStyle.PS_DASHDOT) {
                    return BorderStyle.DASH_DOT_DOT;
                }
                return BorderStyle.THIN;
            }
        }
        if (ps == PenStyle.PS_SOLID || ps == PenStyle.PS_CONTINUOUS) {
            if (width == 2) {
                return BorderStyle.MEDIUM;
            }
            return BorderStyle.THICK;
        }
        if (ps == PenStyle.PS_DOT) {
            return BorderStyle.MEDIUM_DASHED;
        }
        if (ps == PenStyle.PS_DASHDOTDOT) {
            return BorderStyle.MEDIUM_DASH_DOT;
        }
        if (ps == PenStyle.PS_DASHDOT) {
            return BorderStyle.MEDIUM_DASH_DOT_DOT;
        }
        if (width == 2) {
            return BorderStyle.MEDIUM;
        }
        return BorderStyle.THICK;
    }

    private HorizontalAlignment getHorizontalAlignment(ShareStyleAttributes ssa) {
        short align = (short)ssa.getHorizontalAlign().getValue();
        HorizontalAlignment horizontalAlignment = align == HorizontalAlignment.LEFT.getCode() ? HorizontalAlignment.LEFT : (align == HorizontalAlignment.CENTER.getCode() ? HorizontalAlignment.CENTER : (align == HorizontalAlignment.RIGHT.getCode() ? HorizontalAlignment.RIGHT : HorizontalAlignment.GENERAL));
        return horizontalAlignment;
    }

    private VerticalAlignment getVerticalAlignment(ShareStyleAttributes ssa) {
        short align = (short)(ssa.getVerticalAlign().getValue() - 1);
        VerticalAlignment verticalAlignment = align == VerticalAlignment.TOP.getCode() ? VerticalAlignment.TOP : (align == VerticalAlignment.CENTER.getCode() ? VerticalAlignment.CENTER : (align == VerticalAlignment.BOTTOM.getCode() ? VerticalAlignment.BOTTOM : VerticalAlignment.TOP));
        return verticalAlignment;
    }

    FillPatternType parsePattern(ShareStyleAttributes ssa) {
        FillPatternType sret;
        switch (ssa.getPattern().getID()) {
            case 0: {
                sret = FillPatternType.NO_FILL;
                break;
            }
            case 1: {
                sret = FillPatternType.SOLID_FOREGROUND;
                break;
            }
            case 3: {
                sret = FillPatternType.FINE_DOTS;
                break;
            }
            case 26: {
                sret = FillPatternType.ALT_BARS;
                break;
            }
            case 19: {
                sret = FillPatternType.SPARSE_DOTS;
                break;
            }
            case 45: {
                sret = FillPatternType.THICK_HORZ_BANDS;
                break;
            }
            case 37: {
                sret = FillPatternType.THICK_VERT_BANDS;
                break;
            }
            case 20: {
                sret = FillPatternType.THICK_BACKWARD_DIAG;
                break;
            }
            case 28: {
                sret = FillPatternType.THICK_FORWARD_DIAG;
                break;
            }
            case 25: {
                sret = FillPatternType.BIG_SPOTS;
                break;
            }
            case 40: {
                sret = FillPatternType.BRICKS;
                break;
            }
            case 13: {
                sret = FillPatternType.THIN_HORZ_BANDS;
                break;
            }
            case 5: {
                sret = FillPatternType.THIN_VERT_BANDS;
                break;
            }
            case 4: {
                sret = FillPatternType.THIN_BACKWARD_DIAG;
                break;
            }
            case 12: {
                sret = FillPatternType.THIN_FORWARD_DIAG;
                break;
            }
            case 9: {
                sret = FillPatternType.SQUARES;
                break;
            }
            case 34: {
                sret = FillPatternType.DIAMONDS;
                break;
            }
            case 35: {
                sret = FillPatternType.LESS_DOTS;
                break;
            }
            case 43: {
                sret = FillPatternType.LEAST_DOTS;
                break;
            }
            default: {
                sret = FillPatternType.SOLID_FOREGROUND;
            }
        }
        return sret;
    }

    @Override
    public void setQueue(EventQueue q) {
        this.queue = q;
    }

    private void addAutoFilter(Sheet currentSheet) {
        if (null == this.dataSource.getSheet()) {
            return;
        }
        CellBlock block = this.dataSource.getSheet().getAutoFilterArea();
        if (null != block) {
            CellRangeAddress address = CellRangeAddress.valueOf((String)block.toString());
            currentSheet.setAutoFilter(address);
        }
    }

    private void addConditionalFormat(Sheet currentSheet) {
        if (null != this.dataSource && this.dataSource.getSheet() != null) {
            ConditionalFormatList cfs = this.dataSource.getSheet().getConditionalFormats();
            int size = cfs.size();
            for (int i = 0; i < size; ++i) {
                XSSFSheetConditionalFormatting xscf = (XSSFSheetConditionalFormatting)currentSheet.getSheetConditionalFormatting();
                ConditionalFormat cf = cfs.getConditionalFormat(i);
                CellBlock block = cf.getBlocks().getBounds();
                for (int j = 0; j < cf.getConditions().length; ++j) {
                    ShareStyleAttributes ssa = cf.getSSAs()[j];
                    Condition con = cf.getConditions()[j];
                    String qualifier = con.getQualifier();
                    XSSFConditionalFormattingRule fr = null;
                    String min = con.getMin();
                    String max = con.getMax();
                    if (!StringUtil.isEmptyString((String)min)) {
                        if (min.charAt(0) == '=') {
                            min = min.substring(1);
                        } else if (!StringUtil.isNumber((String)min)) {
                            min = "\"" + min + "\"";
                        }
                    }
                    if (!StringUtil.isEmptyString((String)max)) {
                        if (max.charAt(0) == '=') {
                            max = max.substring(1);
                        } else if (!StringUtil.isNumber((String)max)) {
                            max = "\"" + max + "\"";
                        }
                    }
                    if (con.getType().equalsIgnoreCase(Condition.Type_Value)) {
                        if (Condition.Between.equalsIgnoreCase(qualifier)) {
                            fr = xscf.createConditionalFormattingRule((byte)1, min, max);
                        } else if (Condition.NotBetween.equalsIgnoreCase(qualifier)) {
                            fr = xscf.createConditionalFormattingRule((byte)2, min, max);
                        } else if (Condition.Equal.equalsIgnoreCase(qualifier)) {
                            fr = xscf.createConditionalFormattingRule((byte)3, min);
                        } else if (Condition.NotEqual.equalsIgnoreCase(qualifier)) {
                            fr = xscf.createConditionalFormattingRule((byte)4, min);
                        } else if (Condition.Greater.equalsIgnoreCase(qualifier)) {
                            fr = xscf.createConditionalFormattingRule((byte)5, min);
                        } else if (Condition.Less.equalsIgnoreCase(qualifier)) {
                            fr = xscf.createConditionalFormattingRule((byte)6, min);
                        } else if (Condition.GreaterOrEqual.equalsIgnoreCase(qualifier)) {
                            fr = xscf.createConditionalFormattingRule((byte)7, min);
                        } else if (Condition.LessOrEqual.equalsIgnoreCase(qualifier)) {
                            fr = xscf.createConditionalFormattingRule((byte)8, min);
                        }
                    } else {
                        fr = xscf.createConditionalFormattingRule(min);
                    }
                    if (null != ssa && null != fr) {
                        Color c;
                        XSSFPatternFormatting pf = fr.createPatternFormatting();
                        Pattern pattern = ssa.getPattern();
                        if (null != pattern && pattern.getID() > 0 && pattern.getID() < 19) {
                            pf.setFillPattern((short)pattern.getID());
                        }
                        if (null != (c = ssa.getBackground())) {
                            XSSFColor xc = new XSSFColor(c);
                            String argbHex = xc.getARGBHex();
                            pf.setFillBackgroundColor(ColorUtil.getColorIndex(argbHex));
                        }
                        if (ssa.hasFontAttributes()) {
                            Color fontColr;
                            XSSFFontFormatting font = fr.createFontFormatting();
                            int fontSize = ssa.getFontSize();
                            if (0 != fontSize) {
                                font.setFontHeight(fontSize * 20);
                            }
                            if (null != (fontColr = ssa.getFontColor())) {
                                XSSFColor xc = new XSSFColor(fontColr);
                                String argbHex = xc.getARGBHex();
                                font.setFontColorIndex(ColorUtil.getColorIndex(argbHex));
                            }
                            font.setFontStyle(ssa.isItalic(), ssa.isBold());
                            if (ssa.isUnderline()) {
                                font.setUnderlineType((short)1);
                            }
                        }
                    }
                    CellRangeAddress[] cra = new CellRangeAddress[]{new CellRangeAddress(block.getRow(), block.getRow2(), block.getCol(), block.getCol2())};
                    xscf.addConditionalFormatting(cra, (ConditionalFormattingRule)fr);
                }
            }
        }
    }

    private void addDataValidations(Sheet currentSheet) {
        DataValidationHelper dvHelper = currentSheet.getDataValidationHelper();
        if (null == this.dataSource.getSheet()) {
            return;
        }
        ValidationList vList = this.dataSource.getSheet().getValidations();
        int vSize = vList.size();
        if (vSize != 0) {
            for (int i = 0; i < vSize; ++i) {
                Validation v = vList.getValidation(i);
                MessagedValidate vMsg = v.getMessagedValidate();
                int qualifierIndex = vMsg.getQualifierIndex();
                if (qualifierIndex == 1) {
                    qualifierIndex = 0;
                } else if (qualifierIndex == 0) {
                    qualifierIndex = 1;
                }
                if (StringUtil.isEmptyString((String)vMsg.getMin()) && StringUtil.isEmptyString((String)vMsg.getMax())) continue;
                XSSFDataValidationConstraint constraint = new XSSFDataValidationConstraint(CompareOnOperatorMapping.getSpread2ExcelIntMapping(vMsg.getTypeIndex()), qualifierIndex, vMsg.getMin(), vMsg.getMax());
                constraint.setOperator(qualifierIndex);
                if (MessagedValidate.Type_List.equals(vMsg.getType()) && vMsg.getMin().charAt(0) != '=') {
                    constraint.setExplicitListValues(vMsg.getMin().split(","));
                }
                CellRangeAddressList addressList = new CellRangeAddressList();
                SortedCellBlockArray blocks = v.getBlocks();
                for (int j = 0; j < blocks.size(); ++j) {
                    CellBlock block = blocks.getBlock(j);
                    addressList.addCellRangeAddress(block.getRow(), block.getCol(), block.getRow2(), block.getCol2());
                }
                DataValidation validation = dvHelper.createValidation((DataValidationConstraint)constraint, addressList);
                validation.setEmptyCellAllowed(vMsg.isUseBlank());
                if (MessagedValidate.STOP_STYLE.equals(vMsg.getErrorStyle())) {
                    validation.setErrorStyle(0);
                } else if (MessagedValidate.WARNING_STYLE.equals(vMsg.getErrorStyle())) {
                    validation.setErrorStyle(1);
                } else if (MessagedValidate.INFORMATION_STYLE.equals(vMsg.getErrorStyle())) {
                    validation.setErrorStyle(2);
                }
                validation.createErrorBox(vMsg.getErrorTitle(), vMsg.getErrorMessage());
                validation.createPromptBox(vMsg.getInputTitle(), vMsg.getInputMessage());
                validation.setShowErrorBox(!vMsg.isErrorHide());
                validation.setShowPromptBox(!vMsg.isInputHide());
                validation.setSuppressDropDownArrow(vMsg.hasCellRangeList());
                validation.setEmptyCellAllowed(!vMsg.isUseBlank());
                currentSheet.addValidationData(validation);
            }
        }
    }

    private void addEmbed(Sheet currentSheet) {
        int eoCount = this.dataSource.getEmbedObjectsCount();
        if (eoCount <= 0) {
            return;
        }
        SXSSFDrawing drawing = (SXSSFDrawing)currentSheet.createDrawingPatriarch();
        for (int i = 0; i < eoCount; ++i) {
            AbstractDataWrapper.EmbedObject eo = this.dataSource.getEmbedObject(i);
            if (eo == null || eo.getImageDatas() == null) continue;
            int pic = this.workbook.addPicture(eo.getImageDatas(), 6);
            XSSFClientAnchor anchor = new XSSFClientAnchor(eo.getDx1(), eo.getDy1(), eo.getDx2(), eo.getDy2(), eo.getCol(), eo.getRow(), eo.getCol2(), eo.getRow2());
            drawing.createPicture((ClientAnchor)anchor, pic);
        }
    }

    public void addHyperLink(int row, int col, org.apache.poi.ss.usermodel.Cell cell) {
        HyperLink hyper = this.dataSource.hyperLinkAt(row, col);
        if (hyper != null) {
            XSSFHyperlink link;
            String linkTo = hyper.getLinkTo();
            CreationHelper helper = this.workbook.getCreationHelper();
            if (linkTo.indexOf(33) != -1) {
                link = (XSSFHyperlink)helper.createHyperlink(HyperlinkType.DOCUMENT);
            } else {
                if (!StringUtil.isEmptyString((String)linkTo) && linkTo.startsWith("uri:")) {
                    linkTo = linkTo.substring("uri:".length());
                }
                link = (XSSFHyperlink)helper.createHyperlink(HyperlinkType.URL);
            }
            try {
                link.setAddress(linkTo);
                link.setLabel(hyper.getText());
                cell.setHyperlink((Hyperlink)link);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void addPrintSetup(Sheet currentSheet) {
        this.dataSource.addPrintSetup(currentSheet);
    }

    private void addPrintArea(Sheet currentSheet) {
        String areas = this.dataSource.getPrintArea();
        if (null != areas) {
            this.workbook.setPrintArea(this.workbook.getSheetIndex(currentSheet), areas);
        }
    }

    private void addProtection(Sheet currentSheet) {
        this.dataSource.addProtection(currentSheet);
    }

    private void addGridLine(Sheet currentSheet) {
        CTWorksheet ctWorkbook = AbstractDataWrapper.getCtWorksheet(currentSheet);
        if (null != ctWorkbook) {
            ctWorkbook.getSheetViews().getSheetViewArray(0).setShowGridLines(this.dataSource.isExportGridLine() && this.dataSource.isShowHoriLines() && this.dataSource.isShowVertLines());
        }
    }

    private void addGroupInfo(Sheet currentSheet) {
        this.dataSource.addGroupInfo(currentSheet);
    }

    public void setSheetView(Sheet xssfSheet) {
        this.dataSource.setSheetView(xssfSheet);
    }
}

