/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.formbrowser2.actions;

import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.kdf.formbrowser2.actions.BrowserInitializableAction;
import com.kingdee.bos.ctrl.kdf.formbrowser2.clientcore.ClientCore;
import com.kingdee.bos.ctrl.kdf.formbrowser2.clientcore.UIDelegate;
import com.kingdee.bos.ctrl.kdf.formbrowser2.resources.Resources;
import com.kingdee.bos.ctrl.kdf.printprovider.PrintCompContainer;
import com.kingdee.bos.ctrl.kdf.printprovider.actions.CompositableAction;
import com.kingdee.bos.ctrl.kdf.printprovider.util.ExtensionFilter;
import com.kingdee.bos.ctrl.kdf.util.CloseUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class SaveSnapShotAction
extends AbstractAction
implements CompositableAction,
BrowserInitializableAction {
    private static final long serialVersionUID = 1263079486308612662L;
    private static Logger logger = LogUtil.getPackageLogger(SaveSnapShotAction.class);
    private static transient int savedFileIndex = 1;
    private transient UIDelegate uidelegate;
    private transient ClientCore clientCore;

    public SaveSnapShotAction() {
        this.putValue("Name", Resources.theRes.getString("action.save-snapshot.name"));
        this.putValue("ShortDescription", Resources.theRes.getString("action.save-snapshot.description"));
        this.putValue("MnemonicKey", Resources.theRes.getObject("action.save-snapshot.mnemonic"));
        this.putValue("ICON24", Resources.theRes.getObject("action.save-snapshot.icon"));
        this.putValue("DEFAULT_ENABLE", true);
        this.putValue("ENABLE_UNTIL_DATACOMPLETED", true);
    }

    @Override
    public void setClientCore(ClientCore clientCore) {
        this.uidelegate = clientCore.getUiDelegate();
        this.clientCore = clientCore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent event) {
        String path = this.getSavePath();
        if (path == null) {
            return;
        }
        FileOutputStream outs = null;
        try {
            outs = new FileOutputStream(path);
            this.clientCore.getFormPageRetriver().saveSnapShot(outs);
            JOptionPane.showMessageDialog(this.uidelegate.getBaseComponent(), Resources.LOCAL_STR("file-save-ok", "Done !"));
        }
        catch (FileNotFoundException e) {
            try {
                logger.error((Object)"Exception occurred.", (Throwable)e);
            }
            catch (Throwable throwable) {
                CloseUtil.close((Closeable[])new Closeable[]{outs});
                throw throwable;
            }
            CloseUtil.close((Closeable[])new Closeable[]{outs});
        }
        CloseUtil.close((Closeable[])new Closeable[]{outs});
    }

    private String getSavePath() {
        int ret;
        String subfix = ".kdf";
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle(Resources.LOCAL_STR("save-snapshot-name", "Save File As"));
        String[] filter = new String[]{Resources.LOCAL_STR("kdf-file-filter", "KDF (*.kdf)")};
        FileFilter[] filters = new FileFilter[]{new ExtensionFilter(filter[0], new String[]{subfix, ".KDF"})};
        chooser.setFileFilter(filters[0]);
        String fileName = Resources.LOCAL_STR("kdf-save-name", "Form");
        fileName = fileName + savedFileIndex + ".kdf";
        chooser.setSelectedFile(new File(fileName));
        Component comp = this.uidelegate.getBaseComponent();
        if (comp == null) {
            return null;
        }
        if (this.clientCore.getLastDir() != null) {
            chooser.setCurrentDirectory(new File(this.clientCore.getLastDir()));
        }
        if ((ret = chooser.showSaveDialog(comp)) == 0) {
            int rt;
            this.clientCore.setLastDir(chooser.getCurrentDirectory().getPath());
            File selectedFile = chooser.getSelectedFile();
            if (selectedFile.exists() && (rt = JOptionPane.showConfirmDialog(comp, Resources.LOCAL_STR("file-exist-tip", "File Exist, Replace it ?"), "", 0)) != 0) {
                return null;
            }
            String path = selectedFile.getPath();
            if (path != null) {
                char[] last4 = new char[4];
                path.getChars(path.length() - 4, path.length(), last4, 0);
                if (!subfix.equalsIgnoreCase(new String(last4))) {
                    path = path + subfix;
                }
                ++savedFileIndex;
                return path;
            }
        }
        return null;
    }

    @Override
    public void setCompContainer(PrintCompContainer container) {
    }
}

