/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.formbrowser2.commands;

import com.kingdee.bos.ctrl.kdf.formbrowser2.clientcore.ClientCore;
import com.kingdee.bos.ctrl.kdf.formbrowser2.clientcore.ContextOfBrowser;
import com.kingdee.bos.ctrl.kdf.formbrowser2.clientcore.LayerManager;
import com.kingdee.bos.ctrl.kdf.formbrowser2.commands.Command;
import com.kingdee.bos.ctrl.kdf.formbrowser2.commands.CommandException;
import com.kingdee.bos.ctrl.kdf.formbrowser2.commands.GotoPageCommand;
import com.kingdee.bos.ctrl.kdf.formbrowser2.commands.SelectLayerCommand;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.UndoManager;

public class CommandFactory {
    public UndoManager undoMgr = new UndoManager();
    public ClientCore compManager;
    public static final String CMD_SET_LAYERS = "set_layers";
    public static final String CMD_SETUP_PRINTER = "setup_printer";
    public static final String CMD_GOTOPAGE = "goto_page";
    private static CommandFactory theFactory;

    protected CommandFactory(ClientCore manager) {
        this.compManager = manager;
    }

    public static CommandFactory getInstance(ClientCore manager) {
        if (theFactory == null) {
            theFactory = new CommandFactory(manager);
        }
        if (CommandFactory.theFactory.compManager != manager) {
            CommandFactory.theFactory.compManager = manager;
        }
        return theFactory;
    }

    public Command create(String id) throws CommandException {
        AbstractUndoableEdit retCmd;
        if (id.equals(CMD_SET_LAYERS)) {
            LayerManager lm = this.compManager.getLayerManager();
            retCmd = new SelectLayerCommand(lm);
        } else if (id.equals(CMD_GOTOPAGE)) {
            ContextOfBrowser context = this.compManager.getContextOfBrowser();
            retCmd = new GotoPageCommand(context);
        } else if (id.equals(CMD_SETUP_PRINTER)) {
            retCmd = null;
        } else {
            throw new CommandException("unrecognizeable command id");
        }
        this.undoMgr.addEdit(retCmd);
        return retCmd;
    }
}

