/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.formbrowser2.formobjects.render.SimpleRenderUtil;

import com.kingdee.bos.ctrl.common.util.STConverter;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.formbrowser2.formobjects.FormObject;
import com.kingdee.bos.ctrl.kdf.formbrowser2.formobjects.TextObject;
import com.kingdee.bos.ctrl.kdf.formbrowser2.formobjects.render.SimpleRenderUtil.AbstractContainerRender;
import com.kingdee.bos.ctrl.kdf.printprovider.PrinterAttrManager;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Map;
import java.util.StringTokenizer;

public class SimpleTextRender
extends AbstractContainerRender {
    public static String treatNewLineChars(String source) {
        String result = source;
        if (source != null && source.length() > 0) {
            StringBuffer sbuffer = new StringBuffer(source);
            int offset = source.length() - 1;
            int pos = source.lastIndexOf("\n\n", offset);
            while (pos >= 0 && offset > 0) {
                sbuffer = sbuffer.insert(pos + 1, " ");
                offset = pos - 1;
                pos = source.lastIndexOf("\n\n", offset);
            }
            if (sbuffer.charAt(sbuffer.length() - 1) == '\n') {
                sbuffer.append(' ');
            }
            if (sbuffer.charAt(0) == '\n') {
                sbuffer.insert(0, ' ');
            }
            result = sbuffer.toString();
        }
        result = SimpleTextRender.replaceTabWithBlank(result);
        return result;
    }

    public static String replaceTabWithBlank(String source) {
        String result = source;
        if (source != null && source.length() > 0) {
            StringBuffer sbuffer = new StringBuffer(source);
            int offset = 0;
            int pos = source.indexOf("\t", offset);
            while (pos >= 0) {
                sbuffer.setCharAt(pos, ' ');
                offset = pos + 1;
                pos = source.indexOf("\t", offset);
            }
            result = sbuffer.toString();
        }
        return result;
    }

    @Override
    public void drawObject(Graphics g, FormObject formObj, int x_off, int y_off, float factor) {
        if (!(formObj instanceof TextObject)) {
            return;
        }
        TextObject textObj = (TextObject)formObj;
        String text = textObj.getText();
        if (!StringUtil.isEmptyString((String)text)) {
            if ("GBK".equalsIgnoreCase(PrinterAttrManager.textCoding)) {
                text = STConverter.tc2sc((String)text);
            } else if ("BIG5".equalsIgnoreCase(PrinterAttrManager.textCoding)) {
                text = STConverter.sc2tc((String)text);
            }
        }
        textObj.setText(text);
        Shape savedClip = g.getClip();
        Rectangle clip = new Rectangle(textObj.getZoomedDim(textObj.x) - x_off, textObj.getZoomedDim(textObj.y) - y_off, textObj.getZoomedDim(textObj.width) + 1, textObj.getZoomedDim(textObj.height) + 1);
        if (g.getClipBounds() != null) {
            clip = clip.intersection(g.getClipBounds());
        }
        g.setClip(clip);
        g.setColor(textObj.getFgcolor());
        if (textObj.getFont() == null) {
            int style = 0;
            if (textObj.isBold()) {
                style |= 1;
            }
            if (textObj.isItalic()) {
                style |= 2;
            }
            if (style == 0) {
                style = 0;
            }
            textObj.setFont(new Font(textObj.getFontName(), style, textObj.getZoomedDim(textObj.getFontSize())));
        }
        if (textObj.getText() != null && textObj.getText().length() > 0) {
            LineBreakMeasurer lineMeasurer;
            int paragraphEnd;
            int paragraphStart;
            AttributedCharacterIterator paragraph;
            AttributedString atext;
            int zoomedFieldHeight = textObj.getZoomedDim(textObj.height);
            String allText = SimpleTextRender.treatNewLineChars(textObj.getText());
            double formatWidth = textObj.getZoomedDim(textObj.width);
            double verticalOffset = 0.0;
            FontRenderContext fontRenderContext = ((Graphics2D)g).getFontRenderContext();
            Map<TextAttribute, ?> fontAttributes = textObj.getFont().getAttributes();
            fontAttributes.put(TextAttribute.SIZE, new Float(textObj.getZoomedDim(textObj.getFontSize())));
            fontAttributes.put(TextAttribute.FAMILY, textObj.getFontName());
            if (textObj.isBold()) {
                fontAttributes.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
            }
            if (textObj.isItalic()) {
                fontAttributes.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
            }
            if (textObj.isUnderline()) {
                fontAttributes.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
            }
            if (textObj.isStrikeTrought()) {
                fontAttributes.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
            }
            double lineSpacing = 1.0;
            TextLayout layout = null;
            String paragr_text = "";
            boolean isMaxHeightReached = false;
            StringTokenizer tkzer = new StringTokenizer(allText, "\n");
            double drawPosY = 0.0;
            double drawPosX = 0.0;
            while (tkzer.hasMoreTokens() && !isMaxHeightReached) {
                paragr_text = tkzer.nextToken();
                atext = new AttributedString(paragr_text, fontAttributes);
                paragraph = atext.getIterator();
                paragraphStart = paragraph.getBeginIndex();
                paragraphEnd = paragraph.getEndIndex();
                lineMeasurer = new LineBreakMeasurer(paragraph, fontRenderContext);
                lineMeasurer.setPosition(paragraphStart);
                layout = null;
                while (lineMeasurer.getPosition() < paragraphEnd && !isMaxHeightReached) {
                    layout = lineMeasurer.nextLayout((float)formatWidth);
                    if ((drawPosY += (double)layout.getLeading() + lineSpacing * (double)layout.getAscent()) + (double)layout.getDescent() <= (double)(zoomedFieldHeight + 1)) {
                        drawPosY += (double)layout.getDescent();
                        continue;
                    }
                    drawPosY -= (double)layout.getLeading() + lineSpacing * (double)layout.getAscent();
                    isMaxHeightReached = false;
                }
            }
            double textHeight = drawPosY;
            if (textObj.getVerticalAlign().equals("top")) {
                verticalOffset = 0.0;
            } else if (textObj.getVerticalAlign().equals("middle")) {
                verticalOffset = ((double)zoomedFieldHeight - textHeight) / 2.0;
            } else if (textObj.getVerticalAlign().equals("bottom")) {
                verticalOffset = (double)zoomedFieldHeight - textHeight;
            }
            drawPosY = 0.0;
            drawPosX = 0.0;
            paragr_text = "";
            isMaxHeightReached = false;
            tkzer = new StringTokenizer(allText, "\n");
            while (tkzer.hasMoreTokens() && !isMaxHeightReached) {
                paragr_text = tkzer.nextToken();
                atext = new AttributedString(paragr_text, fontAttributes);
                paragraph = atext.getIterator();
                paragraphStart = paragraph.getBeginIndex();
                paragraphEnd = paragraph.getEndIndex();
                lineMeasurer = new LineBreakMeasurer(paragraph, fontRenderContext);
                lineMeasurer.setPosition(paragraphStart);
                layout = null;
                while (lineMeasurer.getPosition() < paragraphEnd && !isMaxHeightReached) {
                    layout = lineMeasurer.nextLayout((float)formatWidth);
                    if ((drawPosY += (double)layout.getLeading() + lineSpacing * (double)layout.getAscent()) + (double)layout.getDescent() <= (double)(zoomedFieldHeight + 1)) {
                        if (textObj.getAlign().equals("Justify")) {
                            drawPosX = layout.isLeftToRight() ? 0.0 : formatWidth - (double)layout.getAdvance();
                            if (lineMeasurer.getPosition() < paragraphEnd) {
                                layout = layout.getJustifiedLayout((float)formatWidth);
                            }
                        } else {
                            drawPosX = textObj.getAlign().equals("right") ? (layout.isLeftToRight() ? formatWidth - (double)layout.getAdvance() : formatWidth) : (textObj.getAlign().equals("center") ? (formatWidth - (double)layout.getAdvance()) / 2.0 : (layout.isLeftToRight() ? 0.0 : formatWidth - (double)layout.getAdvance()));
                        }
                        layout.draw((Graphics2D)g, (float)(drawPosX + (double)textObj.getZoomedDim(textObj.x) - (double)x_off), (float)(drawPosY + (double)textObj.getZoomedDim(textObj.y) - (double)y_off + verticalOffset));
                        drawPosY += (double)layout.getDescent();
                        continue;
                    }
                    drawPosY -= (double)layout.getLeading() + lineSpacing * (double)layout.getAscent();
                    isMaxHeightReached = true;
                }
            }
        }
        g.setClip(savedClip);
    }
}

